/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.ContentRating;
import com.uwetrottmann.tmdb2.entities.ProductionCompany;
import com.uwetrottmann.tmdb2.entities.TvEpisode;
import com.uwetrottmann.tmdb2.entities.TvResultsPage;
import com.uwetrottmann.tmdb2.entities.TvSeason;
import com.uwetrottmann.tmdb2.entities.TvShow;
import com.uwetrottmann.tmdb2.entities.TvShowComplete;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.tmdb.TmdbConnectionCounter;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;

class TmdbTvShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private Tmdb api;

    public TmdbTvShowMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (query.getMediaType() != MediaType.TV_SHOW) {
            throw new Exception("wrong media type for this scraper");
        }
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)query.getQuery())) {
            searchString = query.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("TMDB Scraper: empty searchString");
            return resultList;
        }
        searchString = MetadataUtil.removeNonSearchCharacters((String)searchString);
        String language = query.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)query.getLanguage().getCountry())) {
            language = language + "-" + query.getLanguage().getCountry();
        }
        LOGGER.info("========= BEGIN TMDB Scraper Search for: " + searchString);
        TvResultsPage resultsPage = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                resultsPage = (TvResultsPage)this.api.searchService().tv(searchString, 1, language, null, "phrase").execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: " + e.getMessage());
            }
        }
        if (resultsPage == null || resultsPage.results == null) {
            LOGGER.info("found 0 results");
            return resultList;
        }
        LOGGER.info("found " + resultsPage.results.size() + " results");
        for (TvShow show : resultsPage.results) {
            MediaSearchResult result = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.TV_SHOW);
            result.setId(Integer.toString(show.id));
            result.setTitle(show.name);
            result.setOriginalTitle(show.original_name);
            result.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + show.poster_path);
            if (show.first_air_date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(show.first_air_date);
                result.setYear(calendar.get(1));
            }
            result.setScore(MetadataUtil.calculateScore((String)searchString, (String)result.getTitle()));
            resultList.add(result);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getEpisodeList() " + options.toString());
        ArrayList<MediaEpisode> episodes = new ArrayList<MediaEpisode>();
        int tmdbId = 0;
        if (options.getResult() != null) {
            tmdbId = Integer.parseInt(options.getResult().getId());
        }
        if (tmdbId == 0) {
            tmdbId = options.getTmdbId();
        }
        if (tmdbId == 0) {
            return episodes;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                TvShowComplete complete = (TvShowComplete)this.api.tvService().tv(tmdbId, language, null).execute().body();
                if (complete != null) {
                    for (TvSeason season : ListUtils.nullSafe(complete.seasons)) {
                        TmdbConnectionCounter.trackConnections();
                        TvSeason fullSeason = (TvSeason)this.api.tvSeasonsService().season(tmdbId, season.season_number, language, null).execute().body();
                        if (fullSeason == null) continue;
                        for (TvEpisode episode : ListUtils.nullSafe(fullSeason.episodes)) {
                            MediaEpisode ep = new MediaEpisode(TmdbMetadataProvider.providerInfo.getId());
                            ep.episode = episode.episode_number;
                            ep.season = episode.season_number;
                            ep.title = episode.name;
                            if (episode.vote_average != null) {
                                ep.rating = episode.vote_average.floatValue();
                            }
                            if (episode.air_date != null) {
                                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                                ep.firstAired = formatter.format((Object)episode.air_date);
                            }
                            ep.voteCount = episode.vote_count;
                            ep.ids.put(TmdbMetadataProvider.providerInfo.getId(), episode.id);
                            episodes.add(ep);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: " + e.getMessage());
            }
        }
        return episodes;
    }

    MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        throw new Exception("unsupported media type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getTvShowMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = 0;
        if (options.getResult() != null) {
            tmdbId = Integer.parseInt(options.getResult().getId());
        }
        if (tmdbId == 0) {
            tmdbId = options.getTmdbId();
        }
        if (tmdbId == 0) {
            return md;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        TvShowComplete complete = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                complete = (TvShowComplete)this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS)).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
            }
        }
        if (complete == null) {
            return md;
        }
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)tmdbId);
        md.setTitle(complete.name);
        md.setOriginalTitle(complete.original_name);
        md.setRating(complete.vote_average);
        md.setVoteCount(complete.vote_count);
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + complete.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + complete.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(complete.id.intValue());
            md.addMediaArt(ma);
        }
        for (ProductionCompany company : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(complete.credits.cast)) {
                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                cm.setName(castMember.name);
                cm.setName(castMember.character);
                md.addCastMember(cm);
            }
        }
        if (complete.external_ids != null) {
            if (complete.external_ids.tvdb_id != null && complete.external_ids.tvdb_id > 0) {
                md.setId("tvdb", (Object)complete.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)complete.external_ids.imdb_id)) {
                md.setId("imdb", (Object)complete.external_ids.imdb_id);
            }
            if (complete.external_ids.tvrage_id != null && complete.external_ids.tvrage_id > 0) {
                md.setId("tvrage", (Object)complete.external_ids.tvrage_id);
            }
        }
        if (complete.content_ratings != null) {
            for (ContentRating country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (options.getCountry() != null && options.getCountry().getAlpha2().compareToIgnoreCase(country.iso_3166_1) != 0 || StringUtils.isEmpty((CharSequence)country.rating)) continue;
                md.addCertification(Certification.getCertification((String)country.iso_3166_1, (String)country.rating));
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getEpisodeMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = 0;
        if (options.getResult() != null) {
            tmdbId = Integer.parseInt(options.getResult().getId());
        }
        if (tmdbId == 0) {
            tmdbId = options.getTmdbId();
        }
        if (tmdbId == 0) {
            return md;
        }
        int seasonNr = -1;
        int episodeNr = -1;
        try {
            seasonNr = Integer.parseInt(options.getId("seasonNr"));
            episodeNr = Integer.parseInt(options.getId("episodeNr"));
        }
        catch (Exception e) {
            LOGGER.warn("error parsing season/episode number");
        }
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (seasonNr == -1 || episodeNr == -1) {
            return md;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        TvEpisode episode = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            block22: {
                TmdbConnectionCounter.trackConnections();
                try {
                    TvSeason fullSeason = (TvSeason)this.api.tvSeasonsService().season(tmdbId, seasonNr, language, null).execute().body();
                    if (fullSeason == null) break block22;
                    for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                        if (ep.season_number != seasonNr || ep.episode_number != episodeNr) continue;
                        episode = ep;
                        break;
                    }
                    if (episode != null || aired.isEmpty()) break block22;
                    for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                        SimpleDateFormat formatter;
                        String epAired;
                        if (ep.air_date == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)ep.air_date)).equals(aired)) continue;
                        episode = ep;
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("failed to get meta data: " + e.getMessage());
                }
            }
        }
        if (episode == null) {
            return md;
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.episode_number}));
        md.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.season_number}));
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)episode.id);
        if (episode.external_ids != null) {
            if (episode.external_ids.tvdb_id != null && episode.external_ids.tvdb_id > 0) {
                md.setId("tvdb", (Object)episode.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)episode.external_ids.imdb_id)) {
                md.setId("imdb", (Object)episode.external_ids.imdb_id);
            }
            if (episode.external_ids.tvrage_id != null && episode.external_ids.tvrage_id > 0) {
                md.setId("tvrage", (Object)episode.external_ids.tvrage_id);
            }
        }
        md.setTitle(episode.name);
        md.setPlot(episode.overview);
        md.setRating(episode.vote_average);
        md.setVoteCount(episode.vote_count);
        md.setReleaseDate(episode.air_date);
        for (CastMember castMember : ListUtils.nullSafe(episode.guest_stars)) {
            MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            cm.setName(castMember.name);
            cm.setName(castMember.character);
            md.addCastMember(cm);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.still_path) && (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.THUMB)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            md.addMediaArt(ma);
        }
        return md;
    }
}

