/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRewriteEpisodeNfoAction
extends AbstractAction {
    private static final long serialVersionUID = 5762347331284295996L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowRewriteEpisodeNfoAction() {
        this.putValue("Name", BUNDLE.getString("tvshowepisode.rewritenfo"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(BUNDLE.getString("tvshowepisode.rewritenfo"), selectedEpisodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShowEpisode episode : selectedEpisodes) {
                    episode.writeNFO();
                    episode.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

