/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReleaseInfo.class);
    private static String version;
    private static String build;
    private static String buildDate;

    public static String getVersion() {
        String v = version;
        if (v.isEmpty()) {
            v = ReleaseInfo.isNightly() ? "NIGHTLY" : (ReleaseInfo.isPreRelease() ? "PRE-RELEASE" : "GIT");
        }
        return v;
    }

    public static String getVersionForReporting() {
        String v = version;
        if (ReleaseInfo.isGitBuild()) {
            v = "GIT";
        } else if (ReleaseInfo.isNightly()) {
            v = "NIGHTLY";
        } else if (ReleaseInfo.isPreRelease()) {
            v = "PRE-RELEASE";
        }
        return v;
    }

    public static String getBuild() {
        return build;
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public static boolean isNightly() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("nightly");
    }

    public static boolean isPreRelease() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("prerelease");
    }

    public static boolean isGitBuild() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("git");
    }

    public static boolean isReleaseBuild() {
        return !ReleaseInfo.isNightly() && !ReleaseInfo.isPreRelease() && !ReleaseInfo.isGitBuild();
    }

    public static String getRealVersion() {
        String v = ReleaseInfo.getManifestEntry(ReleaseInfo.class, "Implementation-Version");
        if (v.isEmpty()) {
            v = ReleaseInfo.getVersion() + " - GIT";
        }
        if (ReleaseInfo.isNightly()) {
            v = v + " - NIGHTLY";
        } else if (ReleaseInfo.isPreRelease()) {
            v = v + " - PRE-RELEASE";
        }
        return v;
    }

    public static String getRealBuildDate() {
        String b = ReleaseInfo.getManifestEntry(ReleaseInfo.class, "Build-Date");
        if (b.isEmpty()) {
            b = ReleaseInfo.getBuildDate();
        }
        return b;
    }

    public static Manifest getManifest(Class c) {
        Manifest mf = null;
        try {
            String basepath;
            FileInputStream is;
            String classname = "/" + c.getName().replaceAll("\\.", "/") + ".class";
            URL jarURL = c.getResource(classname);
            if (jarURL.getProtocol().equals("jar")) {
                JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
                mf = jurlConn.getManifest();
            } else if (jarURL.getProtocol().equals("file") && (is = new FileInputStream((basepath = jarURL.getPath().substring(0, jarURL.getPath().indexOf(classname))) + "/META-INF/MANIFEST.MF")) != null) {
                mf = new Manifest(is);
            }
        }
        catch (Exception e) {
            mf = null;
        }
        return mf;
    }

    public static String getManifestEntry(Class c, String entry) {
        String s = "";
        try {
            Manifest mf = ReleaseInfo.getManifest(c);
            Attributes attr = mf.getMainAttributes();
            s = attr.getValue(entry);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("version");
            Properties releaseInfoProp = new Properties();
            releaseInfoProp.load(fileInputStream);
            version = releaseInfoProp.getProperty("version");
            build = releaseInfoProp.getProperty("build");
            buildDate = releaseInfoProp.getProperty("date");
        }
        catch (IOException e) {
            try {
                fileInputStream = new FileInputStream("target/classes/eclipse.properties");
                Properties releaseInfoProp = new Properties();
                releaseInfoProp.load(fileInputStream);
                version = releaseInfoProp.getProperty("version");
                build = "git";
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                buildDate = formatter.format((Object)new Date());
            }
            catch (IOException e2) {
                version = "";
                build = "git";
                buildDate = "";
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

