/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;

public class BorderCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -6545791732880295743L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(table.getForeground());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
        }
        Component comp = super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        Border defaultBorder = ((JComponent)comp).getBorder();
        defaultBorder = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        this.setBorder(defaultBorder);
        if (value instanceof Movie) {
            Movie movie = (Movie)value;
            this.setValue(movie.getTitleSortable());
            if (movie.isNewlyAdded()) {
                this.setHorizontalTextPosition(10);
                this.setIcon(IconManager.NEW);
            } else {
                this.setIcon(null);
            }
        } else if (value != null) {
            this.setValue(value.toString());
        } else {
            this.setValue("");
        }
        return this;
    }
}

