/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamer.class);
    private static final TvShowSettings SETTINGS = TvShowModuleManager.SETTINGS;
    private static final String[] seasonNumbers = new String[]{"$1", "$2", "$3", "$4"};
    private static final String[] episodeNumbers = new String[]{"$E", "$D"};
    private static final String[] episodeTitles = new String[]{"$T"};
    private static final String[] showTitles = new String[]{"$N", "$M"};
    private static final Pattern epDelimiter = Pattern.compile("(\\s?(folge|episode|[epx]+)\\s?)?\\$[ED]", 2);
    private static final Pattern seDelimiter = Pattern.compile("((staffel|season|s)\\s?)?[\\$][1234]", 2);
    private static final Pattern token = Pattern.compile("(\\$[\\w#])");

    private static String lz(int num) {
        return String.format("%02d", num);
    }

    public static void renameTvShowRoot(TvShow show) {
        LOGGER.debug("TV show year: " + show.getYear());
        LOGGER.debug("TV show path: " + show.getPath());
        String newPathname = TvShowRenamer.generateTvShowDir(SETTINGS.getRenamerTvShowFoldername(), show);
        String oldPathname = show.getPath();
        if (!newPathname.isEmpty()) {
            Path srcDir = Paths.get(oldPathname, new String[0]);
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                try {
                    boolean ok;
                    if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                        Files.createDirectory(destDir.getParent(), new FileAttribute[0]);
                    }
                    if (ok = Utils.moveDirectorySafe(srcDir, destDir)) {
                        show.updateMediaFilePath(srcDir, destDir);
                        show.setPath(newPathname);
                        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                            episode.replacePathForRenamedFolder(srcDir, destDir);
                            episode.updateMediaFilePath(srcDir, destDir);
                        }
                        show.saveToDb();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error moving folder: ", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
    }

    public static void renameEpisode(TvShowEpisode episode) {
        if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
            LOGGER.warn("failed to rename episode " + episode.getTitle() + " (TV show " + episode.getTvShow().getTitle() + ") - invalid season/episode number");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode.getTvShow().getTitle(), "tvshow.renamer.failedrename", new String[]{episode.getTitle()}));
            return;
        }
        if (episode.isDisc()) {
            TvShowRenamer.renameDiscEpisode(episode);
        } else {
            LOGGER.info("Renaming TvShow '" + episode.getTvShow().getTitle() + "' Episode " + episode.getEpisode());
            for (MediaFile mf : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                TvShowRenamer.renameMediaFile(mf, episode.getTvShow());
            }
        }
    }

    private static void renameDiscEpisode(TvShowEpisode episode) {
        String newFoldername;
        Path epFolder = episode.getPathNIO();
        TvShow show = episode.getTvShow();
        String seasonName = TvShowRenamer.generateSeasonDir(SETTINGS.getRenamerSeasonFoldername(), episode);
        Path seasonDir = show.getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonName) && !Files.exists(seasonDir = show.getPathNIO().resolve(seasonName), new LinkOption[0])) {
            try {
                Files.createDirectory(seasonDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (show.getPathNIO().toString().equals(episode.getPathNIO().toString())) {
            LOGGER.error("Episode is labeled as 'on BD/DVD', but files are in show root. Cannot rename episode o_O");
            return;
        }
        MediaFile mf = episode.getMediaFiles(MediaFileType.VIDEO).get(0);
        Path disc = mf.getFileAsPath().getParent().toAbsolutePath();
        String folder = show.getPathNIO().relativize(disc).toString().toUpperCase(Locale.ROOT);
        while (folder.contains("BDMV") || folder.contains("VIDEO_TS")) {
            disc = disc.getParent();
            folder = show.getPathNIO().relativize(disc).toString().toUpperCase(Locale.ROOT);
        }
        if (!disc.getFileName().toString().equalsIgnoreCase("BDMV") && !disc.getFileName().toString().equalsIgnoreCase("VIDEO_TS")) {
            LOGGER.error("Episode is labeled as 'on BD/DVD', but structure seems not to match. Better exit and do nothing... o_O");
        }
        if ((newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFolderename(show, mf))) != null && !newFoldername.isEmpty()) {
            Path newEpFolder = seasonDir.resolve(newFoldername);
            Path newDisc = newEpFolder.resolve(disc.getFileName());
            if (disc.toAbsolutePath().toString().equals(episode.getPathNIO().toString())) {
                newDisc = newEpFolder;
            }
            try {
                List<MediaFile> thumbs;
                if (!epFolder.toAbsolutePath().toString().equals(newEpFolder.toAbsolutePath().toString())) {
                    boolean ok = false;
                    try {
                        if (!Files.exists(newEpFolder.getParent(), new LinkOption[0])) {
                            Files.createDirectory(newEpFolder.getParent(), new FileAttribute[0]);
                        }
                        ok = Utils.moveDirectorySafe(epFolder, newEpFolder);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)epFolder, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (ok) {
                        LOGGER.debug("updating *all* MFs for new path -> " + newEpFolder);
                        episode.updateMediaFilePath(disc, newDisc);
                        episode.updateMediaFilePath(epFolder, newEpFolder);
                        episode.setPath(newEpFolder.toAbsolutePath().toString());
                        episode.saveToDb();
                    }
                    TvShowRenamer.cleanEmptyDir(epFolder);
                }
                if ((thumbs = episode.getMediaFiles(MediaFileType.THUMB)) != null && !thumbs.isEmpty()) {
                    MediaFile th = thumbs.get(0);
                    MediaFile th2 = new MediaFile(thumbs.get(0));
                    th2.setFilename("thumb." + th2.getExtension());
                    Utils.moveFileSafe(th.getFileAsPath(), th2.getFileAsPath());
                }
            }
            catch (Exception e) {
                LOGGER.error("error moving video file " + disc + " to " + newFoldername, (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    public static void renameMediaFile(MediaFile mf, TvShow show) {
        block26: {
            List<TvShowEpisode> eps = TvShowList.getInstance().getTvEpisodesByFile(show, mf.getFile());
            if (eps == null || eps.size() == 0) {
                if (mf.getType() == MediaFileType.NFO) {
                    Utils.deleteFileSafely(mf.getFileAsPath());
                    return;
                }
                LOGGER.warn("No episodes found for file '" + mf.getFilename() + "' - skipping");
                return;
            }
            TvShowEpisode ep = eps.get(0);
            LOGGER.debug("testing file S:" + ep.getSeason() + " E:" + ep.getEpisode() + " MF:" + mf.getFile().getAbsolutePath());
            File f = mf.getFile();
            boolean testRenameOk = false;
            for (int i = 0; i < 5 && !(testRenameOk = f.renameTo(f)); ++i) {
                try {
                    if (!f.exists()) {
                        LOGGER.debug("Hmmm... file " + f + " does not even exists; delete from DB");
                        for (TvShowEpisode e : eps) {
                            e.removeFromMediaFiles(mf);
                            e.saveToDb();
                        }
                        return;
                    }
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                }
            }
            if (!testRenameOk) {
                LOGGER.warn("File " + mf.getFileAsPath() + " is not accessible!");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, mf.getFilename(), "message.renamer.failedrename"));
                return;
            }
            String seasonName = TvShowRenamer.generateSeasonDir(SETTINGS.getRenamerSeasonFoldername(), ep);
            Path seasonDir = show.getPathNIO();
            if (StringUtils.isNotBlank((CharSequence)seasonName) && !Files.exists(seasonDir = show.getPathNIO().resolve(seasonName), new LinkOption[0])) {
                try {
                    Files.createDirectory(seasonDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            MediaFile newMF = new MediaFile(mf);
            if (mf.getType().equals((Object)MediaFileType.TRAILER)) {
                Path sample = seasonDir.resolve("sample");
                if (!Files.exists(sample, new LinkOption[0])) {
                    try {
                        Files.createDirectory(sample, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                seasonDir = sample;
            }
            String filename = TvShowRenamer.generateFilename(show, mf);
            LOGGER.debug("new filename should be " + filename);
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                Path newFile = seasonDir.resolve(filename);
                try {
                    if (mf.getFileAsPath().toString().equals(newFile.toString())) break block26;
                    Path oldMfFile = mf.getFileAsPath();
                    boolean ok = false;
                    try {
                        if (!Files.exists(newFile.getParent(), new LinkOption[0])) {
                            Files.createDirectory(newFile.getParent(), new FileAttribute[0]);
                        }
                        ok = Utils.moveFileSafe(oldMfFile, newFile);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldMfFile, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (ok) {
                        if (mf.getFilename().endsWith(".sub")) {
                            try {
                                Path oldidx = mf.getFileAsPath().resolveSibling(mf.getFilename().toString().replaceFirst("sub$", "idx"));
                                Path newidx = newFile.resolveSibling(newFile.getFileName().toString().replaceFirst("sub$", "idx"));
                                Utils.moveFileSafe(oldidx, newidx);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        newMF.setPath(seasonDir.toString());
                        newMF.setFilename(filename);
                        for (TvShowEpisode e : eps) {
                            e.removeFromMediaFiles(mf);
                            e.addToMediaFiles(newMF);
                            e.setPath(seasonDir.toString());
                            e.saveToDb();
                        }
                    }
                    TvShowRenamer.cleanEmptyDir(oldMfFile.getParent());
                }
                catch (Exception e) {
                    LOGGER.error("error moving video file " + mf.getFilename() + " to " + newFile, (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
    }

    private static void cleanEmptyDir(Path dir) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            if (!directoryStream.iterator().hasNext()) {
                LOGGER.debug("Deleting empty Directory " + dir);
                Files.delete(dir);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String generateFilename(TvShow tvShow, MediaFile mf) {
        return TvShowRenamer.generateName("", tvShow, mf, true);
    }

    public static String generateFilename(String template, TvShow tvShow, MediaFile mf) {
        return TvShowRenamer.generateName(template, tvShow, mf, true);
    }

    public static String generateFolderename(TvShow tvShow, MediaFile mf) {
        return TvShowRenamer.generateName("", tvShow, mf, false);
    }

    private static String generateName(String template, TvShow tvShow, MediaFile mf, boolean forFile) {
        String forcedExtension = "";
        String filename = "";
        List<TvShowEpisode> eps = TvShowList.getInstance().getTvEpisodesByFile(tvShow, mf.getFile());
        if (eps == null || eps.size() == 0) {
            return "";
        }
        filename = StringUtils.isBlank((CharSequence)template) ? TvShowRenamer.createDestination(SETTINGS.getRenamerFilename(), tvShow, eps) : TvShowRenamer.createDestination(template, tvShow, eps);
        if (StringUtils.isBlank((CharSequence)filename) && forFile) {
            return mf.getFilename();
        }
        if (forFile) {
            if (mf.getType().equals((Object)MediaFileType.THUMB)) {
                switch (TvShowModuleManager.SETTINGS.getTvShowEpisodeThumbFilename()) {
                    case FILENAME_THUMB_POSTFIX: {
                        filename = filename + "-thumb";
                        break;
                    }
                    case FILENAME_THUMB_TBN: {
                        forcedExtension = "tbn";
                        break;
                    }
                }
                TvShowEpisode ep = eps.get(0);
                if (ep.isDisc()) {
                    filename = "thumb";
                }
            }
            if (mf.getType().equals((Object)MediaFileType.FANART)) {
                filename = filename + "-fanart";
            }
            if (mf.getType().equals((Object)MediaFileType.TRAILER)) {
                filename = filename + "-trailer";
            }
            if (mf.getType().equals((Object)MediaFileType.MEDIAINFO)) {
                filename = filename + "-mediainfo";
            }
            if (mf.getType().equals((Object)MediaFileType.VSMETA)) {
                String ext = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                filename = filename + "." + ext;
            }
            if (mf.getType().equals((Object)MediaFileType.VIDEO_EXTRA)) {
                String name = mf.getBasename();
                Pattern p = Pattern.compile("(?i).*([ _.-]extras[ _.-]).*");
                Matcher m = p.matcher(name);
                if (m.matches()) {
                    name = name.substring(m.end(1));
                }
                filename = filename + "-extras-" + name;
            }
            if (mf.getType().equals((Object)MediaFileType.SUBTITLE)) {
                List<MediaFileSubtitle> subtitles = mf.getSubtitles();
                if (subtitles != null && subtitles.size() > 0) {
                    MediaFileSubtitle mfs = mf.getSubtitles().get(0);
                    if (mfs != null) {
                        if (!mfs.getLanguage().isEmpty()) {
                            String lang = LanguageStyle.getLanguageCodeForStyle(mfs.getLanguage(), TvShowModuleManager.SETTINGS.getTvShowRenamerLanguageStyle());
                            if (StringUtils.isBlank((CharSequence)lang)) {
                                lang = mfs.getLanguage();
                            }
                            filename = filename + "." + lang;
                        }
                        if (mfs.isForced()) {
                            filename = filename + ".forced";
                        }
                    }
                } else {
                    String shortname = mf.getBasename().toLowerCase(Locale.ROOT).replace(eps.get(0).getVideoBasenameWithoutStacking(), "");
                    String originalLang = "";
                    String lang = "";
                    String forced = "";
                    if (mf.getFilename().toLowerCase(Locale.ROOT).contains("forced")) {
                        forced = ".forced";
                        shortname = shortname.replaceAll("\\p{Punct}*forced", "");
                    }
                    for (String s : LanguageUtils.KEY_TO_LOCALE_MAP.keySet()) {
                        if (!shortname.equalsIgnoreCase(s) && !shortname.matches("(?i).*[ _.-]+" + s + "$")) continue;
                        originalLang = s;
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)(lang = LanguageStyle.getLanguageCodeForStyle(originalLang, TvShowModuleManager.SETTINGS.getTvShowRenamerLanguageStyle())))) {
                        lang = originalLang;
                    }
                    if (StringUtils.isNotBlank((CharSequence)lang)) {
                        filename = filename + "." + lang;
                    }
                    if (StringUtils.isNotBlank((CharSequence)forced)) {
                        filename = filename + forced;
                    }
                }
            }
        }
        if (SETTINGS.isAsciiReplacement()) {
            filename = StrgUtils.convertToAscii((String)filename, (boolean)false);
        }
        if (mf.getExtension().equalsIgnoreCase("JPEG")) {
            forcedExtension = "jpg";
        }
        filename = StringUtils.isNotBlank((CharSequence)forcedExtension) ? filename + "." + forcedExtension : filename + "." + mf.getExtension();
        return filename;
    }

    public static String generateSeasonDir(String template, TvShowEpisode episode) {
        String seasonDir = template;
        if (!(!StringUtils.isBlank((CharSequence)(seasonDir = TvShowRenamer.createDestination(seasonDir, episode.getTvShow(), Arrays.asList(episode)))) || SETTINGS.getRenamerFilename().contains("$1") || SETTINGS.getRenamerFilename().contains("$2") || SETTINGS.getRenamerFilename().contains("$3") || SETTINGS.getRenamerFilename().contains("$4"))) {
            seasonDir = "Season " + String.valueOf(episode.getSeason());
        }
        return seasonDir;
    }

    public static String generateTvShowDir(TvShow tvShow) {
        return TvShowRenamer.generateTvShowDir(SETTINGS.getRenamerTvShowFoldername(), tvShow);
    }

    public static String generateTvShowDir(String template, TvShow tvShow) {
        String newPathname = StringUtils.isNotBlank((CharSequence)SETTINGS.getRenamerTvShowFoldername()) ? tvShow.getDataSource() + File.separator + TvShowRenamer.createDestination(template, tvShow, null) : tvShow.getPath();
        return newPathname;
    }

    public static String getTokenValue(TvShow show, TvShowEpisode episode, String token) {
        String ret = "";
        if (show == null) {
            show = new TvShow();
        }
        if (episode == null) {
            episode = new TvShowEpisode();
        }
        MediaFile mf = new MediaFile();
        if (episode.getMediaFiles(MediaFileType.VIDEO).size() > 0) {
            mf = episode.getMediaFiles(MediaFileType.VIDEO).get(0);
        }
        switch (token.toUpperCase(Locale.ROOT)) {
            case "$N": {
                ret = show.getTitle();
                break;
            }
            case "$M": {
                ret = show.getTitleSortable();
                break;
            }
            case "$Y": {
                ret = show.getYear().equals("0") ? "" : show.getYear();
                break;
            }
            case "$1": {
                ret = String.valueOf(episode.getSeason());
                break;
            }
            case "$2": {
                ret = TvShowRenamer.lz(episode.getSeason());
                break;
            }
            case "$3": {
                ret = String.valueOf(episode.getDvdSeason());
                break;
            }
            case "$4": {
                ret = TvShowRenamer.lz(episode.getDvdSeason());
                break;
            }
            case "$E": {
                ret = TvShowRenamer.lz(episode.getEpisode());
                break;
            }
            case "$D": {
                ret = TvShowRenamer.lz(episode.getDvdEpisode());
                break;
            }
            case "$T": {
                ret = episode.getTitle();
                break;
            }
            case "$S": {
                if (episode.getMediaSource() == MediaSource.UNKNOWN) break;
                ret = episode.getMediaSource().toString();
                break;
            }
            case "$R": {
                ret = mf.getVideoResolution();
                break;
            }
            case "$A": {
                ret = mf.getAudioCodec() + (mf.getAudioCodec().isEmpty() ? "" : "-") + mf.getAudioChannels();
                break;
            }
            case "$V": {
                ret = mf.getVideoCodec() + (mf.getVideoCodec().isEmpty() ? "" : "-") + mf.getVideoFormat();
                break;
            }
            case "$F": {
                ret = mf.getVideoFormat();
                break;
            }
        }
        return ret;
    }

    public static String createDestination(String template, TvShow show, List<TvShowEpisode> episodes) {
        String newDestination = template;
        TvShowEpisode firstEp = null;
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        if (episodes == null || episodes.isEmpty()) {
            Matcher m = token.matcher(template);
            while (m.find()) {
                String value = TvShowRenamer.getTokenValue(show, null, m.group(1));
                newDestination = TvShowRenamer.replaceToken(newDestination, m.group(1), value);
            }
        } else if (episodes.size() == 1) {
            firstEp = episodes.get(0);
            Matcher m = token.matcher(template);
            while (m.find()) {
                String value = TvShowRenamer.getTokenValue(show, firstEp, m.group(1));
                newDestination = TvShowRenamer.replaceToken(newDestination, m.group(1), value);
            }
        } else {
            Matcher m;
            firstEp = episodes.get(0);
            String loopNumbers = "";
            if (TvShowRenamer.getPatternPos(newDestination, seasonNumbers) > -1 && (m = seDelimiter.matcher(newDestination)).find()) {
                if (m.group(1) != null) {
                    loopNumbers = loopNumbers + m.group(1);
                }
                loopNumbers = loopNumbers + newDestination.substring(m.end() - 2, m.end());
            }
            if (TvShowRenamer.getPatternPos(newDestination, episodeNumbers) > -1 && (m = epDelimiter.matcher(newDestination)).find()) {
                if (m.group(1) != null) {
                    loopNumbers = loopNumbers + m.group(1);
                }
                loopNumbers = loopNumbers + newDestination.substring(m.end() - 2, m.end());
            }
            loopNumbers = loopNumbers.trim();
            String episodeParts = "";
            for (TvShowEpisode episode : episodes) {
                String episodePart = loopNumbers;
                Matcher m2 = token.matcher(episodePart);
                while (m2.find()) {
                    String value = TvShowRenamer.getTokenValue(show, episode, m2.group(1));
                    episodePart = TvShowRenamer.replaceToken(episodePart, m2.group(1), value);
                }
                episodeParts = episodeParts + " " + episodePart;
            }
            if (!loopNumbers.isEmpty()) {
                newDestination = newDestination.replace(loopNumbers, episodeParts);
            }
            String loopTitles = "";
            int titlePos = TvShowRenamer.getPatternPos(template, episodeTitles);
            if (titlePos > -1) {
                loopTitles = loopTitles + template.substring(titlePos, titlePos + 2);
            }
            loopTitles = loopTitles.trim();
            episodeParts = "";
            for (TvShowEpisode episode : episodes) {
                String episodePart = loopTitles;
                Matcher m3 = token.matcher(episodePart);
                while (m3.find()) {
                    String value = TvShowRenamer.getTokenValue(show, episode, m3.group(1));
                    episodePart = TvShowRenamer.replaceToken(episodePart, m3.group(1), value);
                }
                if (StringUtils.isNotBlank((CharSequence)episodeParts)) {
                    episodeParts = episodeParts + " -";
                }
                episodeParts = episodeParts + " " + episodePart;
            }
            if (!loopTitles.isEmpty()) {
                newDestination = newDestination.replace(loopTitles, episodeParts);
            }
            Matcher m4 = token.matcher(newDestination);
            while (m4.find()) {
                String value = TvShowRenamer.getTokenValue(show, firstEp, m4.group(1));
                newDestination = TvShowRenamer.replaceToken(newDestination, m4.group(1), value);
            }
        }
        newDestination = newDestination.replaceAll("\\(\\)", "");
        newDestination = newDestination.replaceAll("\\[\\]", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            newDestination = newDestination.replaceAll("\\\\{2,}", "\\\\");
            newDestination = newDestination.replaceAll("^\\\\", "");
        } else {
            newDestination = newDestination.replaceAll(File.separator + "{2,}", File.separator);
            newDestination = newDestination.replaceAll("^" + File.separator, "");
        }
        if (SETTINGS.isAsciiReplacement()) {
            newDestination = StrgUtils.convertToAscii((String)newDestination, (boolean)false);
        }
        newDestination = newDestination.trim();
        newDestination = newDestination.replaceAll(" +", " ").trim();
        if (SETTINGS.isRenamerSpaceSubstitution()) {
            newDestination = newDestination.replaceAll(" ", SETTINGS.getRenamerSpaceReplacement());
        }
        newDestination = newDestination.replaceAll("[ \\.]+$", "");
        return newDestination.trim();
    }

    public static boolean isRecommended(String seasonPattern, String filePattern) {
        int epCnt = TvShowRenamer.count(filePattern, episodeNumbers);
        int titleCnt = TvShowRenamer.count(filePattern, episodeTitles);
        int seCnt = TvShowRenamer.count(filePattern, seasonNumbers);
        int seFolderCnt = TvShowRenamer.count(seasonPattern, seasonNumbers);
        if (epCnt != 1 || titleCnt != 1 || seCnt > 1 || seFolderCnt > 1 || seCnt + seFolderCnt == 0) {
            LOGGER.debug("Too many/less episode/season/title replacer patterns");
            return false;
        }
        int epPos = TvShowRenamer.getPatternPos(filePattern, episodeNumbers);
        int sePos = TvShowRenamer.getPatternPos(filePattern, seasonNumbers);
        int titlePos = TvShowRenamer.getPatternPos(filePattern, episodeTitles);
        if (sePos > epPos) {
            LOGGER.debug("Season pattern should be before episode pattern!");
            return false;
        }
        if (titleCnt == 1 && seCnt == 1 && titlePos < epPos && titlePos > sePos) {
            LOGGER.debug("Title should not be between season/episode pattern");
            return false;
        }
        return true;
    }

    private static int count(String pattern, String[] possibleValues) {
        int count = 0;
        for (String r : possibleValues) {
            if (!pattern.contains(r)) continue;
            ++count;
        }
        return count;
    }

    private static int getPatternPos(String pattern, String[] possibleValues) {
        int pos = -1;
        for (String r : possibleValues) {
            if (!pattern.contains(r)) continue;
            pos = pattern.indexOf(r);
        }
        return pos;
    }

    private static String replaceToken(String destination, String token, String replacement) {
        String replacingCleaned = "";
        if (StringUtils.isNotBlank((CharSequence)replacement)) {
            replacingCleaned = replacement.replaceAll("([\"\\:<>|/?*])", "");
        }
        return destination.replace(token, replacingCleaned);
    }

    public static String replaceInvalidCharacters(String source) {
        source = source.replaceAll(": ", " - ");
        source = source.replaceAll(":", "-");
        return source.replaceAll("([\"\\\\:<>|/?*])", "");
    }
}

