/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.CoreByteBuffer;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.managers.ManagerClass;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Options;
import net.jcores.jre.utils.internal.Streams;

public class CoreClass<T>
extends CoreObject<Class<T>> {
    private static final long serialVersionUID = -5054890786513339808L;
    protected final ManagerClass manager;
    protected final Map<Class<?>[], Constructor<T>> constructors = new HashMap<Class<?>[], Constructor<T>>();

    public CoreClass(CommonCore commonCore, Class<T> ... classArray) {
        super(commonCore, classArray);
        this.manager = commonCore.manager(ManagerClass.class);
    }

    public CoreByteBuffer bytecode(final Option ... optionArray) {
        final CommonCore commonCore = this.commonCore;
        return new CoreByteBuffer(this.commonCore, this.map(new F1<Class<T>, ByteBuffer>(){

            @Override
            public ByteBuffer f(Class<T> clazz) {
                String string = clazz.getCanonicalName().replaceAll("\\.", "/") + ".class";
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    Options options = Options.$(commonCore, optionArray);
                    options.failure(clazz, null, "bytecode:none", "Unable to find bytecode.");
                    return null;
                }
                return Streams.getByteData(classLoader.getResourceAsStream(string));
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public CoreObject<T> spawn(Option ... optionArray) {
        final CommonCore commonCore = this.commonCore;
        final Options options = Options.$(this.commonCore, optionArray);
        final Object[] objectArray = options.args();
        return this.map(new F1<Class<T>, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T f(Class<T> clazz) {
                if (clazz == null) {
                    return null;
                }
                Class<Object> clazz2 = clazz;
                if (clazz.isInterface()) {
                    clazz2 = CoreClass.this.manager.getImplementors(clazz)[0];
                }
                if (objectArray == null || objectArray.length == 0) {
                    try {
                        clazz2.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        options.failure(clazz, instantiationException, "spawn:instanceexception", "Unable to create a new instance.");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        options.failure(clazz, illegalAccessException, "spawn:illegalaccess", "Unable to access type.");
                    }
                }
                Class[] classArray = new CoreObject<Object>(commonCore, objectArray).map(new F1<Object, Class<?>>(){

                    @Override
                    public Class<?> f(Object object) {
                        return object.getClass();
                    }
                }, new Option[0]).array(Class.class);
                try {
                    Constructor<Object> constructor = null;
                    Map map = CoreClass.this.constructors;
                    synchronized (map) {
                        constructor = CoreClass.this.constructors.get(classArray);
                        if (constructor == null) {
                            try {
                                constructor = clazz2.getDeclaredConstructor(classArray);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                Constructor<?>[] constructorArray;
                                for (Constructor<?> constructor2 : constructorArray = clazz2.getDeclaredConstructors()) {
                                    Class<?>[] classArray2 = constructor2.getParameterTypes();
                                    if (classArray2.length != classArray.length) continue;
                                    boolean bl = false;
                                    for (int i = 0; i < classArray.length; ++i) {
                                        if (classArray2[i].isAssignableFrom(classArray[i])) continue;
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    constructor = constructor2;
                                }
                            }
                            if (constructor == null) {
                                throw new NoSuchMethodException("No constructor found.");
                            }
                            CoreClass.this.constructors.put(classArray, constructor);
                        }
                    }
                    return constructor.newInstance(objectArray);
                }
                catch (SecurityException securityException) {
                    options.failure(clazz, securityException, "spawn:security", "Security exception when trying to spawn.");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    options.failure(clazz, noSuchMethodException, "spawn:nomethod", "Method not found.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    options.failure(clazz, illegalArgumentException, "spawn:illegalargs", "Illegal passed arguments.");
                }
                catch (InstantiationException instantiationException) {
                    options.failure(clazz, instantiationException, "spawn:instanceexception:2", "Cannot instantiate.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    options.failure(clazz, illegalAccessException, "spawn:illegalaccess:2", "Unable to access type (2).");
                }
                catch (InvocationTargetException invocationTargetException) {
                    options.failure(clazz, invocationTargetException, "spawn:invocation", "Unable to invoke target.");
                }
                return null;
            }
        }, new Option[0]);
    }

    public void implementor(Class<?> clazz) {
        Class clazz2;
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "implementor() should not be used on cores with more than one class!");
        }
        if ((clazz2 = (Class)this.get(null)) == null) {
            return;
        }
        this.manager.registerImplementor(clazz2, clazz);
    }
}

