/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RingBuffer<T> {
    private final int maxSize;
    private T[] data;
    private int head;
    private int tail;
    private int tailWrapCount;
    private boolean inOverflow = false;
    private AtomicInteger count = new AtomicInteger();
    private AtomicInteger modCount = new AtomicInteger();
    private ReentrantReadWriteLock headLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock tailLock = new ReentrantReadWriteLock();

    public RingBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.data = new Object[maxSize];
        this.tail = 0;
        this.head = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.headLock.writeLock().lock();
        this.tailLock.writeLock().lock();
        try {
            this.tail = 0;
            this.head = 0;
            this.count.set(0);
            this.modCount.incrementAndGet();
            this.data = new Object[this.maxSize];
        }
        finally {
            this.tailLock.writeLock().unlock();
            this.headLock.writeLock().unlock();
        }
    }

    protected void lockTail() {
        this.tailLock.writeLock().lock();
    }

    protected void unlockTail() {
        this.tailLock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        this.headLock.writeLock().lock();
        try {
            if (!this.isEmpty()) {
                if (this.head == this.maxSize) {
                    this.head = 0;
                }
                if (this.head == this.tail) {
                    if (!this.inOverflow) {
                        this.inOverflow = true;
                        this.remove();
                        this.add(object);
                        this.inOverflow = false;
                        return;
                    }
                    throw new IllegalStateException("Double overflow in RingBuffer");
                }
            }
            this.data[this.head++] = object;
            this.count.incrementAndGet();
            this.modCount.incrementAndGet();
        }
        finally {
            this.headLock.writeLock().unlock();
        }
    }

    public T getTailItem() {
        return this.data[this.tail];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove() {
        if (this.isEmpty()) {
            return null;
        }
        this.tailLock.writeLock().lock();
        T obj = null;
        try {
            obj = this.data[this.tail++];
            if (this.tail == this.maxSize) {
                this.tail = 0;
                ++this.tailWrapCount;
            }
            this.count.decrementAndGet();
            this.modCount.incrementAndGet();
        }
        finally {
            this.tailLock.writeLock().unlock();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int numToRemove) {
        if (this.isEmpty()) {
            return;
        }
        this.tailLock.writeLock().lock();
        this.headLock.readLock().lock();
        try {
            if (this.tail + numToRemove >= this.maxSize) {
                int newTail = this.tail + numToRemove - this.maxSize;
                if (newTail > this.head) {
                    newTail = this.head;
                }
                this.tail = newTail;
                ++this.tailWrapCount;
            } else if (this.tail < this.head && this.tail + numToRemove >= this.head) {
                this.tail = this.head;
            }
            if (this.tail == this.head) {
                this.count.set(0);
            } else {
                int newCount = this.count.get();
                this.count.set(newCount -= numToRemove);
            }
            this.modCount.incrementAndGet();
        }
        finally {
            this.headLock.readLock().unlock();
            this.tailLock.writeLock().unlock();
        }
    }

    public Iterator<T> iterator() {
        return new RingBufferIterator(this);
    }

    public int count() {
        return this.count.get();
    }

    public int maxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.tailLock.writeLock().lock();
        int count = 0;
        try {
            count = this.count.get();
        }
        finally {
            this.tailLock.writeLock().unlock();
        }
        return count == 0;
    }

    int head() {
        return this.head;
    }

    int tail() {
        return this.tail;
    }

    int tailWrapCount() {
        return this.tailWrapCount;
    }

    private static class RingBufferIterator<T>
    implements Iterator<T> {
        private int next;
        private int nextWrapCount;
        private final RingBuffer<T> buffer;
        private Mode mode;
        private boolean hasNext;
        private int expectedModCount;

        private Mode mode() {
            if (this.buffer.isEmpty()) {
                return Mode.EMPTY;
            }
            if (this.next == ((RingBuffer)this.buffer).tail) {
                return Mode.START;
            }
            if (this.next == ((RingBuffer)this.buffer).head) {
                return Mode.END;
            }
            if (((RingBuffer)this.buffer).tail < ((RingBuffer)this.buffer).head) {
                if (this.next < ((RingBuffer)this.buffer).head) {
                    return Mode.MODE1;
                }
                return Mode.INVALID;
            }
            if (this.next < ((RingBuffer)this.buffer).head) {
                return Mode.MODE2LEFT;
            }
            if (this.next > ((RingBuffer)this.buffer).tail) {
                return Mode.MODE2RIGHT;
            }
            return Mode.INVALID;
        }

        public RingBufferIterator(RingBuffer<T> buffer) {
            this.buffer = buffer;
            this.next = ((RingBuffer)buffer).tail;
            this.nextWrapCount = ((RingBuffer)buffer).tailWrapCount;
            this.mode = Mode.START;
            this.hasNext = this.calcHasNext();
            this.expectedModCount = ((RingBuffer)buffer).modCount.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ((RingBuffer)this.buffer).headLock.readLock().lock();
            try {
                if (this.expectedModCount != ((RingBuffer)this.buffer).modCount.get()) {
                    this.hasNext = this.calcHasNext();
                }
            }
            finally {
                ((RingBuffer)this.buffer).headLock.readLock().unlock();
            }
            return this.hasNext;
        }

        private boolean calcHasNext() {
            if (this.mode == Mode.INVALID) {
                return false;
            }
            Mode newMode = this.mode();
            if (newMode == Mode.EMPTY || newMode == Mode.END) {
                this.mode = newMode;
                return false;
            }
            if (newMode == this.mode) {
                if (((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount || ((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount - 1) {
                    if (this.mode == Mode.START) {
                        this.mode = Mode.MODE1;
                    }
                    return true;
                }
                this.mode = Mode.INVALID;
                return false;
            }
            if (this.mode == Mode.END) {
                this.mode = newMode;
                switch (this.mode) {
                    case MODE1: 
                    case MODE2LEFT: 
                    case MODE2RIGHT: 
                    case START: {
                        return true;
                    }
                }
                return false;
            }
            if (newMode == Mode.START) {
                if (((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount) {
                    this.mode = newMode;
                    return true;
                }
                this.mode = Mode.INVALID;
                return false;
            }
            if (this.mode == Mode.MODE1) {
                if (newMode == Mode.MODE2RIGHT) {
                    if (((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount) {
                        this.mode = newMode;
                        return true;
                    }
                } else if (newMode == Mode.MODE2LEFT && ((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount - 1) {
                    this.mode = newMode;
                    return true;
                }
                this.mode = Mode.INVALID;
                return false;
            }
            if (this.mode == Mode.MODE2LEFT) {
                if (newMode == Mode.MODE1 && ((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount) {
                    this.mode = newMode;
                    return true;
                }
                if (newMode == Mode.MODE2RIGHT && ((RingBuffer)this.buffer).tailWrapCount == this.nextWrapCount + 1) {
                    this.mode = newMode;
                    return true;
                }
                this.mode = Mode.INVALID;
                return false;
            }
            if (this.mode == Mode.MODE2RIGHT) {
                if (newMode == Mode.MODE2LEFT && this.nextWrapCount == ((RingBuffer)this.buffer).tailWrapCount + 1) {
                    this.mode = newMode;
                    return true;
                }
                if (newMode == Mode.MODE1 && this.nextWrapCount == ((RingBuffer)this.buffer).tailWrapCount) {
                    this.mode = newMode;
                    return true;
                }
                this.mode = Mode.INVALID;
                return false;
            }
            this.mode = Mode.INVALID;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            if (!this.hasNext) {
                return null;
            }
            Object item = null;
            try {
                ((RingBuffer)this.buffer).headLock.readLock().lock();
                item = ((RingBuffer)this.buffer).data[this.next++];
                if (this.next == ((RingBuffer)this.buffer).maxSize) {
                    this.next = 0;
                    ++this.nextWrapCount;
                }
                this.hasNext = this.calcHasNext();
            }
            finally {
                ((RingBuffer)this.buffer).headLock.readLock().unlock();
            }
            return (T)item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static enum Mode {
            EMPTY,
            MODE1,
            MODE2LEFT,
            MODE2RIGHT,
            START,
            END,
            INVALID;

        }
    }
}

