/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

import com.google.gson.Gson;
import com.uwetrottmann.trakt5.TraktV2Authenticator;
import com.uwetrottmann.trakt5.TraktV2Helper;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.CheckinError;
import com.uwetrottmann.trakt5.services.Authentication;
import com.uwetrottmann.trakt5.services.Calendars;
import com.uwetrottmann.trakt5.services.Checkin;
import com.uwetrottmann.trakt5.services.Comments;
import com.uwetrottmann.trakt5.services.Episodes;
import com.uwetrottmann.trakt5.services.Genres;
import com.uwetrottmann.trakt5.services.Movies;
import com.uwetrottmann.trakt5.services.People;
import com.uwetrottmann.trakt5.services.Recommendations;
import com.uwetrottmann.trakt5.services.Search;
import com.uwetrottmann.trakt5.services.Seasons;
import com.uwetrottmann.trakt5.services.Shows;
import com.uwetrottmann.trakt5.services.Sync;
import com.uwetrottmann.trakt5.services.Users;
import java.io.IOException;
import java.lang.annotation.Annotation;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class TraktV2 {
    public static final String API_HOST = "api.trakt.tv";
    public static final String API_URL = "https://api.trakt.tv/";
    public static final String API_VERSION = "2";
    public static final String SITE_URL = "https://trakt.tv";
    public static final String OAUTH2_AUTHORIZATION_URL = "https://trakt.tv/oauth/authorize";
    public static final String OAUTH2_TOKEN_URL = "https://trakt.tv/oauth/token";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String HEADER_TRAKT_API_VERSION = "trakt-api-version";
    public static final String HEADER_TRAKT_API_KEY = "trakt-api-key";
    private OkHttpClient okHttpClient;
    private Retrofit retrofit;
    private String apiKey;
    private String clientSecret;
    private String redirectUri;
    private String accessToken;
    private String refreshToken;

    public TraktV2(String apiKey) {
        this.apiKey = apiKey;
    }

    public TraktV2(String apiKey, String clientSecret, String redirectUri) {
        this.apiKey = apiKey;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public void apiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public TraktV2 accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public TraktV2 refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    protected Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TraktV2Helper.getGsonBuilder().create())).client(this.okHttpClient());
    }

    protected synchronized OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            this.setOkHttpClientDefaults(builder);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    protected void setOkHttpClientDefaults(OkHttpClient.Builder builder) {
        builder.addNetworkInterceptor((Interceptor)new TraktV2Interceptor(this));
        builder.authenticator((Authenticator)new TraktV2Authenticator(this));
    }

    protected Retrofit retrofit() {
        if (this.retrofit == null) {
            this.retrofit = this.retrofitBuilder().build();
        }
        return this.retrofit;
    }

    public OAuthClientRequest buildAuthorizationRequest(String state) throws OAuthSystemException {
        return OAuthClientRequest.authorizationLocation((String)OAUTH2_AUTHORIZATION_URL).setResponseType(ResponseType.CODE.toString()).setClientId(this.apiKey()).setRedirectURI(this.redirectUri).setState(state).buildQueryMessage();
    }

    public Response<AccessToken> exchangeCodeForAccessToken(String authCode) throws IOException {
        return this.authentication().exchangeCodeForAccessToken(GrantType.AUTHORIZATION_CODE.toString(), authCode, this.apiKey(), this.clientSecret, this.redirectUri).execute();
    }

    public Response<AccessToken> refreshAccessToken() throws IOException {
        return this.authentication().refreshAccessToken(GrantType.REFRESH_TOKEN.toString(), this.refreshToken(), this.apiKey(), this.clientSecret, this.redirectUri).execute();
    }

    public CheckinError checkForCheckinError(Response response) throws IOException {
        if (response.code() != 409) {
            return null;
        }
        Converter errorConverter = this.retrofit.responseBodyConverter(CheckinError.class, new Annotation[0]);
        return (CheckinError)errorConverter.convert((Object)response.errorBody());
    }

    public Authentication authentication() {
        return (Authentication)this.retrofit().create(Authentication.class);
    }

    public Calendars calendars() {
        return (Calendars)this.retrofit().create(Calendars.class);
    }

    public Checkin checkin() {
        return (Checkin)this.retrofit().create(Checkin.class);
    }

    public Comments comments() {
        return (Comments)this.retrofit().create(Comments.class);
    }

    public Genres genres() {
        return (Genres)this.retrofit().create(Genres.class);
    }

    public Movies movies() {
        return (Movies)this.retrofit().create(Movies.class);
    }

    public People people() {
        return (People)this.retrofit().create(People.class);
    }

    public Recommendations recommendations() {
        return (Recommendations)this.retrofit().create(Recommendations.class);
    }

    public Search search() {
        return (Search)this.retrofit().create(Search.class);
    }

    public Shows shows() {
        return (Shows)this.retrofit().create(Shows.class);
    }

    public Seasons seasons() {
        return (Seasons)this.retrofit().create(Seasons.class);
    }

    public Episodes episodes() {
        return (Episodes)this.retrofit().create(Episodes.class);
    }

    public Sync sync() {
        return (Sync)this.retrofit().create(Sync.class);
    }

    public Users users() {
        return (Users)this.retrofit().create(Users.class);
    }
}

