/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ofdb;

import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

@PluginImplementation
public class OfdbMetadataProvider
implements IMovieMetadataProvider,
IMovieTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdbMetadataProvider.class);
    private static final String BASE_URL = "http://www.ofdb.de";
    private static MediaProviderInfo providerInfo = OfdbMetadataProvider.createMediaProviderInfo();

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("ofdb", "Online Filmdatenbank (OFDb.de)", "<html><h3>Online Filmdatenbank (OFDb)</h3><br />A german movie database driven by the community.<br /><br />Available languages: DE</html>", OfdbMetadataProvider.class.getResource("/ofdb_de.png"));
        providerInfo.setVersion(OfdbMetadataProvider.class);
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getMetadata() " + options.toString());
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        String detailUrl = "";
        if (StringUtils.isNotBlank((CharSequence)options.getId(this.getProviderInfo().getId())) || options.getResult() != null) {
            detailUrl = StringUtils.isNotBlank((CharSequence)options.getId(this.getProviderInfo().getId())) ? "http://www.ofdb.de/view.php?page=film&fid=" + options.getId(this.getProviderInfo().getId()) : options.getResult().getUrl();
        }
        if (options.getResult() == null && StringUtils.isNotBlank((CharSequence)options.getId("imdb"))) {
            MediaSearchOptions searchOptions = new MediaSearchOptions(MediaType.MOVIE);
            searchOptions.setImdbId(options.getId("imdb"));
            try {
                List<MediaSearchResult> results = this.search(searchOptions);
                if (results != null && !results.isEmpty()) {
                    options.setResult(results.get(0));
                    detailUrl = options.getResult().getUrl();
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed IMDB search: " + e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)detailUrl)) {
            throw new Exception("We did not get any useful movie url");
        }
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        Elements el = null;
        String ofdbId = StrgUtils.substr((String)detailUrl, (String)"film\\/(\\d+),");
        if (StringUtils.isBlank((CharSequence)ofdbId)) {
            ofdbId = StrgUtils.substr((String)detailUrl, (String)"fid=(\\d+)");
        }
        try {
            String r;
            String originalTitle;
            LOGGER.trace("get details page");
            Url url = new Url(detailUrl);
            InputStream in = url.getInputStream();
            Document doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
            in.close();
            if (doc.getAllElements().size() < 10) {
                throw new Exception("meh - we did not receive a valid web page");
            }
            el = doc.getElementsByAttributeValueContaining("href", "imdb.com");
            if (!el.isEmpty()) {
                md.setId("imdb", (Object)("tt" + StrgUtils.substr((String)el.first().attr("href"), (String)"\\?(\\d+)")));
            }
            if (!(el = doc.getElementsByAttributeValue("property", "og:title")).isEmpty()) {
                String[] ty = this.parseTitle(el.first().attr("content"));
                md.setTitle(StrgUtils.removeCommonSortableName((String)ty[0]));
                try {
                    md.setYear(Integer.parseInt(ty[1]));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (md.getYear() == 0) {
                el = doc.getElementsByAttributeValueContaining("href", "Kat=Jahr");
                try {
                    md.setYear(Integer.parseInt(el.first().text()));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (!(originalTitle = StrgUtils.substr((String)doc.body().html(), (String)"(?s)Originaltitel.*?<b>(.*?)</b>")).isEmpty()) {
                md.setOriginalTitle(StrgUtils.removeCommonSortableName((String)originalTitle));
            }
            el = doc.getElementsByAttributeValueContaining("href", "page=genre");
            for (Element g : el) {
                md.addGenre(this.getTmmGenre(g.text()));
            }
            el = doc.getElementsByAttributeValue("itemprop", "ratingValue");
            if (!el.isEmpty() && !(r = el.text()).isEmpty()) {
                try {
                    md.setRating(Float.parseFloat(r));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse rating");
                }
            }
            LOGGER.trace("parse plot");
            el = doc.getElementsByAttributeValueMatching("href", "plot\\/\\d+,");
            if (!el.isEmpty()) {
                String plotUrl = "http://www.ofdb.de/" + el.first().attr("href");
                try {
                    url = new Url(plotUrl);
                    in = url.getInputStream();
                    Document plot = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
                    in.close();
                    Elements block = plot.getElementsByClass("Blocksatz");
                    String p = block.first().text();
                    p = p.substring(p.indexOf("Mal gelesen") + 12);
                    md.setPlot(p);
                }
                catch (Exception e) {
                    LOGGER.error("failed to get plot page: " + e.getMessage());
                }
            }
            LOGGER.debug("parse actor detail");
            String movieDetail = "http://www.ofdb.de/view.php?page=film_detail&fid=" + ofdbId;
            doc = null;
            try {
                url = new Url(movieDetail);
                in = url.getInputStream();
                doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
                in.close();
            }
            catch (Exception e) {
                LOGGER.error("failed to get detail page: " + e.getMessage());
            }
            if (doc != null) {
                this.parseCast(doc.getElementsContainingOwnText("Regie"), MediaCastMember.CastType.DIRECTOR, md);
                this.parseCast(doc.getElementsContainingOwnText("Darsteller"), MediaCastMember.CastType.ACTOR, md);
                this.parseCast(doc.getElementsContainingOwnText("Stimme/Sprecher"), MediaCastMember.CastType.ACTOR, md);
                this.parseCast(doc.getElementsContainingOwnText("Synchronstimme (deutsch)"), MediaCastMember.CastType.ACTOR, md);
                this.parseCast(doc.getElementsContainingOwnText("Drehbuchautor(in)"), MediaCastMember.CastType.WRITER, md);
                this.parseCast(doc.getElementsContainingOwnText("Produzent(in)"), MediaCastMember.CastType.PRODUCER, md);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing " + detailUrl);
            throw e;
        }
        return md;
    }

    private void parseCast(Elements el, MediaCastMember.CastType type, MediaMetadata md) {
        if (el != null && !el.isEmpty()) {
            Element castEl = null;
            for (Element element : el) {
                if (element.tagName().equals("option")) continue;
                castEl = element;
            }
            if (castEl == null) {
                LOGGER.debug("meh, no " + type.name() + " found");
                return;
            }
            while (castEl != null && !castEl.tagName().equalsIgnoreCase("tr")) {
                castEl = castEl.parent();
            }
            Element tr = castEl.nextElementSibling();
            if (tr != null) {
                for (Element a : tr.getElementsByAttributeValue("valign", "middle")) {
                    String act = a.toString();
                    String aname = StrgUtils.substr((String)act, (String)"alt=\"(.*?)\"");
                    if (aname.isEmpty()) continue;
                    MediaCastMember cm = new MediaCastMember();
                    cm.setName(aname);
                    String id = StrgUtils.substr((String)act, (String)"id=(.*?)[^\"]\">");
                    if (!id.isEmpty()) {
                        cm.setId(id);
                        try {
                            String imgurl = URLDecoder.decode(StrgUtils.substr((String)act, (String)"images%2Fperson%2F(.*?)&amp;size"), "UTF-8");
                            if (!imgurl.isEmpty()) {
                                imgurl = "http://www.ofdb.de/images/person/" + imgurl;
                            }
                            cm.setImageUrl(imgurl);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    String arole = StrgUtils.substr((String)act, (String)"\\.\\.\\. (.*?)</font>").replaceAll("<[^>]*>", "");
                    cm.setCharacter(arole);
                    cm.setType(type);
                    md.addCastMember(cm);
                }
            }
        }
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        if (genre.equals("Abenteuer")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Action")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Amateur")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Animation")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Anime")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Biographie")) {
            g = MediaGenres.BIOGRAPHY;
        } else if (genre.equals("Dokumentation")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Eastern")) {
            g = MediaGenres.EASTERN;
        } else if (genre.equals("Erotik")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Essayfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Experimentalfilm")) {
            g = MediaGenres.INDIE;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Grusel")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Hardcore")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Heimatfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("Historienfilm")) {
            g = MediaGenres.HISTORY;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Kampfsport")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Katastrophen")) {
            g = MediaGenres.DISASTER;
        } else if (genre.equals("Kinder-/Familienfilm")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Kom\u00f6die")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Krieg")) {
            g = MediaGenres.WAR;
        } else if (genre.equals("Krimi")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Kurzfilm")) {
            g = MediaGenres.SHORT;
        } else if (genre.equals("Liebe/Romantik")) {
            g = MediaGenres.ROMANCE;
        } else if (genre.equals("Mondo")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Musikfilm")) {
            g = MediaGenres.MUSIC;
        } else if (genre.equals("Mystery")) {
            g = MediaGenres.MYSTERY;
        } else if (genre.equals("Science-Fiction")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Serial")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Sex")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Splatter")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Sportfilm")) {
            g = MediaGenres.SPORT;
        } else if (genre.equals("Stummfilm")) {
            g = MediaGenres.SILENT_MOVIE;
        } else if (genre.equals("TV-Film")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Mini-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("TV-Pilotfilm")) {
            g = MediaGenres.TV_MOVIE;
        } else if (genre.equals("TV-Serie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("Tierfilm")) {
            g = MediaGenres.ANIMAL;
        } else if (genre.equals("Webserie")) {
            g = MediaGenres.SERIES;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre((String)genre);
        }
        return g;
    }

    private String cleanSearch(String q) {
        q = " " + q + " ";
        q = q.replaceAll("(?i)( a | the | der | die | das |\\(\\d+\\))", " ");
        q = q.replaceAll("[^A-Za-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc ]", " ");
        q = q.replaceAll("  ", "");
        return q.trim();
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        String searchQuery = "";
        String imdb = "";
        Elements filme = null;
        int myear = options.getYear();
        if (StringUtils.isNotEmpty((CharSequence)options.getImdbId()) && (filme == null || filme.isEmpty())) {
            try {
                imdb = options.getImdbId();
                searchString = "http://www.ofdb.de/view.php?page=suchergebnis&Kat=IMDb&SText=" + imdb;
                LOGGER.debug("search with imdbId: " + imdb);
                Url url = new Url(searchString);
                InputStream in = url.getInputStream();
                Document doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
                in.close();
                filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
                LOGGER.debug("found " + filme.size() + " search results");
            }
            catch (Exception e) {
                LOGGER.error("failed to search for imdb Id " + imdb + ": " + e.getMessage());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery()) && (filme == null || filme.isEmpty())) {
            try {
                String query;
                searchQuery = query = options.getQuery();
                query = MetadataUtil.removeNonSearchCharacters((String)query);
                searchString = "http://www.ofdb.de/view.php?page=suchergebnis&Kat=All&SText=" + URLEncoder.encode(this.cleanSearch(query), "UTF-8");
                LOGGER.debug("search for everything: " + query);
                Url url = new Url(searchString);
                InputStream in = url.getInputStream();
                Document doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
                in.close();
                filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
                LOGGER.debug("found " + filme.size() + " search results");
            }
            catch (Exception e) {
                LOGGER.error("failed to search for " + searchQuery + ": " + e.getMessage());
            }
        }
        if (filme == null || filme.isEmpty()) {
            LOGGER.debug("nothing found :(");
            return resultList;
        }
        HashSet<String> foundResultUrls = new HashSet<String>();
        for (Element a : filme) {
            try {
                MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
                if (StringUtils.isNotEmpty((CharSequence)imdb)) {
                    sr.setIMDBId(imdb);
                }
                sr.setId(StrgUtils.substr((String)a.toString(), (String)"film\\/(\\d+),"));
                sr.setTitle(StringEscapeUtils.unescapeHtml4((String)StrgUtils.removeCommonSortableName((String)StrgUtils.substr((String)a.toString(), (String)".*>(.*?)(\\[.*?\\])?<font"))));
                LOGGER.debug("found movie " + sr.getTitle());
                sr.setOriginalTitle(StringEscapeUtils.unescapeHtml4((String)StrgUtils.removeCommonSortableName((String)StrgUtils.substr((String)a.toString(), (String)".*> / (.*?)</font"))));
                try {
                    sr.setYear(Integer.parseInt(StrgUtils.substr((String)a.toString(), (String)"font> \\((.*?)\\)<\\/a")));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                sr.setUrl("http://www.ofdb.de/" + StrgUtils.substr((String)a.toString(), (String)"href=\\\"(.*?)\\\""));
                sr.setPosterUrl("http://www.ofdb.de/images" + StrgUtils.substr((String)a.toString(), (String)"images(.*?)\\&quot"));
                if (StringUtils.isBlank((CharSequence)sr.getTitle()) || StringUtils.isBlank((CharSequence)sr.getUrl()) || foundResultUrls.contains(sr.getUrl())) continue;
                foundResultUrls.add(sr.getUrl());
                if (imdb.equals(sr.getIMDBId())) {
                    sr.setScore(1.0f);
                } else {
                    float score = MetadataUtil.calculateScore((String)searchQuery, (String)sr.getTitle());
                    if (this.yearDiffers(myear, sr.getYear())) {
                        float diff = (float)Math.abs(myear - sr.getYear()) / 100.0f;
                        LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                        score -= diff;
                    }
                    sr.setScore(score);
                }
                resultList.add(sr);
            }
            catch (Exception e) {
                LOGGER.warn("error parsing movie result: " + e.getMessage());
            }
        }
        Collections.sort(resultList);
        Collections.reverse(resultList);
        return resultList;
    }

    public List<MediaTrailer> getTrailers(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getTrailers() " + options.toString());
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        if (!MetadataUtil.isValidImdbId((String)options.getImdbId())) {
            LOGGER.debug("IMDB id not found");
            return trailers;
        }
        Url url = null;
        String searchString = "http://www.ofdb.de/view.php?page=suchergebnis&Kat=IMDb&SText=" + options.getImdbId();
        try {
            url = new Url(searchString);
            InputStream in = url.getInputStream();
            Document doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
            in.close();
            Elements filme = doc.getElementsByAttributeValueMatching("href", "film\\/\\d+,");
            if (filme == null || filme.isEmpty()) {
                LOGGER.debug("found no search results");
                return trailers;
            }
            LOGGER.debug("found " + filme.size() + " search results");
            LOGGER.debug("get (trailer) details page");
            url = new Url("http://www.ofdb.de/" + StrgUtils.substr((String)filme.first().toString(), (String)"href=\\\"(.*?)\\\""));
            in = url.getInputStream();
            doc = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
            in.close();
            Pattern regex = Pattern.compile("return '(.*?)';");
            Matcher m = regex.matcher(doc.toString());
            while (m.find()) {
                String s = m.group(1);
                String tname = StrgUtils.substr((String)s, (String)"<b>(.*?)</b>");
                String tpix = StrgUtils.substr((String)s, (String)"raquo; (.*?)x<br>");
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(s);
                while (lm.find()) {
                    String turl = lm.group(1);
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setUrl(turl);
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
            regex = Pattern.compile("<i>(.*?)</i>(.*?)<br>", 32);
            m = regex.matcher(doc.getElementsByClass("clips").html());
            while (m.find()) {
                String tname = m.group(1).trim();
                tname = tname.replaceFirst(":$", "");
                String urls = m.group(2);
                Pattern lr = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
                Matcher lm = lr.matcher(urls);
                while (lm.find()) {
                    String tformat;
                    String turl = lm.group(1);
                    String tpix = "";
                    switch (tformat = lm.group(2).replaceAll("&nbsp;", "").trim()) {
                        case "small": {
                            tpix = "90p";
                            break;
                        }
                        case "medium": {
                            tpix = "136p";
                            break;
                        }
                        case "large": {
                            tpix = "180p";
                            break;
                        }
                        case "xlarge": {
                            tpix = "226p";
                            break;
                        }
                        case "xxlarge": {
                            tpix = "360p";
                            break;
                        }
                    }
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(tname);
                    trailer.setQuality(tpix);
                    trailer.setProvider("filmtrailer");
                    trailer.setUrl(turl);
                    LOGGER.debug(trailer.toString());
                    trailers.add(trailer);
                }
            }
        }
        catch (Exception e) {
            if (url != null) {
                LOGGER.error("Error parsing {}", (Object)url.toString());
            } else {
                LOGGER.error("Error parsing {}", (Object)searchString);
            }
            throw e;
        }
        return trailers;
    }

    private String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }
}

