/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeCastPanel
extends JPanel {
    private static final long serialVersionUID = 4712144916016763491L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowEpisodeSelectionModel selectionModel;
    private EventList<TvShowActor> actorEventList = null;
    private DefaultEventTableModel<TvShowActor> actorTableModel = null;
    private ZebraJTable tableActors;
    private ImageLabel lblActorImage;
    private JLabel lblDirector;
    private JLabel lblWriter;

    public TvShowEpisodeCastPanel(TvShowEpisodeSelectionModel model) {
        this.selectionModel = model;
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowActor.class)));
        this.actorTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.actorEventList), (TableFormat)new ActorTableFormat());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"125px")}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:max(125px;default):grow")}));
        JLabel lblDirectorT = new JLabel(BUNDLE.getString("metatag.director"));
        this.add((Component)lblDirectorT, "2, 2");
        this.lblDirector = new JLabel("");
        this.add((Component)this.lblDirector, "4, 2");
        JLabel lblWriterT = new JLabel(BUNDLE.getString("metatag.writer"));
        this.add((Component)lblWriterT, "2, 4");
        this.lblWriter = new JLabel("");
        this.add((Component)this.lblWriter, "4, 4");
        this.lblActorImage = new ImageLabel();
        this.lblActorImage.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.add((Component)this.lblActorImage, "6, 2, 1, 5");
        JLabel lblActorsT = new JLabel(BUNDLE.getString("metatag.actors"));
        this.add((Component)lblActorsT, "2, 6, left, top");
        this.tableActors = new ZebraJTable((TableModel)this.actorTableModel);
        JScrollPane scrollPaneActors = ZebraJTable.createStripedJScrollPane(this.tableActors);
        scrollPaneActors.setViewportView(this.tableActors);
        this.add((Component)scrollPaneActors, "4, 6, fill, fill");
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == TvShowEpisodeSelectionModel.class && "selectedTvShowEpisode".equals(property) || source.getClass() == TvShowEpisode.class && "actors".equals(property)) {
                    TvShowEpisodeCastPanel.this.actorEventList.clear();
                    TvShowEpisodeCastPanel.this.actorEventList.addAll(TvShowEpisodeCastPanel.this.selectionModel.getSelectedTvShowEpisode().getActors());
                    if (TvShowEpisodeCastPanel.this.actorEventList.size() > 0) {
                        TvShowEpisodeCastPanel.this.tableActors.getSelectionModel().setSelectionInterval(0, 0);
                    } else {
                        TvShowEpisodeCastPanel.this.lblActorImage.setImageUrl("");
                    }
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableActors.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selectedRow;
                if (!arg0.getValueIsAdjusting() && (selectedRow = TvShowEpisodeCastPanel.this.tableActors.convertRowIndexToModel(TvShowEpisodeCastPanel.this.tableActors.getSelectedRow())) >= 0 && selectedRow < TvShowEpisodeCastPanel.this.actorEventList.size()) {
                    TvShowActor actor = (TvShowActor)TvShowEpisodeCastPanel.this.actorEventList.get(selectedRow);
                    Path p = ImageCache.getCachedFile(actor.getThumbUrl());
                    if (p == null) {
                        TvShowEpisodeCastPanel.this.lblActorImage.setImageUrl(actor.getThumbUrl());
                    } else {
                        TvShowEpisodeCastPanel.this.lblActorImage.setImagePath(p.toAbsolutePath().toString());
                    }
                }
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.director");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblDirector, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.writer");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblWriter, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private static class ActorTableFormat
    implements AdvancedTableFormat<TvShowActor> {
        private ActorTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.name");
                }
                case 1: {
                    return BUNDLE.getString("metatag.role");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowActor actor, int column) {
            switch (column) {
                case 0: {
                    return actor.getName();
                }
                case 1: {
                    return actor.getCharacter();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int column) {
            return null;
        }
    }
}

