/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;

public class MediaScraperComboBox
extends JComboBox<MediaScraper> {
    private static final long serialVersionUID = 7845502706645523958L;
    private Map<URI, ImageIcon> imageCache;

    public MediaScraperComboBox() {
        this.init();
    }

    public MediaScraperComboBox(MediaScraper[] scrapers) {
        super(scrapers);
        this.init();
    }

    public MediaScraperComboBox(Vector scrapers) {
        super(scrapers);
        this.init();
    }

    public MediaScraperComboBox(List<MediaScraper> scrapers) {
        super(new Vector<MediaScraper>(scrapers));
        this.init();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getUI().getPreferredSize(this);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        MediaScraper ms = (MediaScraper)anObject;
        if (ms != null && ms.isEnabled()) {
            super.setSelectedItem(anObject);
        }
    }

    private void init() {
        this.setRenderer(new MediaScraperComboBoxRenderer());
        this.setEditable(true);
        this.setEditor(new MediaScraperComboBoxEditor());
    }

    private ImageIcon getIcon(URL url) {
        try {
            URI uri = url.toURI();
            ImageIcon logo = this.imageCache.get(uri);
            if (logo == null) {
                logo = this.getScaledIcon(IconManager.loadImageFromURL(url));
                this.imageCache.put(uri, logo);
            }
            return logo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageIcon getScaledIcon(ImageIcon original) {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(this.getFont());
        int height = (int)((float)fm.getHeight() * 2.0f);
        int width = original.getIconWidth() / original.getIconHeight() * height;
        BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        return new ImageIcon(scaledImage);
    }

    class MediaScraperComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<MediaScraper> {
        private static final long serialVersionUID = -4726883292397768525L;

        public MediaScraperComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            MediaScraperComboBox.this.imageCache = new HashMap();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MediaScraper> list, MediaScraper scraper, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            int maxWidth = 0;
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                MediaScraper ms = list.getModel().getElementAt(i);
                ImageIcon logo = MediaScraperComboBox.this.getIcon(ms.getLogoURL());
                maxWidth = Math.max(maxWidth, logo == null ? 0 : logo.getIconWidth());
                if (!scraper.isEnabled()) {
                    this.setEnabled(false);
                    this.setBackground(Color.lightGray);
                    continue;
                }
                this.setEnabled(true);
            }
            int currentWidth = 0;
            ImageIcon logo = MediaScraperComboBox.this.getIcon(scraper.getLogoURL());
            if (logo != null) {
                currentWidth = logo.getIconWidth();
            }
            this.setIcon(logo);
            this.setText(scraper.getMediaProvider().getProviderInfo().getName());
            this.setFont(list.getFont());
            this.setIconTextGap(maxWidth + 4 - currentWidth);
            return this;
        }
    }

    class MediaScraperComboBoxEditor
    extends BasicComboBoxEditor {
        private JLabel label = new JLabel("");
        private MediaScraper selectedItem;

        public MediaScraperComboBoxEditor() {
            this.label.setHorizontalAlignment(2);
            this.label.setVerticalAlignment(0);
            this.selectedItem = null;
        }

        @Override
        public Component getEditorComponent() {
            return this.label;
        }

        @Override
        public Object getItem() {
            return this.selectedItem;
        }

        @Override
        public void setItem(Object item) {
            this.selectedItem = (MediaScraper)item;
            if (this.selectedItem == null) {
                this.label.setText("");
            } else {
                this.label.setText(this.selectedItem.getMediaProvider().getProviderInfo().getName());
            }
        }
    }
}

