/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.DownloadTask;

public class MovieSubtitleDownloadTask
extends DownloadTask {
    private final Movie movie;
    private final String languageTag;
    private final Path videoFilePath;

    public MovieSubtitleDownloadTask(String url, Path videoFilePath, String languageTag, Movie movie) {
        super(url, movie.getPathNIO().resolve(FilenameUtils.getBaseName((String)videoFilePath.getFileName().toString()) + "." + languageTag));
        this.movie = movie;
        this.languageTag = languageTag;
        this.videoFilePath = videoFilePath;
    }

    @Override
    protected void doInBackground() {
        super.doInBackground();
        MediaFile mf = new MediaFile(this.file);
        if (mf.getType() != MediaFileType.SUBTITLE) {
            String basename = FilenameUtils.getBaseName((String)this.videoFilePath.toString()) + "." + this.languageTag;
            try {
                byte[] buffer = new byte[1024];
                ZipInputStream is = new ZipInputStream(new FileInputStream(this.file.toFile()));
                ZipEntry ze = is.getNextEntry();
                while (ze != null) {
                    int len;
                    String zipEntryFilename = ze.getName();
                    String extension = FilenameUtils.getExtension((String)zipEntryFilename);
                    if (!Globals.settings.getSubtitleFileType().contains("." + extension) && !"idx".equals(extension)) {
                        ze = is.getNextEntry();
                        continue;
                    }
                    File destination = new File(this.file.getParent().toFile(), basename + "." + extension);
                    FileOutputStream os = new FileOutputStream(destination);
                    while ((len = is.read(buffer)) > 0) {
                        os.write(buffer, 0, len);
                    }
                    os.close();
                    mf = new MediaFile(destination.toPath());
                    break;
                }
                is.closeEntry();
                is.close();
                Utils.deleteFileSafely(this.file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mf.gatherMediaInformation();
        this.movie.removeFromMediaFiles(mf);
        this.movie.addToMediaFiles(mf);
        this.movie.saveToDb();
    }
}

