/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.http.Url;

public class MediaEntityImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityImageFetcherTask.class);
    private MediaEntity entity;
    private String url;
    private MediaArtwork.MediaArtworkType type;
    private String filename;
    private boolean firstImage;

    public MediaEntityImageFetcherTask(MediaEntity entity, String url, MediaArtwork.MediaArtworkType type, String filename, boolean firstImage) {
        this.entity = entity;
        this.url = url;
        this.type = type;
        this.filename = filename;
        this.firstImage = firstImage;
    }

    @Override
    public void run() {
        long timestamp = System.currentTimeMillis();
        try {
            if (StringUtils.isBlank((CharSequence)this.filename)) {
                return;
            }
            if (FilenameUtils.getExtension((String)this.filename).equalsIgnoreCase("JPEG")) {
                this.filename = FilenameUtils.getBaseName((String)this.filename) + ".jpg";
            }
            String oldFilename = null;
            try {
                String newUrl;
                Path file;
                if (this.firstImage) {
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: {
                            oldFilename = this.entity.getArtworkFilename(MediaFileType.getMediaFileType(this.type));
                            this.entity.removeAllMediaFiles(MediaFileType.getMediaFileType(this.type));
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                LOGGER.debug("writing " + this.type + " " + this.filename);
                Path destFile = this.entity.getPathNIO().resolve(this.filename);
                Path tempFile = this.entity.getPathNIO().resolve(this.filename + "." + timestamp + ".part");
                boolean sameFile = false;
                if (this.url.startsWith("file:") && (file = Paths.get(newUrl = this.url.replace("file:/", ""), new String[0])).equals(destFile)) {
                    sameFile = true;
                }
                if (!sameFile) {
                    Url url1 = new Url(this.url);
                    FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());
                    InputStream is = url1.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                    outputStream.flush();
                    try {
                        outputStream.getFD().sync();
                        Thread.sleep(150L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    outputStream.close();
                    is.close();
                    if (!Files.exists(tempFile, new LinkOption[0]) || Files.size(tempFile) == 0L) {
                        throw new Exception("0byte file downloaded: " + this.filename);
                    }
                    if (StringUtils.isNotBlank((CharSequence)oldFilename)) {
                        Path oldFile = this.entity.getPathNIO().resolve(oldFilename);
                        Utils.deleteFileSafely(oldFile);
                    }
                    Utils.deleteFileSafely(destFile);
                    if (!Utils.moveFileSafe(tempFile, destFile)) {
                        throw new Exception("renaming temp file failed: " + this.filename);
                    }
                }
                if (Thread.interrupted()) {
                    return;
                }
                if (this.firstImage) {
                    LOGGER.debug("set " + this.type + " " + FilenameUtils.getName((String)this.filename));
                    ImageCache.invalidateCachedImage(this.entity.getPathNIO().resolve(this.filename));
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: {
                            this.entity.setArtwork(destFile, MediaFileType.getMediaFileType(this.type));
                            this.entity.callbackForWrittenArtwork(this.type);
                            this.entity.saveToDb();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    LOGGER.warn("interrupted image download");
                } else {
                    LOGGER.error("fetch image", (Throwable)e);
                }
                Path tempFile = this.entity.getPathNIO().resolve(this.filename + "." + timestamp + ".part");
                if (Files.exists(tempFile, new LinkOption[0])) {
                    Utils.deleteFileSafely(tempFile);
                }
                if (this.firstImage && StringUtils.isNotBlank((CharSequence)oldFilename)) {
                    switch (this.type) {
                        case POSTER: 
                        case BACKGROUND: 
                        case BANNER: 
                        case THUMB: 
                        case CLEARART: 
                        case DISC: 
                        case LOGO: 
                        case CLEARLOGO: {
                            this.entity.setArtwork(Paths.get(oldFilename, new String[0]), MediaFileType.getMediaFileType(this.type));
                            this.entity.callbackForWrittenArtwork(this.type);
                            this.entity.saveToDb();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"ArtworkDownload", "message.artwork.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        catch (Exception e) {
            LOGGER.error("crashed thread: ", (Throwable)e);
        }
    }
}

