/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

final class Utils {
    private static final int BUFFER_SIZE = 4096;

    static byte[] streamToBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (stream != null) {
            int r;
            byte[] buf = new byte[4096];
            while ((r = stream.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
        }
        return baos.toByteArray();
    }

    static Request readBodyToBytesIfNecessary(Request request) throws IOException {
        TypedOutput body = request.getBody();
        if (body == null || body instanceof TypedByteArray) {
            return request;
        }
        String bodyMime = body.mimeType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        body.writeTo(baos);
        body = new TypedByteArray(bodyMime, baos.toByteArray());
        return new Request(request.getMethod(), request.getUrl(), request.getHeaders(), body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Response readBodyToBytesIfNecessary(Response response) throws IOException {
        TypedInput body = response.getBody();
        if (body == null || body instanceof TypedByteArray) {
            return response;
        }
        String bodyMime = body.mimeType();
        InputStream is = body.in();
        try {
            byte[] bodyBytes = Utils.streamToBytes(is);
            body = new TypedByteArray(bodyMime, bodyBytes);
            Response response2 = Utils.replaceResponseBody(response, body);
            return response2;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    static Response replaceResponseBody(Response response, TypedInput body) {
        return new Response(response.getUrl(), response.getStatus(), response.getReason(), response.getHeaders(), body);
    }

    static <T> void validateServiceClass(Class<T> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("Only interface endpoint definitions are supported.");
        }
        if (service.getInterfaces().length > 0) {
            throw new IllegalArgumentException("Interface definitions must not extend other interfaces.");
        }
    }

    private Utils() {
    }

    static class SynchronousExecutor
    implements Executor {
        SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

