/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.util.ParserUtils;

public class TvShowEpisodeAndSeasonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeAndSeasonParser.class);
    private static Pattern pattern1 = Pattern.compile("[Ss]([0-9]+)[\\]\\[ _.-]*[Ee]([0-9]+)([^\\\\/]*)$", 2);
    private static Pattern pattern2 = Pattern.compile("[ _.-]()[Ee][Pp]?_?([0-9]+)([^\\\\/]*)$", 2);
    private static Pattern date1 = Pattern.compile("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", 2);
    private static Pattern date2 = Pattern.compile("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", 2);
    private static Pattern pattern5 = Pattern.compile("[\\\\/\\._ \\[\\(-]([0-9]+)x([0-9]+)([^\\\\/]*)$", 2);
    private static Pattern pattern7 = Pattern.compile("[\\/ _.-]p(?:ar)?t[ _.-]()([ivx]+)([ _.-][^\\/]*)$", 2);
    private static Pattern stackingMarkerPattern = Pattern.compile("((.*?)[ _.-]*((?:cd|dvd|p(?:ar)?t|dis[ck]|d)[ _.-]*([0-9]|[a-d])+)|^[a-d]{1})(.*?)", 2);
    private static Pattern episodePattern = Pattern.compile("[epx_-]+(\\d{1,3})", 2);
    private static Pattern episodePattern2 = Pattern.compile("episode[\\. _-]*(\\d{1,2})", 2);
    private static Pattern romanPattern = Pattern.compile("(part|pt)[\\._\\s]+([MDCLXVI]+)", 2);
    private static Pattern seasonPattern = Pattern.compile("(staffel|season|series)[\\s_.-]*(\\d{1,4})", 2);
    private static Pattern seasonMultiEP = Pattern.compile("s(\\d{1,4})((?:([epx_.-]+\\d{1,3})+))", 2);
    private static Pattern seasonMultiEP2 = Pattern.compile("(\\d{1,4})(?=x)((?:([epx]+\\d{1,3})+))", 2);
    private static Pattern numbers2Pattern = Pattern.compile(".*?([0-9]{2}).*", 2);
    private static Pattern numbers3Pattern = Pattern.compile(".*?([0-9])([0-9]{2}).*", 2);
    private static Pattern tvMultipartMatching = Pattern.compile("^[-_ex]+([0-9]+(?:(?:[a-i]|\\.[1-9])(?![0-9]))?)", 2);

    @Deprecated
    public static EpisodeMatchingResult detectEpisodeFromFilename(File file) {
        LOGGER.debug("Detect episodes/seasons from file " + file.getName());
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String fileName = file.getName();
        result = TvShowEpisodeAndSeasonParser.parseString(fileName);
        Collections.sort(result.episodes);
        Matcher matcher = stackingMarkerPattern.matcher(result.name);
        result.stackingMarkerFound = matcher.matches();
        LOGGER.debug("returning result " + result);
        return result;
    }

    public static String cleanEpisodeTitle(String titleToClean, String tvShowName) {
        String basename = FilenameUtils.getBaseName((String)ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(titleToClean));
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher(basename);
        if (m.find()) {
            basename = basename.replaceAll(regex.pattern(), "");
        }
        basename = basename + " ";
        if (tvShowName != null && !tvShowName.isEmpty()) {
            basename = basename.replaceAll("(?i)^" + Pattern.quote(tvShowName) + "", "");
            basename = basename.replaceAll("(?i) " + Pattern.quote(tvShowName) + " ", "");
        }
        basename = basename.replaceFirst("\\.\\w{1,4}$", "");
        basename = basename.replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        return TvShowEpisodeAndSeasonParser.removeEpisodeVariantsFromTitle(basename);
    }

    private static String removeEpisodeVariantsFromTitle(String title) {
        String[] splitted;
        String backup = title;
        String ret = "";
        title = title.replaceAll("[Ss]([0-9]+)[\\]\\[ _.-]*[Ee]([0-9]+)", "");
        title = title.replaceAll("[ _.-]()[Ee][Pp]?_?([0-9]+)", "");
        title = title.replaceAll("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", "");
        title = title.replaceAll("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", "");
        title = title.replaceAll("[\\\\/\\._ \\[\\(-]([0-9]+)x([0-9]+)", "");
        title = title.replaceAll("[\\/ _.-]p(?:ar)?t[ _.-]()([ivx]+)", "");
        title = title.replaceAll("[epx_-]+(\\d{1,3})", "");
        title = title.replaceAll("episode[\\. _-]*(\\d{1,2})", "");
        title = title.replaceAll("(part|pt)[\\._\\s]+([MDCLXVI]+)", "");
        title = title.replaceAll("(staffel|season|series)[\\s_.-]*(\\d{1,4})", "");
        title = title.replaceAll("s(\\d{1,4})((?:([epx_.-]+\\d{1,3})+))", "");
        title = title.replaceAll("(\\d{1,4})(?=x)((?:([epx]+\\d{1,3})+))", "");
        for (String s : splitted = StringUtils.split((String)title, (String)"[\\[\\]() _,.-]")) {
            ret = ret + " " + s;
        }
        if (StringUtils.isEmpty((CharSequence)(ret = ret.trim()))) {
            String[] b = StringUtils.split((String)backup, (String)"[\\[\\]() _,.-]");
            backup = "";
            for (String s : b) {
                backup = backup + " " + s;
            }
            ret = backup.trim();
        }
        return ret;
    }

    public static EpisodeMatchingResult detectEpisodeFromFilenameAlternative(String name, String showname) {
        EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detect(FilenameUtils.getName((String)name), showname);
        if (result.episodes.size() > 0 && result.season == -1) {
            EpisodeMatchingResult result2 = TvShowEpisodeAndSeasonParser.detect(name, showname);
            result.season = result2.season;
        } else if (result.season == -1 && result.episodes.size() == 0) {
            result = TvShowEpisodeAndSeasonParser.detect(name, showname);
        }
        return result;
    }

    public static EpisodeMatchingResult detect(String name, String showname) {
        String numbers;
        int ep;
        Matcher m2;
        Pattern regex2;
        String eps;
        LOGGER.debug("parsing '" + name + "'");
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String filename = FilenameUtils.getName((String)name);
        String extension = FilenameUtils.getExtension((String)name);
        if (filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)") || filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)")) {
            name = FilenameUtils.getPath((String)name);
        }
        String basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(name);
        String foldername = "";
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher(basename);
        if (m.find()) {
            foldername = m.group(1);
            basename = basename.replaceAll(regex.pattern(), "");
        }
        if (basename.isEmpty() && foldername.isEmpty()) {
            return result;
        }
        if (showname != null && !showname.isEmpty()) {
            basename = basename.replaceAll("(?i)^" + Pattern.quote(showname) + "", "");
            basename = basename.replaceAll("(?i) " + Pattern.quote(showname) + " ", "");
        }
        basename = basename.replaceFirst("\\.\\w{1,4}$", "");
        basename = basename.replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = basename + " ";
        result.stackingMarkerFound = !Utils.getStackingMarker(filename).isEmpty();
        result.name = basename.trim();
        if (result.season == -1 && (m = (regex = seasonPattern).matcher(foldername + basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season " + s);
        }
        regex = seasonMultiEP;
        m = regex.matcher(foldername + basename);
        int lastFoundEpisode = 0;
        while (m.find()) {
            int s = -1;
            try {
                s = Integer.parseInt(m.group(1));
                eps = m.group(2);
                regex2 = episodePattern;
                m2 = regex2.matcher(eps);
                while (m2.find()) {
                    ep = 0;
                    try {
                        ep = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (ep <= 0 || result.episodes.contains(ep) || lastFoundEpisode != 0 && lastFoundEpisode + 1 != ep) continue;
                    lastFoundEpisode = ep;
                    result.episodes.add(ep);
                    LOGGER.trace("add found EP " + ep);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season " + s);
        }
        regex = seasonMultiEP2;
        m = regex.matcher(foldername + basename);
        while (m.find()) {
            int s = -1;
            try {
                if (m.group(2) != null && result.season == -1) {
                    s = Integer.parseInt(m.group(1));
                }
                eps = m.group(2);
                regex2 = episodePattern;
                m2 = regex2.matcher(eps);
                while (m2.find()) {
                    ep = 0;
                    try {
                        ep = Integer.parseInt(m2.group(1));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (ep <= 0 || result.episodes.contains(ep)) continue;
                    result.episodes.add(ep);
                    LOGGER.trace("add found EP " + ep);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (s < 0) continue;
            result.season = s;
            LOGGER.trace("add found season " + s);
        }
        if (result.episodes.isEmpty()) {
            regex = episodePattern2;
            m = regex.matcher(basename);
            while (m.find()) {
                int ep2 = 0;
                try {
                    ep2 = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ep2 <= 0 || result.episodes.contains(ep2)) continue;
                result.episodes.add(ep2);
                LOGGER.trace("add found EP " + ep2);
            }
        }
        if ((numbers = basename.replaceAll("[^0-9]", "")).length() == 3) {
            int ep3;
            regex = numbers3Pattern;
            m = regex.matcher(basename);
            if (m.find()) {
                int s = Integer.parseInt(m.group(1));
                int ep4 = Integer.parseInt(m.group(2));
                if (ep4 > 0 && !result.episodes.contains(ep4)) {
                    result.episodes.add(ep4);
                    LOGGER.trace("add found EP " + ep4);
                }
                LOGGER.trace("add found season " + s);
                result.season = s;
                return result;
            }
            regex = numbers2Pattern;
            m = regex.matcher(basename);
            if (m.find() && (ep3 = Integer.parseInt(m.group(1))) > 0 && !result.episodes.contains(ep3)) {
                result.episodes.add(ep3);
                LOGGER.trace("add found EP " + ep3);
            }
        } else if (numbers.length() == 2) {
            regex = numbers2Pattern;
            m = regex.matcher(basename);
            if (m.find()) {
                int ep5 = Integer.parseInt(m.group(1));
                if (ep5 > 0 && !result.episodes.contains(ep5)) {
                    result.episodes.add(ep5);
                    LOGGER.trace("add found EP " + ep5);
                }
                return result;
            }
        } else if (numbers.length() == 1) {
            int ep6 = Integer.parseInt(numbers);
            if (ep6 > 0 && !result.episodes.contains(ep6)) {
                result.episodes.add(ep6);
                LOGGER.trace("add found EP " + ep6);
            }
            return result;
        }
        if (result.episodes.isEmpty()) {
            regex = romanPattern;
            m = regex.matcher(basename);
            while (m.find()) {
                int ep7 = 0;
                ep7 = TvShowEpisodeAndSeasonParser.decodeRoman(m.group(2));
                if (ep7 <= 0 || result.episodes.contains(ep7)) continue;
                result.episodes.add(ep7);
                LOGGER.trace("add found EP " + ep7);
            }
        }
        if (result.season == -1 && (m = date1.matcher(basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
                result.date = new SimpleDateFormat("yyyy-MM-dd").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException nfe) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season " + s + " date: " + result.date);
            return result;
        }
        if (result.season == -1 && (m = date2.matcher(basename)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(3));
                result.date = new SimpleDateFormat("dd-MM-yyyy").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException nfe) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season " + s + " date: " + result.date);
            return result;
        }
        basename = basename.replaceAll("\\[.*?\\]", "");
        if (result.episodes.isEmpty()) {
            regex = episodePattern;
            m = regex.matcher(basename);
            while (m.find()) {
                int ep8 = 0;
                try {
                    ep8 = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ep8 <= 0 || result.episodes.contains(ep8)) continue;
                result.episodes.add(ep8);
                LOGGER.trace("add found EP " + ep8);
            }
        }
        Collections.sort(result.episodes);
        LOGGER.debug("returning result " + result);
        return result;
    }

    @Deprecated
    public static EpisodeMatchingResult detectEpisodeFromDirectory(File directory, String rootDirOfTvShow) {
        LOGGER.debug("Detect episodes/seasons from " + directory.getAbsolutePath());
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        if (rootDirOfTvShow == null || rootDirOfTvShow.isEmpty() || directory.toURI().equals(new File(rootDirOfTvShow).toURI())) {
            return result;
        }
        String directoryName = directory.getName();
        result = TvShowEpisodeAndSeasonParser.parseString(directoryName);
        if (result.episodes.size() == 0) {
            TvShowEpisodeAndSeasonParser.detectEpisodeFromDirectory(directory.getParentFile(), rootDirOfTvShow);
        }
        Collections.sort(result.episodes);
        LOGGER.debug("returning result " + result);
        return result;
    }

    @Deprecated
    private static EpisodeMatchingResult parseString(String stringToParse) {
        LOGGER.trace("parse String " + stringToParse);
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        EpisodeMatchingResult resultFromParser = new EpisodeMatchingResult();
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, pattern1);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, pattern2);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, date1);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, date2);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, pattern5);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        resultFromParser = TvShowEpisodeAndSeasonParser.parse(stringToParse, pattern7);
        result = TvShowEpisodeAndSeasonParser.combineResults(result, resultFromParser);
        result.name = result.name.replaceAll("^[ .\\-_]+", "").trim();
        return result;
    }

    private static EpisodeMatchingResult combineResults(EpisodeMatchingResult result, EpisodeMatchingResult resultFromParser) {
        if (result.season < 0 && resultFromParser.season >= 0) {
            result.season = resultFromParser.season;
        }
        if (result.episodes.size() == 0 && resultFromParser.episodes.size() > 0) {
            for (int episode : resultFromParser.episodes) {
                if (result.episodes.contains(episode)) continue;
                result.episodes.add(episode);
            }
        }
        if (StringUtils.isBlank((CharSequence)result.name) && StringUtils.isNotBlank((CharSequence)resultFromParser.name)) {
            result.name = resultFromParser.name;
        }
        return result;
    }

    @Deprecated
    private static EpisodeMatchingResult parse(String searchString, Pattern pattern) {
        LOGGER.trace("parsing " + searchString + " with " + pattern.toString());
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        Matcher m = pattern.matcher(searchString);
        while (m.find()) {
            int ep = 0;
            try {
                ep = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException nfe) {
                ep = TvShowEpisodeAndSeasonParser.decodeRoman(m.group(2));
            }
            if (ep > 0 && !result.episodes.contains(ep)) {
                LOGGER.trace("found episode " + ep + " for " + searchString + " with " + pattern.toString());
                result.episodes.add(ep);
            }
            if (result.season < 0) {
                int season = -1;
                try {
                    season = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                result.season = season;
            }
            if (!StringUtils.isBlank((CharSequence)result.name)) continue;
            EpisodeMatchingResult newResult = TvShowEpisodeAndSeasonParser.parseString(" " + m.group(3));
            if (newResult.episodes.size() > 0) {
                result.episodes.addAll(newResult.episodes);
                continue;
            }
            result.name = FilenameUtils.getBaseName((String)m.group(3));
        }
        LOGGER.trace("matching result " + result);
        return result;
    }

    @Deprecated
    public static int detectSeason(String relativePath) {
        LOGGER.info("detect season from path " + relativePath);
        int season = -1;
        Pattern regex = Pattern.compile("(?i)(?:s|season|staffel)[\\s]*(\\d+)");
        Matcher m = regex.matcher(relativePath);
        if (m.find()) {
            try {
                season = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        LOGGER.debug("returning result " + season);
        return season;
    }

    private static int decodeSingleRoman(char letter) {
        switch (letter) {
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        return 0;
    }

    public static int decodeRoman(String roman) {
        int result = 0;
        String uRoman = roman.toUpperCase(Locale.ROOT);
        for (int i = 0; i < uRoman.length() - 1; ++i) {
            if (TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i)) < TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i + 1))) {
                result -= TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
                continue;
            }
            result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
        }
        return result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(uRoman.length() - 1));
    }

    public static class EpisodeMatchingResult {
        public int season = -1;
        public List<Integer> episodes = new ArrayList<Integer>();
        public String name = "";
        public Date date = null;
        public boolean stackingMarkerFound = false;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

