/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum MovieTrailerSources {
    YOUTUBE("Youtube", Arrays.asList("youtube")),
    APPLE("Apple", Arrays.asList("apple")),
    AOL("Aol", Arrays.asList("aol")),
    HDTRAILERS("HD Trailers", Arrays.asList("hdtrailers"));

    private String displayText;
    private List<String> possibleSources;

    private MovieTrailerSources(String text, List<String> sources) {
        this.displayText = text;
        this.possibleSources = sources;
    }

    public boolean containsSource(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        for (String s : this.possibleSources) {
            if (!source.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.displayText;
    }
}

