/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.a.c.b;
import com.a.c.q;
import com.a.c.r;
import com.a.c.s;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.a;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MetaProgressObserver;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    protected File _appdir;
    protected String _appid;
    protected File _config;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _name;
    protected String _dockIconPath;
    protected boolean _windebug;
    protected boolean _allowOffline;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected boolean _skipMD5cache;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?.*";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected List<Resource> _codes = new ArrayList<Resource>();
    protected List<String> _plugins = new ArrayList<String>();
    protected List<String> _delete = new ArrayList<String>();
    protected List<Resource> _resources = new ArrayList<Resource>();
    protected List<String> _deleteAbandonedFilesInDir = new ArrayList<String>();
    protected Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected List<String> _jvmargs = new ArrayList<String>();
    protected List<String> _appargs = new ArrayList<String>();
    protected String[] _extraJvmArgs;
    protected String[] _extraAppArgs;
    protected String[] _optimumJvmArgs;
    protected List<String> _txtJvmArgs = new ArrayList<String>();
    protected List<Certificate> _signers;
    protected boolean _warnedAboutSetLastModified;
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected static final String[] SA_PROTO = b.a;

    public Application(File file, String string) {
        this(file, string, null, null, null);
    }

    public Application(File file, String string, List<Certificate> list, String[] stringArray, String[] stringArray2) {
        this._appdir = file;
        this._appid = string;
        this._signers = list == null ? Collections.emptyList() : list;
        this._config = this.getLocalPath(CONFIG_FILE);
        this._extraJvmArgs = stringArray == null ? b.a : stringArray;
        this._extraAppArgs = stringArray2 == null ? b.a : stringArray2;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, false);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid appbase '" + this._vappbase + "'.", exception);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getActiveCodeResources());
        arrayList.addAll(this.getActiveResources());
        return arrayList;
    }

    public AuxGroup getAuxGroup(String string) {
        return this._auxgroups.get(string);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String string) {
        Boolean bl = this._auxactive.get(string);
        if (bl == null) {
            bl = this.getLocalPath(string + ".dat").exists();
            this._auxactive.put(string, bl);
        }
        return bl;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getCodeResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.codes);
        }
        return arrayList;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.rsrcs);
        }
        return arrayList;
    }

    public Resource getPatchResource(String string) {
        if (this._targetVersion <= this._version) {
            Log.log.b("Requested patch resource for up-to-date or non-versioned application", "cvers", this._version, "tvers", this._targetVersion);
            return null;
        }
        string = string == null ? "" : "-" + string;
        string = "patch" + string + this._version + ".dat";
        try {
            URL uRL = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(string));
            return new Resource(string, uRL, this.getLocalPath(string), false, this._skipMD5cache);
        }
        catch (Exception exception) {
            Log.log.b("Failed to create patch resource path", "pfile", string, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public Resource getJavaVMResource() {
        if (s.a(this._javaLocation)) {
            return null;
        }
        String string = "java_vm.jar";
        try {
            URL uRL = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(this._javaLocation));
            return new Resource(string, uRL, this.getLocalPath(string), true, this._skipMD5cache);
        }
        catch (Exception exception) {
            Log.log.b("Failed to create VM resource", "vmfile", string, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", exception);
            return null;
        }
    }

    public Resource getFullResource() {
        String string = "full";
        try {
            URL uRL = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(string));
            return new Resource(string, uRL, this.getLocalPath(string), false, this._skipMD5cache);
        }
        catch (Exception exception) {
            Log.log.b("Failed to create full resource path", "file", string, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public URL getTrackingURL(String string) {
        try {
            String string2 = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String string3 = this.getGATrackingCode();
            if (this._trackingURL == null) {
                return null;
            }
            return new URL(Application.encodePath(this._trackingURL + string + string2 + string3));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log.b("Invalid tracking URL", "path", this._trackingURL, "event", string, "error", malformedURLException);
            return null;
        }
    }

    public URL getTrackingProgressURL(int n2) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(n2)) {
            return null;
        }
        return this.getTrackingURL("pct" + n2);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    /*
     * WARNING - void declaration
     */
    public UpdateInterface init(boolean bl) throws IOException {
        String string;
        void var1_23;
        int n2;
        int n3;
        UpdateInterface.Step[] stepArray;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Map<String, Object> map;
        block47: {
            map = null;
            Object object = this._config;
            try {
                if (((File)object).exists()) {
                    map = ConfigUtil.parseConfig(this._config, bl);
                } else {
                    object = this.getLocalPath("getdown.txt_old");
                    if (((File)object).exists()) {
                        map = ConfigUtil.parseConfig((File)object, bl);
                    } else {
                        Log.log.a("Found no getdown.txt file", "appdir", this._appdir);
                    }
                }
            }
            catch (Exception exception) {
                Log.log.b("Failure reading config file", "file", object, exception);
            }
            if (map == null) {
                String string7 = SysProps.appBase();
                Log.log.a("Attempting to obtain 'appbase' from system property", "appbase", string7);
                map = new HashMap<String, Object>();
                map.put("appbase", string7);
            }
            this._appbase = (String)map.get("appbase");
            if (this._appbase == null) {
                throw new RuntimeException("m.missing_appbase");
            }
            if (!this._appbase.endsWith("/")) {
                this._appbase = this._appbase + "/";
            }
            this._appbase = this.replaceDomain(this._appbase);
            String string8 = (String)map.get("version");
            if (string8 != null) {
                this._version = Application.parseLong(string8, "m.invalid_version");
            }
            try {
                this._vappbase = this._version < 0L ? new URL(this._appbase) : this.createVAppBase(this._version);
            }
            catch (MalformedURLException malformedURLException) {
                object = com.a.a.a.b("m.invalid_appbase", this._appbase);
                throw (IOException)new IOException((String)object).initCause(malformedURLException);
            }
            if (bl && !SysProps.noUpdate()) {
                try {
                    File file = this.downloadFile("digest.txt");
                    file.delete();
                }
                catch (IOException iOException) {
                    boolean bl2 = true;
                    Log.log.b("Unable to download from primary appbase", "message", iOException.getMessage(), iOException);
                    String[] object3 = ConfigUtil.getMultiValue(map, "mirror");
                    if (object3 != null) {
                        String[] object2 = object3;
                        int n4 = object3.length;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            String string9 = object2[i2];
                            if (!string9.endsWith("/")) {
                                string9 = string9 + "/";
                            }
                            try {
                                this._vappbase = new URL(string9);
                                File file = this.downloadFile("digest.txt");
                                file.delete();
                                bl2 = false;
                            }
                            catch (IOException iOException2) {
                                Log.log.b("Unable to download from primary mirror", "message", iOException2.getMessage(), iOException2);
                            }
                            if (!bl2) break;
                        }
                    }
                    if (!bl2) break block47;
                    String i5 = com.a.a.a.b("m.invalid_appbase", this._appbase);
                    throw new IOException(i5);
                }
            }
        }
        if ((string6 = (String)map.get("latest")) != null) {
            String string10 = this.replaceDomain(string6);
            try {
                this._latest = new URL(string10);
            }
            catch (MalformedURLException malformedURLException) {
                Log.log.b("Invalid URL for latest attribute.", malformedURLException);
            }
        }
        String string11 = s.a(this._appid) ? "" : this._appid + ".";
        this._class = (String)map.get(string11 + "class");
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        String string12 = (String)map.get("java_version_prop");
        if (string12 != null) {
            this._javaVersionProp = string12;
        }
        if ((string5 = (String)map.get("java_version_regex")) != null) {
            this._javaVersionRegex = string5;
        }
        if ((string4 = (String)map.get("java_version")) != null) {
            this._javaMinVersion = Application.parseLong(string4, "m.invalid_java_version");
        }
        if ((string3 = (String)map.get("java_min_version")) != null) {
            this._javaMinVersion = Application.parseLong(string3, "m.invalid_java_version");
        }
        if ((string2 = (String)map.get("java_max_version")) != null) {
            this._javaMaxVersion = Application.parseLong(string2, "m.invalid_java_version");
        }
        String string13 = (String)map.get("java_exact_version_required");
        this._javaExactVersionRequired = Boolean.parseBoolean(string13);
        Object object = map.get("java_location");
        if (object instanceof String) {
            this._javaLocation = (String)object;
        }
        this._trackingURL = (String)map.get("tracking_url");
        String string14 = (String)map.get("tracking_percents");
        if (!s.a(string14)) {
            this._trackingPcts = new HashSet<Integer>();
            for (int n5 : s.d(string14)) {
                this._trackingPcts.add(n5);
            }
        } else if (!s.a(this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = (String)map.get("tracking_cookie_name");
        this._trackingCookieProperty = (String)map.get("tracking_cookie_property");
        this._trackingURLSuffix = (String)map.get("tracking_url_suffix");
        this._trackingGAHash = (String)map.get("tracking_ga_hash");
        this._skipMD5cache = Boolean.parseBoolean((String)map.get("skip_md5_cache"));
        Log.log.a("remove verification files? " + this._skipMD5cache, new Object[0]);
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        if (ConfigUtil.getMultiValue(map, "code") == null && ConfigUtil.getMultiValue(map, "ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(map, "code", false, this._codes);
        this.parseResources(map, "ucode", true, this._codes);
        this.parseStringResources(map, "plugin", false, this._plugins);
        this.parseStringResources(map, "delete", false, this._delete);
        this.parseStringResources(map, "deleteAbandonedFilesInDir", false, this._deleteAbandonedFilesInDir);
        this.parseResources(map, "resource", false, this._resources);
        this.parseResources(map, "uresource", true, this._resources);
        for (String string15 : this.parseList(map, "auxgroups")) {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            this.parseResources(map, string15 + ".code", false, arrayList);
            this.parseResources(map, string15 + ".ucode", true, arrayList);
            stepArray = new ArrayList();
            this.parseResources(map, string15 + ".resource", false, (List<Resource>)stepArray);
            this.parseResources(map, string15 + ".uresource", true, (List<Resource>)stepArray);
            this._auxgroups.put(string15, new AuxGroup(string15, arrayList, (List<Resource>)stepArray));
        }
        String[] stringArray = ConfigUtil.getMultiValue(map, "jvmarg");
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                String string16 = stringArray2[i3];
                this._jvmargs.add(string16);
            }
        }
        Object object3 = this._extraJvmArgs;
        n3 = this._extraJvmArgs.length;
        for (n2 = 0; n2 < n3; ++n2) {
            String string17 = object3[n2];
            this._jvmargs.add(string17);
        }
        this._optimumJvmArgs = ConfigUtil.getMultiValue(map, "optimum_jvmarg");
        object3 = ConfigUtil.getMultiValue(map, string11 + "apparg");
        if (object3 != null) {
            void var1_21;
            String[] stringArray3 = object3;
            n2 = ((String[])object3).length;
            boolean bl3 = false;
            while (var1_21 < n2) {
                stepArray = stringArray3[var1_21];
                this._appargs.add((String)stepArray);
                ++var1_21;
            }
        }
        Object object4 = this._extraAppArgs;
        n2 = this._extraAppArgs.length;
        boolean bl4 = false;
        while (var1_23 < n2) {
            stepArray = object4[var1_23];
            this._appargs.add((String)stepArray);
            ++var1_23;
        }
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        this._allowOffline = Boolean.parseBoolean((String)map.get("allow_offline"));
        this._windebug = this.getLocalPath("debug.txt").exists();
        object4 = new UpdateInterface();
        this._name = object4.name = (String)map.get("ui.name");
        object4.progress = this.parseRect(map, "ui.progress", object4.progress);
        object4.progressText = this.parseColor(map, "ui.progress_text", object4.progressText);
        object4.hideProgressText = Boolean.parseBoolean((String)map.get("ui.hide_progress_text"));
        object4.progressBar = this.parseColor(map, "ui.progress_bar", object4.progressBar);
        object4.status = this.parseRect(map, "ui.status", object4.status);
        object4.statusText = this.parseColor(map, "ui.status_text", object4.statusText);
        object4.textShadow = this.parseColor(map, "ui.text_shadow", object4.textShadow);
        object4.hideDecorations = Boolean.parseBoolean((String)map.get("ui.hide_decorations"));
        object4.backgroundImage = (String)map.get("ui.background_image");
        if (object4.backgroundImage == null) {
            object4.backgroundImage = (String)map.get("ui.background");
        }
        Color color = 0.5f < Color.RGBtoHSB(object4.progressText.getRed(), object4.progressText.getGreen(), object4.progressText.getBlue(), null)[2] ? Color.BLACK : Color.WHITE;
        object4.background = this.parseColor(map, "ui.background", color);
        object4.progressImage = (String)map.get("ui.progress_image");
        object4.rotatingBackgrounds = ConfigUtil.getMultiValue(map, "ui.rotating_background");
        object4.iconImages = ConfigUtil.getMultiValue(map, "ui.icon");
        object4.errorBackground = (String)map.get("ui.error_background");
        this._dockIconPath = (String)map.get("ui.mac_dock_icon");
        if (this._dockIconPath == null) {
            this._dockIconPath = "../desktop.icns";
        }
        object4.installError = (string = this.parseUrl(map, "ui.install_error", null)) == null ? "m.default_install_error" : com.a.a.a.a((Object)string);
        object4.patchNotes = this.parseRect(map, "ui.patch_notes", object4.patchNotes);
        object4.patchNotesUrl = this.parseUrl(map, "ui.patch_notes_url", null);
        object4.playAgain = this.parseRect(map, "ui.play_again", object4.playAgain);
        object4.playAgainImage = (String)map.get("ui.play_again_image");
        for (UpdateInterface.Step step : UpdateInterface.Step.values()) {
            object3 = (String)map.get("ui.percents." + step.name());
            if (object3 == null) continue;
            try {
                object4.stepPercentages.put(step, Application.intsToList(s.d((String)object3)));
            }
            catch (Exception exception) {
                Log.log.b("Failed to parse percentages for " + (Object)((Object)step) + ": " + (String)object3, new Object[0]);
            }
        }
        return object4;
    }

    protected void fillAssignmentListFromPairs(String object, List<String> list) {
        if (((File)(object = this.getLocalPath((String)object))).exists()) {
            try {
                Object object2 = ConfigUtil.parsePairs((File)object, false);
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String[] stringArray = (String[])object2.next();
                    if (stringArray[1].length() == 0) {
                        list.add(stringArray[0]);
                        continue;
                    }
                    list.add(stringArray[0] + "=" + stringArray[1]);
                }
                return;
            }
            catch (Throwable throwable) {
                Log.log.b("Failed to parse '" + object + "': " + throwable, new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String string) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(string));
    }

    public File getLocalPath(String string) {
        return new File(this._appdir, string);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            boolean bl;
            long l2 = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.a("Checking Java version", "current", l2, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion);
            Object object = this.getJavaVMResource();
            if (object != null && ((Resource)object).isMarkedValid()) {
                object = new File(this._appdir, "java_vm");
                File file = new File((File)object, "release");
                if (!file.exists()) {
                    Log.log.b("Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long l3 = VersionUtil.readReleaseVersion(file, this._javaVersionRegex);
                if (l3 == 0L) {
                    Log.log.b("Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                l2 = l3;
                Log.log.a("Checking version of unpacked JVM [vers=" + l2 + "].", new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (l2 == this._javaMinVersion) {
                    return true;
                }
                Log.log.b("An exact Java VM version is required.", "current", l2, "required", this._javaMinVersion);
                return false;
            }
            boolean bl2 = this._javaMinVersion == 0L || l2 >= this._javaMinVersion;
            boolean bl3 = bl = this._javaMaxVersion == 0L || l2 <= this._javaMaxVersion;
            return bl2 && bl;
        }
        catch (RuntimeException runtimeException) {
            Log.log.b("Unable to parse VM version, hoping for the best", "error", runtimeException, "needed", this._javaMinVersion);
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay statusDisplay) throws IOException {
        statusDisplay.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException malformedURLException) {
            String string = com.a.a.a.b("m.invalid_appbase", this._appbase);
            throw (IOException)new IOException(string).initCause(malformedURLException);
        }
        try {
            this.downloadDigestFile();
            this.downloadConfigFile();
            return;
        }
        catch (IOException iOException) {
            if (this._allowOffline) {
                Log.log.b("Failed to update digest files.  Attempting offline operaton.", iOException);
                if (!this.getLocalPath(VERSION_FILE).delete()) {
                    Log.log.b("Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                    return;
                }
            } else {
                throw iOException;
            }
            return;
        }
    }

    public Process createProcess(boolean bl) throws IOException {
        String string;
        Object object2 = new StringBuilder();
        for (Resource object3 : this.getActiveCodeResources()) {
            if (((StringBuilder)object2).length() > 0) {
                ((StringBuilder)object2).append(File.pathSeparator);
            }
            ((StringBuilder)object2).append(object3.getFinalTarget().getAbsolutePath());
        }
        for (String string2 : this._plugins) {
            if (((StringBuilder)object2).length() > 0) {
                ((StringBuilder)object2).append(File.pathSeparator);
            }
            ((StringBuilder)object2).append(string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LaunchUtil.getJVMPath(this._appdir, this._windebug || bl));
        arrayList.add("-classpath");
        arrayList.add(((StringBuilder)object2).toString());
        if (r.b()) {
            arrayList.add("-Xdock:icon=" + this.getLocalPath(this._dockIconPath).getAbsolutePath());
            arrayList.add("-Xdock:name=" + this._name);
        }
        if ((string = System.getProperty("http.proxyHost")) != null) {
            arrayList.add("-Dhttp.proxyHost=" + string);
            arrayList.add("-Dhttp.proxyPort=" + System.getProperty("http.proxyPort"));
        }
        arrayList.add("-Dcom.threerings.getdown=true");
        for (Map.Entry entry : System.getProperties().entrySet()) {
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            string3 = string3.substring(4);
            arrayList.add("-D" + string3 + "=" + entry.getValue());
        }
        for (String string4 : this._jvmargs) {
            arrayList.add(this.processArg(string4));
        }
        if (bl && this._optimumJvmArgs != null) {
            object2 = this._optimumJvmArgs;
            int n2 = this._optimumJvmArgs.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string = object2[i2];
                arrayList.add(this.processArg(string));
            }
        }
        for (String string5 : this._txtJvmArgs) {
            arrayList.add(this.processArg(string5));
        }
        arrayList.add(this._class);
        for (String string6 : this._appargs) {
            arrayList.add(this.processArg(string6));
        }
        object2 = this.createEnvironment();
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Log.log.a("Running " + s.a(objectArray, "\n  "), new Object[0]);
        return Runtime.getRuntime().exec((String[])objectArray, (String[])object2, this._appdir);
    }

    protected String[] createEnvironment() {
        Object[] objectArray = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", (List<String>)objectArray);
        if (objectArray.isEmpty()) {
            Log.log.a("Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : objectArray) {
            arrayList.add(this.processArg(object));
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            arrayList.add(entry.getKey() + "=" + entry.getValue());
        }
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        Log.log.a("Environment " + s.a(objectArray, "\n "), new Object[0]);
        return objectArray;
    }

    public void invokeDirect(JApplet jApplet) {
        Object object;
        ArrayList<URL> object32 = new ArrayList<URL>();
        for (Resource resource : this.getActiveCodeResources()) {
            try {
                object32.add(new URL("file", "", resource.getFinalTarget().getAbsolutePath()));
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace(System.err);
            }
        }
        a a2 = new a(this, object32.toArray(new URL[object32.size()]), ClassLoader.getSystemClassLoader());
        for (String string : this._jvmargs) {
            if (!string.startsWith("-D")) continue;
            String string2 = this.processArg(string.substring(2));
            int n2 = string2.indexOf("=");
            if (n2 == -1) {
                Log.log.b("Bogus system property: '" + string2 + "'?", new Object[0]);
                continue;
            }
            System.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            object = (String)entry.getKey();
            if (!((String)object).startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            object = ((String)object).substring(4);
            hashMap.put((String)object, (String)entry.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        System.setProperty("applet", "true");
        try {
            Class<?> clazz = a2.loadClass(this._class);
            String[] stringArray = this._appargs.toArray(new String[this._appargs.size()]);
            try {
                object = clazz.getMethod("main", JApplet.class, SA_PROTO.getClass());
                ((Method)object).invoke(null, jApplet, stringArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = clazz.getMethod("main", SA_PROTO.getClass());
                ((Method)object).invoke(null, new Object[]{stringArray});
                return;
            }
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            exception.printStackTrace(System.err);
        }
    }

    protected String processArg(String string) {
        string = string.replace("%APPDIR%", this._appdir.getAbsolutePath());
        string = string.replace("%VERSION%", String.valueOf(this._version));
        return string;
    }

    public boolean verifyMetadata(StatusDisplay statusDisplay) throws IOException {
        Object object;
        File file;
        Object object2;
        Iterator<String> iterator;
        Log.log.a("Verifying application: " + this._vappbase, new Object[0]);
        Log.log.a("Version: " + this._version, new Object[0]);
        Log.log.a("Class: " + this._class, new Object[0]);
        try {
            this._digest = new Digest(this._appdir);
        }
        catch (IOException iOException) {
            Log.log.a("Failed to load digest: " + iOException.getMessage() + ". Attempting recovery...", new Object[0]);
        }
        if (this._version == -1L) {
            iterator = this._digest == null ? "" : this._digest.getMetaDigest();
            try {
                statusDisplay.updateStatus("m.checking");
                this.downloadDigestFile();
                this._digest = new Digest(this._appdir);
                if (!((String)((Object)iterator)).equals(this._digest.getMetaDigest())) {
                    Log.log.a("Unversioned digest changed. Revalidating...", new Object[0]);
                    statusDisplay.updateStatus("m.validating");
                    this.clearValidationMarkers();
                }
            }
            catch (IOException iOException) {
                Log.log.b("Failed to refresh non-versioned digest: " + iOException.getMessage() + ". Proceeding...", new Object[0]);
            }
        }
        if (this._digest == null) {
            statusDisplay.updateStatus("m.updating_metadata");
            this.downloadDigestFile();
            this._digest = new Digest(this._appdir);
        }
        iterator = this._delete.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (object2 == null || ((String)object2).isEmpty()) continue;
            if (!this._digest._digests.containsKey(object2)) {
                file = new File(this._appdir, (String)object2);
                if (!file.isFile()) continue;
                file.delete();
                continue;
            }
            Log.log.b("Attempting to delete file " + (String)object2 + ", but it IS referenced in digest.txt - skipping.", new Object[0]);
        }
        if (this._deleteAbandonedFilesInDir.size() > 0) {
            iterator = this._deleteAbandonedFilesInDir.iterator();
            while (iterator.hasNext()) {
                Object object3;
                object2 = iterator.next();
                if (object2 == null || ((String)object2).isEmpty() || !(file = new File(this._appdir, (String)object2)).isDirectory() || (object3 = file.list()) == null || ((String[])object3).length == 0) continue;
                object = object3;
                int n2 = ((String[])object3).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = object[i2];
                    String[] stringArray = (String)object2 + "/" + (String)string;
                    if (this._digest._digests.containsKey(stringArray)) continue;
                    Log.log.a("file " + (String)string + " seems not to be needed - deleting.", new Object[0]);
                    object3 = new File(file, string);
                    object3.delete();
                }
            }
        }
        if (!this._digest.validateResource((Resource)((Object)(iterator = this.getConfigResource())), null)) {
            statusDisplay.updateStatus("m.updating_metadata");
            this.downloadConfigFile();
            this.downloadDigestFile();
            this._digest = new Digest(this._appdir);
            this.clearValidationMarkers();
            if (this._digest.validateResource((Resource)((Object)iterator), null)) {
                this.init(true);
            } else {
                Log.log.b("getdown.txt failed to validate even after redownloading. Blindly forging onward.", new Object[0]);
            }
        }
        this._targetVersion = this._version;
        if (this._version != -1L) {
            object2 = this.getLocalPath(VERSION_FILE);
            long l2 = VersionUtil.readVersion((File)object2);
            if (l2 != -1L) {
                this._targetVersion = l2;
            }
            if (this._latest != null) {
                object = null;
                PrintStream printStream = null;
                try {
                    object = ConnectionUtil.open(this._latest).getInputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                    for (String[] stringArray : ConfigUtil.parsePairs(bufferedReader, false)) {
                        if (!stringArray[0].equals("version")) continue;
                        this._targetVersion = Math.max(Long.parseLong(stringArray[1]), this._targetVersion);
                        if (l2 != -1L && this._targetVersion > l2) {
                            printStream = new PrintStream(new FileOutputStream((File)object2));
                            printStream.println(this._targetVersion);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    Log.log.b("Unable to retrieve version from latest config file.", exception);
                }
                finally {
                    com.a.a.a.a((InputStream)object);
                    com.a.a.a.a(printStream);
                }
            }
        }
        return this._version != this._targetVersion;
    }

    public List<Resource> verifyResources(ProgressObserver object, int[] nArray, Set<Resource> set) throws InterruptedException {
        Object object2 = this.getAllActiveResources();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        long l2 = 0L;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            Resource resource = object3.next();
            l2 += resource.getLocal().length();
        }
        object3 = new MetaProgressObserver((ProgressObserver)object, l2);
        boolean bl = SysProps.noUnpack();
        object = object2.iterator();
        while (object.hasNext()) {
            block15: {
                object2 = (Resource)object.next();
                if (Thread.interrupted()) {
                    throw new InterruptedException("m.applet_stopped");
                }
                ((MetaProgressObserver)object3).startElement(((Resource)object2).getLocal().length());
                if (((Resource)object2).isMarkedValid()) {
                    if (nArray != null) {
                        nArray[0] = nArray[0] + 1;
                    }
                    ((MetaProgressObserver)object3).progress(100);
                    continue;
                }
                try {
                    if (!this._digest.validateResource((Resource)object2, (ProgressObserver)object3)) break block15;
                    if (bl || !((Resource)object2).shouldUnpack()) {
                        ((Resource)object2).markAsValid();
                        continue;
                    }
                    if (((Resource)object2).unpack()) {
                        set.add((Resource)object2);
                        ((Resource)object2).markAsValid();
                        continue;
                    }
                    Log.log.a("Failure unpacking resource", "rsrc", object2);
                }
                catch (Exception exception) {
                    Log.log.a("Failure validating resource. Requesting redownload...", "rsrc", object2, "error", exception);
                }
                finally {
                    ((MetaProgressObserver)object3).progress(100);
                    continue;
                }
            }
            arrayList.add((Resource)object2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void unpackResources(ProgressObserver object3, Set<Resource> set) throws InterruptedException {
        List<Resource> list = this.getActiveResources();
        long l2 = 0L;
        Object object = list.iterator();
        while (object.hasNext()) {
            void var2_4;
            Resource resource = object.next();
            if (resource.shouldUnpack() && !var2_4.contains(resource)) {
                l2 += resource.getLocal().length();
                continue;
            }
            object.remove();
        }
        object = new MetaProgressObserver((ProgressObserver)object3, l2);
        for (Resource resource : list) {
            if (Thread.interrupted()) {
                throw new InterruptedException("m.applet_stopped");
            }
            ((MetaProgressObserver)object).startElement(resource.getLocal().length());
            if (!resource.unpack()) {
                Log.log.a("Failure unpacking resource", "rsrc", resource);
            }
            ((MetaProgressObserver)object).progress(100);
        }
    }

    public void clearValidationMarkers() {
        this.clearValidationMarkers(this.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long l2) throws MalformedURLException {
        return new URL(this._appbase.replace("%VERSION%", "" + l2));
    }

    protected void clearValidationMarkers(Iterator<Resource> iterator) {
        while (iterator.hasNext()) {
            iterator.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, false);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log.b("Unable to create lock file", "message", fileNotFoundException.getMessage(), fileNotFoundException);
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException iOException) {
            Log.log.b("Unable to create lock", "message", iOException.getMessage(), iOException);
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            Log.log.b("The lock is held elsewhere in this JVM", overlappingFileLockException);
            return false;
        }
        Log.log.a("Able to lock for updates: " + (this._lock != null), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.a("Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException iOException) {
                Log.log.b("Unable to release lock", "message", iOException.getMessage(), iOException);
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException iOException) {
                Log.log.b("Unable to close lock channel", "message", iOException.getMessage(), iOException);
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFile() throws IOException {
        this.downloadControlFile("digest.txt", true);
    }

    /*
     * Loose catch block
     */
    protected void downloadControlFile(String string, boolean bl) throws IOException {
        File file;
        File file2;
        block13: {
            Object object;
            block14: {
                file2 = this.downloadFile(string);
                if (!bl) break block13;
                if (!this._signers.isEmpty()) break block14;
                Log.log.a("No signers, not verifying file", "path", string);
                break block13;
            }
            File file3 = this.downloadFile(string + SIGNATURE_SUFFIX);
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file3);
                object = new FileInputStream(file3);
                object = com.a.a.a.a((InputStream)object, new ByteArrayOutputStream()).toByteArray();
            }
            catch (Throwable throwable) {
                com.a.a.a.a(fileReader);
                file3.delete();
                throw throwable;
            }
            com.a.a.a.a(fileReader);
            file3.delete();
            byte[] byArray = new byte[8192];
            int n2 = 0;
            for (Certificate certificate : this._signers) {
                FileInputStream fileInputStream;
                block12: {
                    int n3;
                    fileInputStream = null;
                    fileInputStream = new FileInputStream(file2);
                    Signature signature = Signature.getInstance("SHA1withRSA");
                    signature.initVerify(certificate);
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        signature.update(byArray, 0, n3);
                    }
                    if (signature.verify(a.a.a.a.a.a.c((byte[])object))) break block12;
                    Log.log.a("Signature does not match", "cert", certificate.getPublicKey());
                    com.a.a.a.a(fileInputStream);
                    continue;
                }
                try {
                    Log.log.a("Signature matches", "cert", certificate.getPublicKey());
                    ++n2;
                }
                catch (IOException iOException) {
                    Log.log.b("Failure validating signature of " + file2 + ": " + iOException, new Object[0]);
                    com.a.a.a.a(fileInputStream);
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    com.a.a.a.a(fileInputStream);
                    continue;
                }
                com.a.a.a.a(fileInputStream);
                continue;
                {
                    catch (Throwable throwable) {
                        com.a.a.a.a(fileInputStream);
                        throw throwable;
                    }
                }
            }
            if (n2 == 0) {
                file2.delete();
                throw new IOException("m.corrupt_digest_signature_error");
            }
        }
        if (!FileUtil.renameTo(file2, file = this.getLocalPath(string))) {
            throw new IOException("Failed to rename(" + file2 + ", " + file + ")");
        }
    }

    protected File downloadFile(String object) throws IOException {
        Object object2;
        File file = this.getLocalPath((String)object + "_new");
        try {
            object2 = this.getRemoteURL((String)object);
        }
        catch (Exception exception) {
            Log.log.b("Requested to download invalid control file", "appbase", this._vappbase, "path", object, "error", exception);
            throw (IOException)new IOException("Invalid path '" + (String)object + "'.").initCause(exception);
        }
        Log.log.a("Attempting to refetch '" + (String)object + "' from '" + object2 + "'.", new Object[0]);
        InputStream inputStream = null;
        object = null;
        try {
            object2 = ConnectionUtil.open((URL)object2);
            ((URLConnection)object2).setUseCaches(false);
            int n2 = SysProps.connectTimeout();
            if (n2 > 0) {
                ((URLConnection)object2).setConnectTimeout(n2 * 1000);
            }
            inputStream = ((URLConnection)object2).getInputStream();
            object = new FileOutputStream(file);
            com.a.a.a.a(inputStream, object);
        }
        catch (Throwable throwable) {
            com.a.a.a.a(inputStream);
            com.a.a.a.a((OutputStream)object);
            throw throwable;
        }
        com.a.a.a.a(inputStream);
        com.a.a.a.a((OutputStream)object);
        return file;
    }

    protected Resource createResource(String string, boolean bl) throws MalformedURLException {
        return new Resource(string, this.getRemoteURL(string), this.getLocalPath(string), bl, this._skipMD5cache);
    }

    protected void parseResources(Map<String, Object> stringArray, String string, boolean bl, List<Resource> list) {
        if ((stringArray = ConfigUtil.getMultiValue(stringArray, string)) == null) {
            return;
        }
        for (String string2 : stringArray) {
            try {
                list.add(this.createResource(string2, bl));
            }
            catch (Exception exception) {
                Log.log.b("Invalid resource '" + string2 + "'. " + exception, new Object[0]);
            }
        }
    }

    protected void parseStringResources(Map<String, Object> stringArray, String string, boolean n2, List<String> list) {
        if ((stringArray = ConfigUtil.getMultiValue(stringArray, string)) == null) {
            return;
        }
        for (String string2 : stringArray) {
            try {
                list.add(string2);
            }
            catch (Exception exception) {
                Log.log.b("Invalid resource '" + string2 + "'. " + exception, new Object[0]);
            }
        }
    }

    protected Rectangle parseRect(Map<String, Object> object, String string, Rectangle rectangle) {
        object = (String)object.get(string);
        if ((object = Application.parseRect(string, (String)object)) == null) {
            return rectangle;
        }
        return object;
    }

    public static List<Integer> intsToList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n2 : nArray) {
            arrayList.add(n2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Rectangle parseRect(String string, String string2) {
        if (!s.a(string2)) {
            int[] nArray = s.d(string2);
            if (nArray != null && nArray.length == 4) {
                return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            Log.log.b("Ignoring invalid '" + string + "' config '" + string2 + "'.", new Object[0]);
        }
        return null;
    }

    protected Color parseColor(Map<String, Object> object, String string, Color color) {
        object = (String)object.get(string);
        if ((object = Application.parseColor((String)object)) == null) {
            return color;
        }
        return object;
    }

    public static Color parseColor(String string) {
        if (!s.a(string)) {
            try {
                return new Color(Integer.parseInt(string, 16));
            }
            catch (NumberFormatException numberFormatException) {
                Log.log.b("Ignoring invalid color", "hexValue", string, "exception", numberFormatException);
            }
        }
        return null;
    }

    protected String[] parseList(Map<String, Object> object, String string) {
        if ((object = (String)object.get(string)) == null) {
            return b.a;
        }
        return s.e((String)object);
    }

    protected String parseUrl(Map<String, Object> map, String string, String string2) {
        String string3 = (String)map.get(string + "." + Locale.getDefault().getLanguage());
        if (!s.a(string3)) {
            return string3;
        }
        string3 = (String)map.get(string);
        if (s.a(string3)) {
            return string2;
        }
        return string3;
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long l2 = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = l2;
        }
        if (this._trackingId == 0) {
            this._trackingId = q.a(100000000, 1000000000);
        }
        StringBuilder stringBuilder = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        stringBuilder.append(".").append(this._trackingId);
        stringBuilder.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        stringBuilder.append(".").append(l2).append(".1%3B%2B");
        stringBuilder.append("__utmz%3D").append(this._trackingGAHash).append(".");
        stringBuilder.append(this._trackingStart).append(".1.1.");
        stringBuilder.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        stringBuilder.append("&utmn=").append(q.a(1000000000, 2000000000));
        return stringBuilder.toString();
    }

    protected String replaceDomain(String object) {
        String string = SysProps.appbaseDomain();
        if (string != null) {
            object = Pattern.compile("(http://[^/]+)(.*)").matcher((CharSequence)object);
            object = ((Matcher)object).replaceAll(string + "$2");
        }
        return object;
    }

    protected static String encodePath(String string) {
        return string.replace(" ", "%20");
    }

    protected static long parseLong(String string, String string2) throws IOException {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            string = com.a.a.a.b(string2, string);
            throw (IOException)new IOException(string).initCause(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String string, List<Resource> list, List<Resource> list2) {
            this.name = string;
            this.codes = Collections.unmodifiableList(list);
            this.rsrcs = Collections.unmodifiableList(list2);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static class UpdateInterface {
        public String name;
        public Color background = Color.white;
        public String[] rotatingBackgrounds;
        public String errorBackground;
        public String[] iconImages;
        public String backgroundImage;
        public String progressImage;
        public Rectangle progress = new Rectangle(5, 5, 300, 15);
        public Color progressText = Color.black;
        public Color progressBar = new Color(0x6699CC);
        public Rectangle status = new Rectangle(5, 25, 500, 100);
        public Color statusText = Color.black;
        public Color textShadow;
        public String installError;
        public Rectangle patchNotes = new Rectangle(5, 50, 112, 26);
        public String patchNotesUrl;
        public Rectangle playAgain;
        public String playAgainImage;
        public boolean hideDecorations;
        public boolean hideProgressText;
        public Map<Step, List<Integer>> stepPercentages = new EnumMap<Step, List<Integer>>(Step.class);

        public UpdateInterface() {
            for (Step step : Step.values()) {
                this.stepPercentages.put(step, step.defaultPercents);
            }
        }

        public String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", pi=" + this.progressImage + ", prect=" + this.progress + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + this.status + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + this.patchNotes + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + this.stepPercentages + ", parect=" + this.playAgain + ", paimage=" + this.playAgainImage + ", hideProgressText" + this.hideProgressText + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Step {
            UPDATE_JAVA(10),
            VERIFY_METADATA(15, 65, 95),
            DOWNLOAD(40),
            PATCH(60),
            VERIFY_RESOURCES(70, 97),
            REDOWNLOAD_RESOURCES(90),
            UNPACK(98),
            LAUNCH(99);

            public final List<Integer> defaultPercents;

            private Step(int ... nArray) {
                this.defaultPercents = Application.intsToList(nArray);
            }
        }
    }
}

