/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public enum ImdbSiteDefinition {
    IMDB_COM("http://www.imdb.com/", "UTF-8", "Tagline", "Genre", "Runtime", "Production Companies", "Writing credits", "Certification", "Release Date", "Produced by");

    private String site;
    private Charset charset;
    private String tagline;
    private String genre;
    private String runtime;
    private String productionCompanies;
    private String writer;
    private String certification;
    private String releaseDate;
    private String producers;

    private ImdbSiteDefinition(String site, String charsetName, String tagline, String genre, String runtime, String productionCompanies, String writers, String certification, String releaseDate, String producers) {
        this.site = site;
        this.charset = StringUtils.isBlank((CharSequence)charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
        this.tagline = tagline;
        this.genre = genre;
        this.runtime = runtime;
        this.productionCompanies = productionCompanies;
        this.writer = writers;
        this.certification = certification;
        this.releaseDate = releaseDate;
        this.producers = producers;
    }

    public String getSite() {
        return this.site;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getTagline() {
        return this.tagline;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getProductionCompanies() {
        return this.productionCompanies;
    }

    public String getWriter() {
        return this.writer;
    }

    public String getCertification() {
        return this.certification;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getProducers() {
        return this.producers;
    }

    public String toString() {
        return this.site;
    }
}

