/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.PluginManager;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class ImdbParser {
    protected static final Pattern IMDB_ID_PATTERN = Pattern.compile("/title/(tt[0-9]{7})/");
    protected final MediaType type;

    protected ImdbParser(MediaType type) {
        this.type = type;
    }

    protected abstract Pattern getUnwantedSearchResultPattern();

    protected abstract Logger getLogger();

    protected abstract ImdbSiteDefinition getImdbSite();

    protected abstract MediaMetadata getMetadata(MediaScrapeOptions var1) throws Exception;

    protected abstract String getSearchCategory();

    protected List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        MediaSearchResult sr;
        Document doc;
        ArrayList<MediaSearchResult> result = new ArrayList<MediaSearchResult>();
        String searchTerm = "";
        if (StringUtils.isNotEmpty((CharSequence)query.getImdbId())) {
            searchTerm = query.getImdbId();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            searchTerm = query.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            return result;
        }
        String language = query.getLanguage().getLanguage();
        int myear = query.getYear();
        String country = query.getCountry().getAlpha2();
        searchTerm = MetadataUtil.removeNonSearchCharacters((String)searchTerm);
        StringBuilder sb = new StringBuilder(this.getImdbSite().getSite());
        sb.append("find?q=");
        try {
            sb.append(URLEncoder.encode(searchTerm, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().debug("Failed to encode search term: " + searchTerm);
            sb.append(searchTerm);
        }
        sb.append(this.getSearchCategory());
        this.getLogger().debug("========= BEGIN IMDB Scraper Search for: " + sb.toString());
        try {
            Url url = new Url(sb.toString());
            url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(language, country));
            doc = Jsoup.parse((InputStream)url.getInputStream(), (String)"UTF-8", (String)"");
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            return result;
        }
        Elements elements = doc.getElementsByAttributeValue("rel", "canonical");
        for (Element element : elements) {
            MediaMetadata md = null;
            String movieName = null;
            String movieId = null;
            String href = element.attr("href");
            Matcher matcher = IMDB_ID_PATTERN.matcher(href);
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                movieId = matcher.group(1);
            }
            if (!StringUtils.isEmpty(movieId)) {
                MediaScrapeOptions options = new MediaScrapeOptions(this.type);
                options.setImdbId(movieId);
                options.setLanguage(query.getLanguage());
                options.setCountry(CountryCode.valueOf((String)country));
                md = this.getMetadata(options);
                if (!StringUtils.isEmpty((CharSequence)md.getTitle())) {
                    movieName = md.getTitle();
                }
            }
            if (!StringUtils.isNotEmpty(movieName) || !StringUtils.isNotEmpty((CharSequence)movieId)) continue;
            sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), query.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(md.getYear());
            sr.setMetadata(md);
            sr.setScore(1.0f);
            String posterUrl = "";
            Elements posters = doc.getElementsByClass("poster");
            if (posters != null && !posters.isEmpty()) {
                Elements imgs = ((Element)posters.get(0)).getElementsByTag("img");
                for (Element img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "UX200_");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "UY200_");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)posterUrl)) {
                sr.setPosterUrl(posterUrl);
            }
            result.add(sr);
            return result;
        }
        elements = doc.getElementsByClass("findResult");
        for (Element tr : elements) {
            if (!"tr".equalsIgnoreCase(tr.tagName())) continue;
            String movieName = "";
            String movieId = "";
            int year = 0;
            Elements tds = tr.getElementsByClass("result_text");
            block10: for (Element element : tds) {
                Matcher matcher;
                Pattern unwantedSearchResultPattern;
                if (!"td".equalsIgnoreCase(element.tagName()) || (unwantedSearchResultPattern = this.getUnwantedSearchResultPattern()) != null && (matcher = unwantedSearchResultPattern.matcher(element.text())).find()) continue;
                String localizedName = "";
                Elements italics = element.getElementsByTag("i");
                if (italics.size() > 0) {
                    localizedName = italics.text().replace("\"", "");
                }
                Elements anchors = element.getElementsByTag("a");
                for (Element a : anchors) {
                    if (!StringUtils.isNotEmpty((CharSequence)a.text())) continue;
                    movieName = StringUtils.isNotBlank((CharSequence)localizedName) && !language.equals("en") ? localizedName : a.text();
                    String href = a.attr("href");
                    Matcher matcher2 = IMDB_ID_PATTERN.matcher(href);
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        movieId = matcher2.group(1);
                    }
                    Pattern yearPattern = Pattern.compile("\\(([0-9]{4})|/\\)");
                    matcher2 = yearPattern.matcher(element.text());
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        try {
                            year = Integer.parseInt(matcher2.group(1));
                            continue block10;
                        }
                        catch (Exception ignored) {
                        }
                    }
                    continue block10;
                }
            }
            String posterUrl = "";
            tds = tr.getElementsByClass("primary_photo");
            for (Element element : tds) {
                Elements imgs = element.getElementsByTag("img");
                for (Element img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "UX200_");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "UY200_");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isEmpty((CharSequence)movieName) || StringUtils.isEmpty((CharSequence)movieId)) continue;
            sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), query.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(year);
            sr.setPosterUrl(posterUrl);
            if (movieId.equals(query.getImdbId())) {
                sr.setScore(1.0f);
            } else {
                float score = MetadataUtil.calculateScore((String)searchTerm, (String)movieName);
                if (posterUrl.isEmpty() || posterUrl.contains("nopicture")) {
                    this.getLogger().debug("no poster - downgrading score by 0.01");
                    score -= 0.01f;
                }
                if (this.yearDiffers(myear, year)) {
                    float diff = (float)Math.abs(year - myear) / 100.0f;
                    this.getLogger().debug("parsed year does not match search result year - downgrading score by " + diff);
                    score -= diff;
                }
                sr.setScore(score);
            }
            result.add(sr);
            if (result.size() < 40) continue;
            break;
        }
        Collections.sort(result);
        Collections.reverse(result);
        return result;
    }

    protected static String getAcceptLanguage(String language, String country) {
        Locale jreLocale;
        String combined;
        String combined2;
        Locale localeFromLanguage;
        ArrayList<String> languageString = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)language) && StringUtils.isNotBlank((CharSequence)country) && LocaleUtils.isAvailableLocale((Locale)new Locale(language, country))) {
            String combined3 = language + "-" + country;
            languageString.add(combined3.toLowerCase(Locale.ROOT));
        }
        if ((localeFromLanguage = UrlUtil.getLocaleFromLanguage((String)language)) != null && !languageString.contains(combined2 = language + "-" + localeFromLanguage.getCountry().toLowerCase(Locale.ROOT))) {
            languageString.add(combined2);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            languageString.add(language.toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains(combined = ((jreLocale = Locale.getDefault()).getLanguage() + "-" + jreLocale.getCountry()).toLowerCase(Locale.ROOT))) {
            languageString.add(combined);
        }
        if (!languageString.contains(jreLocale.getLanguage().toLowerCase(Locale.ROOT))) {
            languageString.add(jreLocale.getLanguage().toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains("en-us")) {
            languageString.add("en-us");
        }
        if (!languageString.contains("en")) {
            languageString.add("en");
        }
        StringBuilder languages = new StringBuilder();
        float qualifier = 1.0f;
        for (String line : languageString) {
            if (languages.length() > 0) {
                languages.append(",");
            }
            languages.append(line);
            if (qualifier < 1.0f) {
                languages.append(String.format(Locale.US, ";q=%1.1f", Float.valueOf(qualifier)));
            }
            qualifier = (float)((double)qualifier - 0.1);
        }
        return languages.toString().toLowerCase(Locale.ROOT);
    }

    protected MediaMetadata parseCombinedPage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        Element content;
        MediaCastMember cm;
        Elements a;
        Elements elements;
        Element ratingElement;
        Element poster;
        Element title = doc.getElementById("tn15title");
        if (title != null) {
            String content2;
            Element element;
            Elements elements2 = title.getElementsByTag("h1");
            if (elements2.size() > 0) {
                element = elements2.first();
                String movieTitle = ImdbMetadataProvider.cleanString(element.ownText());
                md.setTitle(movieTitle);
            }
            if ((elements2 = title.getElementsByTag("span")).size() > 0) {
                element = elements2.first();
                content2 = element.text();
                Pattern yearPattern = Pattern.compile("\\(([0-9]{4})|/\\)");
                Matcher matcher = yearPattern.matcher(content2);
                while (matcher.find()) {
                    if (matcher.group(1) == null) continue;
                    String movieYear = matcher.group(1);
                    try {
                        md.setYear(Integer.parseInt(movieYear));
                        break;
                    }
                    catch (Exception ignored) {
                    }
                }
            }
            if ((elements2 = title.getElementsByAttributeValue("class", "title-extra")).size() > 0) {
                element = elements2.first();
                content2 = element.ownText().trim();
                content2 = ImdbMetadataProvider.cleanString(StringUtils.removeEnd((String)StringUtils.removeStart((String)content2, (String)","), (String)","));
                md.setOriginalTitle(content2);
            }
        }
        if ((poster = doc.getElementById("primary-poster")) != null) {
            String posterUrl = poster.attr("src");
            posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "UX600_");
            posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "UY600_");
            ImdbMetadataProvider.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, posterUrl);
        }
        if ((ratingElement = doc.getElementById("tn15rating")) != null) {
            Elements a2;
            elements = ratingElement.getElementsByClass("starbar-meta");
            if (elements.size() > 0) {
                Elements a3;
                Element div = (Element)elements.get(0);
                Elements b = div.getElementsByTag("b");
                if (b.size() == 1) {
                    String ratingAsString = b.text();
                    Pattern ratingPattern = Pattern.compile("([0-9]\\.[0-9])/10");
                    Matcher matcher = ratingPattern.matcher(ratingAsString);
                    while (matcher.find()) {
                        if (matcher.group(1) == null) continue;
                        float rating = 0.0f;
                        try {
                            rating = Float.valueOf(matcher.group(1)).floatValue();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        md.setRating(rating);
                        break;
                    }
                }
                if ((a3 = div.getElementsByAttributeValue("href", "ratings")).size() == 1) {
                    String countAsString = a3.text().replaceAll("[.,]|votes", "").trim();
                    int voteCount = 0;
                    try {
                        voteCount = Integer.parseInt(countAsString);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    md.setVoteCount(voteCount);
                }
            }
            if ((elements = ratingElement.getElementsByClass("starbar-special")).size() > 0 && (a2 = ((Element)elements.get(0)).getElementsByTag("a")).size() > 0) {
                Element anchor = (Element)a2.get(0);
                Pattern topPattern = Pattern.compile("Top 250: #([0-9]{1,3})");
                Matcher matcher = topPattern.matcher(anchor.ownText());
                while (matcher.find()) {
                    if (matcher.group(1) == null) continue;
                    try {
                        md.setTop250(Integer.parseInt(matcher.group(1)));
                    }
                    catch (Exception ignored) {}
                }
            }
        }
        elements = doc.getElementsByClass("info");
        for (Element element : elements) {
            if (!"div".equals(element.tag().getName())) continue;
            Elements h5 = element.getElementsByTag("h5");
            if (h5.size() > 0) {
                Element taglineElement;
                Matcher matcher;
                Pattern pattern;
                Elements div;
                Element firstH5 = h5.first();
                String h5Title = firstH5.text();
                if (h5Title.matches("(?i)" + ImdbSiteDefinition.IMDB_COM.getReleaseDate() + ".*") && (div = element.getElementsByClass("info-content")).size() > 0) {
                    Element releaseDateElement = div.first();
                    String releaseDate = ImdbMetadataProvider.cleanString(releaseDateElement.ownText().replaceAll("\u00bb", ""));
                    pattern = Pattern.compile("(.*)\\(.*\\)");
                    matcher = pattern.matcher(releaseDate);
                    if (matcher.find()) {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("d MMMM yyyy", Locale.US);
                            Date parsedDate = sdf.parse(matcher.group(1));
                            md.setReleaseDate(parsedDate);
                        }
                        catch (ParseException otherformat) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy", Locale.US);
                                Date parsedDate = sdf.parse(matcher.group(1));
                                md.setReleaseDate(parsedDate);
                            }
                            catch (ParseException ignored) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (h5Title.matches("(?i)" + ImdbSiteDefinition.IMDB_COM.getTagline() + ".*") && !ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdb").booleanValue() && (div = element.getElementsByClass("info-content")).size() > 0) {
                    taglineElement = div.first();
                    String tagline = ImdbMetadataProvider.cleanString(taglineElement.ownText().replaceAll("\u00bb", ""));
                    md.setTagline(tagline);
                }
                if (h5Title.matches("(?i)" + this.getImdbSite().getGenre() + "(.*)") && (div = element.getElementsByClass("info-content")).size() > 0) {
                    Elements a4 = div.first().getElementsByTag("a");
                    for (Element anchor : a4) {
                        if (!anchor.attr("href").matches("/Sections/Genres/.*")) continue;
                        md.addGenre(ImdbMetadataProvider.getTmmGenre(anchor.ownText()));
                    }
                }
                if (h5Title.matches("(?i)" + ImdbSiteDefinition.IMDB_COM.getRuntime() + ".*") && (div = element.getElementsByClass("info-content")).size() > 0) {
                    int runtime;
                    block55: {
                        taglineElement = div.first();
                        String first = taglineElement.ownText().split("\\|")[0];
                        String runtimeAsString = ImdbMetadataProvider.cleanString(first.replaceAll("min", ""));
                        runtime = 0;
                        try {
                            runtime = Integer.parseInt(runtimeAsString);
                        }
                        catch (Exception e) {
                            Pattern runtimePattern = Pattern.compile("([0-9]{2,3})");
                            Matcher matcher2 = runtimePattern.matcher(runtimeAsString);
                            if (!matcher2.find()) break block55;
                            runtime = Integer.parseInt(matcher2.group(0));
                        }
                    }
                    md.setRuntime(runtime);
                }
                if (h5Title.matches("(?i)Country.*")) {
                    Elements a5 = element.getElementsByTag("a");
                    for (Element anchor : a5) {
                        pattern = Pattern.compile("/country/(.*)");
                        matcher = pattern.matcher(anchor.attr("href"));
                        if (!matcher.matches()) continue;
                        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                            md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((String)options.getLanguage().getLanguage(), (String[])new String[]{anchor.text(), matcher.group(1)}));
                            continue;
                        }
                        md.addCountry(matcher.group(1));
                    }
                }
                if (h5Title.matches("(?i)Language.*")) {
                    Elements a6 = element.getElementsByTag("a");
                    for (Element anchor : a6) {
                        pattern = Pattern.compile("/language/(.*)");
                        matcher = pattern.matcher(anchor.attr("href"));
                        if (!matcher.matches()) continue;
                        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                            md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString((Locale)options.getLanguage(), (String[])new String[]{anchor.text(), matcher.group(1)}));
                            continue;
                        }
                        md.addSpokenLanguage(matcher.group(1));
                    }
                }
                if (h5Title.matches("(?i)" + ImdbSiteDefinition.IMDB_COM.getCertification() + ".*")) {
                    Elements a7 = element.getElementsByTag("a");
                    for (Element anchor : a7) {
                        if (!anchor.attr("href").matches("(?i)/search/title\\?certificates=" + options.getCountry().getAlpha2() + ".*")) continue;
                        Pattern certificationPattern = Pattern.compile(".*:(.*)");
                        matcher = certificationPattern.matcher(anchor.ownText());
                        Certification certification = null;
                        while (matcher.find()) {
                            if (matcher.group(1) == null) continue;
                            certification = Certification.getCertification((CountryCode)options.getCountry(), (String)matcher.group(1));
                        }
                        if (certification == null) continue;
                        md.addCertification(certification);
                        break;
                    }
                }
            }
            if (!"director-info".equals(element.id())) continue;
            a = element.getElementsByTag("a");
            for (Element anchor : a) {
                if (!anchor.attr("href").matches("/name/nm.*")) continue;
                cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                cm.setName(anchor.ownText());
                md.addCastMember(cm);
            }
        }
        elements = doc.getElementsByClass("cast");
        if (elements.size() > 0) {
            Elements tr = ((Element)elements.get(0)).getElementsByTag("tr");
            for (Element row : tr) {
                MediaCastMember cm2 = this.parseCastMember(row);
                if (!StringUtils.isNotEmpty((CharSequence)cm2.getName()) || !StringUtils.isNotEmpty((CharSequence)cm2.getCharacter())) continue;
                cm2.setType(MediaCastMember.CastType.ACTOR);
                md.addCastMember(cm2);
            }
        }
        if ((content = doc.getElementById("tn15content")) != null) {
            elements = content.getElementsByTag("table");
            for (Element table : elements) {
                if (table.text().contains(ImdbSiteDefinition.IMDB_COM.getWriter())) {
                    Elements anchors = table.getElementsByTag("a");
                    for (Element anchor : anchors) {
                        if (!anchor.attr("href").matches("/name/nm.*")) continue;
                        cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                        cm.setName(anchor.ownText());
                        md.addCastMember(cm);
                    }
                }
                if (!table.text().contains(ImdbSiteDefinition.IMDB_COM.getProducers())) continue;
                Elements rows = table.getElementsByTag("tr");
                for (Element row : rows) {
                    Elements columns;
                    if (row.text().contains(ImdbSiteDefinition.IMDB_COM.getProducers()) || (columns = row.children()).size() == 0) continue;
                    MediaCastMember cm3 = new MediaCastMember(MediaCastMember.CastType.PRODUCER);
                    String name = ImdbMetadataProvider.cleanString(((Element)columns.get(0)).text());
                    if (StringUtils.isBlank((CharSequence)name)) continue;
                    cm3.setName(name);
                    if (columns.size() >= 3) {
                        cm3.setPart(ImdbMetadataProvider.cleanString(((Element)columns.get(2)).text()));
                    }
                    md.addCastMember(cm3);
                }
            }
        }
        elements = doc.getElementsByClass("blackcatheader");
        for (Element blackcatheader : elements) {
            if (!blackcatheader.ownText().equals(ImdbSiteDefinition.IMDB_COM.getProductionCompanies())) continue;
            a = blackcatheader.nextElementSibling().getElementsByTag("a");
            for (Element anchor : a) {
                md.addProductionCompany(anchor.ownText());
            }
        }
        return md;
    }

    protected MediaMetadata parsePlotsummaryPage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        if (this.getImdbSite() == ImdbSiteDefinition.IMDB_COM) {
            Elements zebraList = doc.getElementsByClass("zebraList");
            if (zebraList != null && !zebraList.isEmpty()) {
                Elements p;
                Elements odd = ((Element)zebraList.get(0)).getElementsByClass("odd");
                if (odd.isEmpty()) {
                    odd = ((Element)zebraList.get(0)).getElementsByClass("even");
                }
                if (odd.size() > 0 && (p = ((Element)odd.get(0)).getElementsByTag("p")).size() > 0) {
                    String plot = ImdbMetadataProvider.cleanString(((Element)p.get(0)).text());
                    md.setPlot(plot);
                }
            }
        } else {
            Element wiki = doc.getElementById("swiki.2.1");
            if (wiki != null) {
                String plot = ImdbMetadataProvider.cleanString(wiki.ownText());
                md.setPlot(plot);
            }
        }
        return md;
    }

    protected MediaCastMember parseCastMember(Element row) {
        Elements td = row.getElementsByTag("td");
        MediaCastMember cm = new MediaCastMember();
        for (Element column : td) {
            Elements img;
            if (column.hasClass("hs") && (img = column.getElementsByTag("img")).size() > 0) {
                String thumbUrl = ((Element)img.get(0)).attr("src");
                if (thumbUrl.contains("no_photo.png")) {
                    cm.setImageUrl("");
                } else {
                    thumbUrl = thumbUrl.replaceAll("SX[0-9]{2,4}_", "SX400_");
                    thumbUrl = thumbUrl.replaceAll("SY[0-9]{2,4}_", "");
                    cm.setImageUrl(thumbUrl);
                }
            }
            if (column.hasClass("nm")) {
                cm.setName(ImdbMetadataProvider.cleanString(column.text()));
            }
            if (!column.hasClass("char")) continue;
            try {
                String characterName = ImdbMetadataProvider.cleanString(column.text());
                characterName = characterName.replaceAll("\\(.*?\\)$", "").trim();
                cm.setCharacter(characterName);
            }
            catch (Exception ignored) {}
        }
        return cm;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }

    static class TmdbWorker
    implements Callable<MediaMetadata> {
        private String imdbId;
        private Locale language;
        private CountryCode certificationCountry;

        public TmdbWorker(String imdbId, Locale language, CountryCode certificationCountry) {
            this.imdbId = imdbId;
            this.language = language;
            this.certificationCountry = certificationCountry;
        }

        @Override
        public MediaMetadata call() throws Exception {
            try {
                IMovieMetadataProvider tmdb = null;
                List providers = PluginManager.getInstance().getPluginsForInterface(IMovieMetadataProvider.class);
                for (IMovieMetadataProvider provider : providers) {
                    if (!"tmdb".equals(provider.getProviderInfo().getId())) continue;
                    tmdb = provider;
                    break;
                }
                if (tmdb == null) {
                    return null;
                }
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                options.setLanguage(this.language);
                options.setCountry(this.certificationCountry);
                options.setImdbId(this.imdbId);
                return tmdb.getMetadata(options);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    protected class ImdbWorker
    implements Callable<Document> {
        private String url;
        private String language;
        private String country;
        private ImdbSiteDefinition imdbSite;
        private Document doc = null;

        public ImdbWorker(String url, String language, String country, ImdbSiteDefinition imdbSite) {
            this.url = url;
            this.language = language;
            this.country = country;
            this.imdbSite = imdbSite;
        }

        @Override
        public Document call() throws Exception {
            this.doc = null;
            try {
                Url url = new Url(this.url);
                url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(this.language, this.country));
                this.doc = Jsoup.parse((InputStream)url.getInputStream(), (String)this.imdbSite.getCharset().displayName(), (String)"");
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page " + this.url, (Throwable)e);
            }
            return this.doc;
        }
    }
}

