/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class LanguageUtils {
    public static final LinkedHashMap<String, Locale> KEY_TO_LOCALE_MAP;
    public static final LinkedHashMap<String, Locale> KEY_TO_COUNTRY_LOCALE_MAP;
    private static final Map<Locale, String> ISO_639_2B_EXCEPTIONS;

    private static Map<Locale, String> createIso6392BExceptions() {
        HashMap<Locale, String> exceptions = new HashMap<Locale, String>();
        exceptions.put(Locale.forLanguageTag("sq"), "alb");
        exceptions.put(Locale.forLanguageTag("hy"), "arm");
        exceptions.put(Locale.forLanguageTag("eu"), "baq");
        exceptions.put(Locale.forLanguageTag("my"), "bur");
        exceptions.put(Locale.forLanguageTag("zh"), "chi");
        exceptions.put(Locale.forLanguageTag("cs"), "cze");
        exceptions.put(Locale.forLanguageTag("nl"), "dut");
        exceptions.put(Locale.forLanguageTag("fr"), "fre");
        exceptions.put(Locale.forLanguageTag("de"), "ger");
        exceptions.put(Locale.forLanguageTag("ka"), "geo");
        exceptions.put(Locale.forLanguageTag("el"), "gre");
        exceptions.put(Locale.forLanguageTag("is"), "ice");
        exceptions.put(Locale.forLanguageTag("mk"), "mac");
        exceptions.put(Locale.forLanguageTag("mi"), "mao");
        exceptions.put(Locale.forLanguageTag("ms"), "may");
        exceptions.put(Locale.forLanguageTag("fa"), "per");
        exceptions.put(Locale.forLanguageTag("ro"), "rum");
        exceptions.put(Locale.forLanguageTag("sk"), "slo");
        exceptions.put(Locale.forLanguageTag("bo"), "tib");
        exceptions.put(Locale.forLanguageTag("cy"), "wel");
        return exceptions;
    }

    private static LinkedHashMap<String, Locale> generateLanguageArray() {
        HashMap<String, Locale> langArray = new HashMap<String, Locale>();
        LinkedHashMap<String, Locale> sortedMap = new LinkedHashMap<String, Locale>();
        Locale intl = Locale.ENGLISH;
        for (String langu : Locale.getISOLanguages()) {
            Locale base = new Locale(langu);
            langArray.put(base.getDisplayLanguage(intl), base);
            langArray.put(base.getDisplayLanguage(), base);
            try {
                langArray.put(base.getDisplayLanguage(intl).substring(0, 3), base);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            langArray.put(base.getISO3Language(), base);
            langArray.put(LanguageUtils.getISO3BLanguage(base), base);
            langArray.put(langu, base);
        }
        LinkedList keys = new LinkedList(langArray.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        });
        for (String key : keys) {
            if (key.isEmpty()) continue;
            sortedMap.put(key.toLowerCase(Locale.ROOT), (Locale)langArray.get(key));
        }
        return sortedMap;
    }

    private static LinkedHashMap<String, Locale> generateCountryArray() {
        HashMap<String, Locale> langArray = new HashMap<String, Locale>();
        LinkedHashMap<String, Locale> sortedMap = new LinkedHashMap<String, Locale>();
        Locale intl = Locale.ENGLISH;
        for (String cc : Locale.getISOCountries()) {
            Locale l = new Locale("", cc);
            langArray.put(l.getDisplayCountry(intl), l);
            langArray.put(l.getDisplayCountry(), l);
            langArray.put(l.getCountry().toLowerCase(Locale.ROOT), l);
            langArray.put(l.getISO3Country().toLowerCase(Locale.ROOT), l);
        }
        LinkedList keys = new LinkedList(langArray.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        });
        for (String key : keys) {
            if (key.isEmpty()) continue;
            sortedMap.put(key.toLowerCase(Locale.ROOT), (Locale)langArray.get(key));
        }
        return sortedMap;
    }

    public static String getISO3BLanguage(Locale locale) {
        if (ISO_639_2B_EXCEPTIONS.containsKey(locale)) {
            return ISO_639_2B_EXCEPTIONS.get(locale);
        }
        return locale.getISO3Language();
    }

    public static String getISO3BLanguage(String language) {
        return LanguageUtils.getISO3BLanguage(Locale.forLanguageTag(language));
    }

    public static String getIso3LanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l != null) {
            return l.getISO3Language();
        }
        return "";
    }

    public static String getIso3BLanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l != null) {
            return LanguageUtils.getISO3BLanguage(l);
        }
        return "";
    }

    public static String getIso2LanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l != null) {
            return l.getLanguage();
        }
        return "";
    }

    public static String getEnglishLanguageNameFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l != null) {
            return l.getDisplayLanguage(Locale.ENGLISH);
        }
        return "";
    }

    public static String getLocalizedLanguageNameFromLocalizedString(String text) {
        return LanguageUtils.getLocalizedLanguageNameFromLocalizedString(Locale.getDefault(), text);
    }

    public static String getLocalizedLanguageNameFromLocalizedString(Locale language, String ... text) {
        String s;
        Locale l;
        String ret = "";
        if (language == null) {
            language = Locale.getDefault();
        }
        String[] arr$ = text;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((l = KEY_TO_LOCALE_MAP.get((s = arr$[i$]).toLowerCase(Locale.ROOT))) == null || (ret = l.getDisplayLanguage(language)).isEmpty()); ++i$) {
        }
        if (ret.isEmpty() && text.length > 0) {
            ret = text[0];
        }
        return ret;
    }

    public static String getLocalizedCountry(String ... countries) {
        return LanguageUtils.getLocalizedCountryForLanguage(Locale.getDefault().getLanguage(), countries);
    }

    public static String getLocalizedCountryForLanguage(String language, String ... countries) {
        return LanguageUtils.getLocalizedCountryForLanguage(KEY_TO_LOCALE_MAP.get(language.toLowerCase(Locale.ROOT)), countries);
    }

    public static String getLocalizedCountryForLanguage(Locale language, String ... countries) {
        String c;
        Locale l;
        String ret = "";
        if (language == null) {
            language = Locale.getDefault();
        }
        String[] arr$ = countries;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((l = KEY_TO_COUNTRY_LOCALE_MAP.get((c = arr$[i$]).toLowerCase(Locale.ROOT))) == null || (ret = l.getDisplayCountry(language)).isEmpty()); ++i$) {
        }
        if (ret.isEmpty() && countries.length > 0) {
            ret = countries[0];
        }
        return ret;
    }

    static {
        ISO_639_2B_EXCEPTIONS = LanguageUtils.createIso6392BExceptions();
        KEY_TO_LOCALE_MAP = LanguageUtils.generateLanguageArray();
        KEY_TO_COUNTRY_LOCALE_MAP = LanguageUtils.generateCountryArray();
    }
}

