/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.Headers;
import org.apache.commons.io.IOUtils;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.Pair;

public class CachedUrl
extends Url {
    private static final CacheMap<String, CachedRequest> CACHE = new CacheMap(60L, 5L);

    public CachedUrl(String url) throws MalformedURLException {
        this.url = url;
        try {
            this.uri = this.morphStringToUri(url);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, InterruptedException {
        CachedRequest cachedRequest = CACHE.get(this.url);
        if (cachedRequest == null) {
            Url url = new Url(this.url);
            url.headersRequest = this.headersRequest;
            InputStream is = url.getInputStream();
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
            IOUtils.copy((InputStream)is, (OutputStream)gzip);
            IOUtils.closeQuietly((OutputStream)gzip);
            IOUtils.closeQuietly((OutputStream)outputStream);
            cachedRequest = new CachedRequest(url, outputStream.toByteArray());
            if (url.responseCode >= 200 && url.responseCode < 300) {
                CACHE.put(this.url, cachedRequest);
            }
        }
        this.responseCode = cachedRequest.responseCode;
        this.responseMessage = cachedRequest.responseMessage;
        this.responseCharset = cachedRequest.responseCharset;
        this.responseContentType = cachedRequest.responseContentType;
        this.responseContentLength = cachedRequest.responseContentLength;
        this.headersResponse = cachedRequest.headersResponse;
        this.headersRequest.addAll(cachedRequest.headersRequest);
        return new GZIPInputStream(new ByteArrayInputStream(cachedRequest.content));
    }

    public static void clearCache() {
        CACHE.cleanup(true);
    }

    public static boolean isCached(String url) {
        return CACHE.get(url) != null;
    }

    public boolean isCached() {
        return CachedUrl.isCached(this.url);
    }

    private static class CachedRequest {
        byte[] content;
        int responseCode = 0;
        String responseMessage = "";
        Charset responseCharset = null;
        String responseContentType = "";
        long responseContentLength = -1L;
        Headers headersResponse = null;
        List<Pair<String, String>> headersRequest = new ArrayList<Pair<String, String>>();

        CachedRequest(Url url, byte[] content) {
            this.content = content;
            this.responseCode = url.responseCode;
            this.responseMessage = url.responseMessage;
            this.responseCharset = url.responseCharset;
            this.responseContentType = url.responseContentType;
            this.responseContentLength = url.responseContentLength;
            this.headersResponse = url.headersResponse;
            this.headersRequest.addAll(url.headersRequest);
        }
    }
}

