/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.Option;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.registry.PluginClassMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluginMetaInformation;

public class PluginRegistry {
    private final Map<Plugin, PluginMetaInformation> pluginMetaInformation = new ConcurrentHashMap<Plugin, PluginMetaInformation>();
    private final Map<Class<? extends Plugin>, PluginClassMetaInformation> pluginClassMetaInformation = new ConcurrentHashMap<Class<? extends Plugin>, PluginClassMetaInformation>();

    public Collection<Plugin> getAllPlugins() {
        return this.pluginMetaInformation.keySet();
    }

    public PluginMetaInformation getMetaInformationFor(Plugin plugin) {
        return this.pluginMetaInformation.get(plugin);
    }

    public PluginClassMetaInformation getMetaInformationFor(Class<? extends Plugin> clazz) {
        return this.pluginClassMetaInformation.get(clazz);
    }

    public void clear() {
        this.pluginClassMetaInformation.clear();
        this.pluginMetaInformation.clear();
    }

    public void registerPlugin(Plugin plugin, PluginMetaInformation metaInformation) {
        this.pluginMetaInformation.put(plugin, metaInformation);
    }

    public void registerPluginClass(Class<? extends Plugin> c, PluginClassMetaInformation metaInformation) {
        this.pluginClassMetaInformation.put(c, metaInformation);
    }

    public Collection<Class<? extends Plugin>> getPluginClassesWithStatus(PluginClassMetaInformation.PluginClassStatus status) {
        ArrayList<Class<? extends Plugin>> rval = new ArrayList<Class<? extends Plugin>>();
        Set<Class<? extends Plugin>> keySet = this.pluginClassMetaInformation.keySet();
        for (Class<? extends Plugin> class1 : keySet) {
            PluginClassMetaInformation metaInformation = this.pluginClassMetaInformation.get(class1);
            if (metaInformation.pluginClassStatus != status) continue;
            rval.add(class1);
        }
        return rval;
    }

    public void report() {
        System.out.println();
        System.out.println(">>> Class Report <<<");
        Set<Class<? extends Plugin>> keySet = this.pluginClassMetaInformation.keySet();
        for (Class<? extends Plugin> class1 : keySet) {
            PluginClassMetaInformation meta = this.pluginClassMetaInformation.get(class1);
            System.out.print("    " + class1.getCanonicalName() + " (status:'" + (Object)((Object)meta.pluginClassStatus));
            System.out.print("'; dependencies:'" + CoreKeeper.$(meta.dependencies).map(new F1<PluginClassMetaInformation.Dependency, String>(){

                @Override
                public String f(PluginClassMetaInformation.Dependency x) {
                    return x.pluginClass.getSimpleName();
                }
            }, new Option[0]).string().join(","));
            System.out.print("'; origin:'" + meta.pluginOrigin + "';)");
            System.out.println();
        }
        System.out.println();
        System.out.println(">>> Object Report <<<");
        Set<Plugin> keySet2 = this.pluginMetaInformation.keySet();
        for (Plugin plugin : keySet2) {
            PluginMetaInformation meta = this.pluginMetaInformation.get(plugin);
            System.out.println("    " + plugin + " (status:'" + (Object)((Object)meta.pluginStatus) + "')");
        }
        System.out.println();
    }
}

