/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores.adapter;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import net.jcores.jre.cores.adapter.AbstractAdapter;

public class CollectionAdapter<I, O>
extends AbstractAdapter<O>
implements List<O> {
    private static final long serialVersionUID = 7010286694628298017L;
    Iterator<I> iterator;
    AtomicReferenceArray<O> array;
    AtomicInteger inCache;
    ReentrantLock collectionLock;
    final int start;
    final int end;

    public CollectionAdapter(Collection<I> collection) {
        this.inCache = new AtomicInteger(-1);
        this.collectionLock = new ReentrantLock();
        this.iterator = collection.iterator();
        this.array = new AtomicReferenceArray(collection.size());
        this.start = 0;
        this.end = collection.size() - 1;
    }

    private CollectionAdapter(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    protected O converter(I i) {
        return (O)i;
    }

    @Override
    public int size() {
        return this.end - this.start + 1;
    }

    @Override
    public O get(int n) {
        int n2 = n + this.start;
        this.cacheUntil(n2);
        return this._get(n2);
    }

    private final O _get(int n) {
        return this.array.get(n);
    }

    @Override
    public ListIterator<O> iterator() {
        return new ListIterator<O>(){
            volatile int i = 0;

            @Override
            public boolean hasNext() {
                return CollectionAdapter.this.start + this.i <= CollectionAdapter.this.end;
            }

            @Override
            public O next() {
                CollectionAdapter.this.cacheUntil(CollectionAdapter.this.start + this.i);
                return CollectionAdapter.this.get(this.i++);
            }

            @Override
            public boolean hasPrevious() {
                return this.i > CollectionAdapter.this.start;
            }

            @Override
            public O previous() {
                --this.i;
                return CollectionAdapter.this.get(CollectionAdapter.this.start + this.i);
            }

            @Override
            public int nextIndex() {
                return CollectionAdapter.this.start + this.i;
            }

            @Override
            public int previousIndex() {
                return CollectionAdapter.this.start + this.i - 1;
            }

            @Override
            public void remove() {
            }

            @Override
            public void set(O o) {
            }

            @Override
            public void add(O o) {
            }
        };
    }

    @Override
    public <N> N[] array(Class<N> clazz) {
        this.cacheAll();
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.size());
        for (int i = this.start; i < objectArray.length; ++i) {
            objectArray[i] = this._get(i);
        }
        return objectArray;
    }

    @Override
    public List<O> unsafelist() {
        return this;
    }

    @Override
    public List<O> slice(int n, int n2) {
        CollectionAdapter<I, O> collectionAdapter = new CollectionAdapter<I, O>(this.start + n, this.start + n + (n2 - n) - 1);
        collectionAdapter.array = this.array;
        collectionAdapter.collectionLock = this.collectionLock;
        collectionAdapter.inCache = this.inCache;
        collectionAdapter.iterator = this.iterator;
        return collectionAdapter;
    }

    protected void cacheAll() {
        this.cacheUntil(this.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheUntil(int n) {
        if (this.inCache.intValue() >= n) {
            return;
        }
        this.collectionLock.lock();
        try {
            if (this.iterator == null) {
                return;
            }
            while (this.iterator.hasNext()) {
                int n2 = this.inCache.get();
                this.array.set(n2 + 1, this.converter(this.iterator.next()));
                this.inCache.set(n2 + 1);
                if (n2 <= n) continue;
                break;
            }
            if (!this.iterator.hasNext()) {
                this.iterator = null;
            }
        }
        finally {
            this.collectionLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.end - this.start < 0;
    }

    @Override
    public boolean contains(Object object) {
        for (Object e : this) {
            if (e == null || !e.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        this.cacheAll();
        Object[] objectArray = (Object[])Array.newInstance(Object.class, this.size());
        for (int i = this.start; i < objectArray.length; ++i) {
            objectArray[i] = this._get(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.cacheAll();
        Object[] objectArray = null;
        objectArray = TArray.length >= this.array.length() ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size());
        for (int i = this.start; i < objectArray.length; ++i) {
            objectArray[i] = this._get(i);
        }
        return objectArray;
    }

    @Override
    public boolean add(O o) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends O> collection) {
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends O> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public O set(int n, O o) {
        return null;
    }

    @Override
    public void add(int n, O o) {
    }

    @Override
    public O remove(int n) {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int n = iterator.nextIndex();
            Object e = iterator.next();
            if (e == null || !e.equals(object)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        this.cacheAll();
        for (int i = this.end; i >= this.start; --i) {
            O o = this.get(i);
            if (o == null || !o.equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<O> listIterator() {
        return this.iterator();
    }

    @Override
    public ListIterator<O> listIterator(int n) {
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public List<O> subList(int n, int n2) {
        return this.slice(n, n2);
    }
}

