/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores.adapter;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.jcores.jre.cores.adapter.AbstractAdapter;

public final class ArrayAdapter<T>
extends AbstractAdapter<T> {
    private static final long serialVersionUID = 8808538840410854684L;
    final T[] array;
    final int size;

    public ArrayAdapter(T ... TArray) {
        this(TArray == null ? 0 : TArray.length, TArray);
    }

    public ArrayAdapter(int n, T ... TArray) {
        this.array = TArray;
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int n) {
        return this.array[n];
    }

    @Override
    public ListIterator<T> iterator() {
        return new ListIterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArrayAdapter.this.size;
            }

            @Override
            public T next() {
                return ArrayAdapter.this.array[this.i++];
            }

            @Override
            public boolean hasPrevious() {
                return this.i - 1 >= 0;
            }

            @Override
            public T previous() {
                --this.i;
                return ArrayAdapter.this.array[this.i--];
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public void remove() {
            }

            @Override
            public void set(T t) {
            }

            @Override
            public void add(T t) {
            }
        };
    }

    @Override
    public Class<?> clazz() {
        return this.array.getClass().getComponentType();
    }

    @Override
    public <N> N[] array(Class<N> clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
        if (this.array != null) {
            return Arrays.copyOf(this.array, this.size, objectArray.getClass());
        }
        return objectArray;
    }

    @Override
    public T[] array() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public T[] unsafearray() {
        return this.array;
    }

    @Override
    public List<T> unsafelist() {
        return Arrays.asList(this.array).subList(0, this.size);
    }

    @Override
    public List<T> slice(int n, int n2) {
        return Arrays.asList(Arrays.copyOfRange(this.array, n, n2));
    }
}

