/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.cores.CoreByteBuffer;
import net.jcores.jre.cores.CoreCSV;
import net.jcores.jre.cores.CoreFile;
import net.jcores.jre.cores.CoreNumber;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.CoreURI;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.interfaces.functions.F1Object2Bool;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.options.RegEx;
import net.jcores.jre.utils.CSVLine;
import net.jcores.jre.utils.internal.Streams;
import net.jcores.jre.utils.internal.Strings;
import net.jcores.jre.utils.map.Compound;

public class CoreString
extends CoreObject<String> {
    private static final long serialVersionUID = -2412531498060577117L;

    public CoreString(CommonCore commonCore, String ... stringArray) {
        super(commonCore, stringArray);
    }

    public CoreString(CommonCore commonCore, List<String> list) {
        super(commonCore, list);
    }

    public CoreString(CommonCore commonCore, AbstractAdapter<String> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    public CoreByteBuffer bytes() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<String, ByteBuffer>(){

            @Override
            public ByteBuffer f(String string) {
                try {
                    byte[] byArray = string.getBytes("UTF-8");
                    return ByteBuffer.wrap(byArray);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public boolean containssubstr(String string) {
        for (String string2 : this) {
            if (string2 == null || !string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public CoreCSV csv() {
        return this.csv(",");
    }

    public CoreCSV csv(final String string) {
        return new CoreCSV(this.commonCore, this.split("\n").map(new F1<String, CSVLine>(){

            @Override
            public CSVLine f(String string2) {
                return new CSVLine((String[])CoreKeeper.$((String[])string2.split((String)string)).trim().adapter.array());
            }
        }, new Option[0]).array(CSVLine.class));
    }

    public double d(int n) {
        if (this.get(n) == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble((String)this.adapter.get(n));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public Double D(int n) {
        if (this.get(n) == null) {
            return null;
        }
        try {
            return Double.valueOf((String)this.get(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CoreString decode() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                try {
                    return URLDecoder.decode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString encode() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                try {
                    return URLEncoder.encode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString exec(Option ... optionArray) {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command(Strings.parseExec(string));
                try {
                    Process process = processBuilder.start();
                    process.waitFor();
                    return Streams.readText(CoreString.this.commonCore, process.getInputStream());
                }
                catch (IOException iOException) {
                    CoreString.this.commonCore.report(MessageType.EXCEPTION, "Error invoking " + string);
                }
                catch (InterruptedException interruptedException) {
                    CoreString.this.commonCore.report(MessageType.EXCEPTION, "Error waiting for " + string);
                }
                return null;
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString exec(final String string, Option ... optionArray) {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string3) {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                String string2 = string3.replaceAll("^(.*)$", string);
                processBuilder.command(Strings.parseExec(string2));
                try {
                    Process process = processBuilder.start();
                    process.waitFor();
                    return Streams.readText(CoreString.this.commonCore, process.getInputStream());
                }
                catch (IOException iOException) {
                    CoreString.this.commonCore.report(MessageType.EXCEPTION, "Error invoking " + string3);
                }
                catch (InterruptedException interruptedException) {
                    CoreString.this.commonCore.report(MessageType.EXCEPTION, "Error waiting for " + string3);
                }
                return null;
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreFile file() {
        return new CoreFile(this.commonCore, this.map(new F1<String, File>(){

            @Override
            public File f(String string) {
                return new File(string);
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString filter(String string, Option ... optionArray) {
        final Pattern pattern = Pattern.compile(string);
        return new CoreString(this.commonCore, this.filter(new F1Object2Bool<String>(){

            @Override
            public boolean f(String string) {
                Matcher matcher = pattern.matcher(string);
                return matcher.matches();
            }
        }, (Option[])optionArray).adapter);
    }

    public Map<String, String> hashmap(final String ... stringArray) {
        final ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        this.map(new F1<String, Void>(){

            @Override
            public Void f(String string) {
                String[] stringArray5;
                if (stringArray.length > 0) {
                    stringArray5 = stringArray;
                } else {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = ":=";
                    stringArray2[1] = "=";
                    stringArray5 = stringArray2;
                    stringArray2[2] = ":";
                }
                String[] stringArray3 = stringArray5;
                Compound compound = CoreKeeper.$("token", "", "dist", "2147483647").compound();
                for (String string2 : stringArray3) {
                    int n = string.indexOf(string2);
                    if (n < 0 || n >= compound.i("dist")) continue;
                    compound.put("dist", n);
                    compound.put("token", string2);
                }
                int n = compound.i("dist");
                if (n < 0) {
                    return null;
                }
                String[] stringArray4 = string.split(compound.s("token"));
                concurrentHashMap.put(stringArray4[0], stringArray4[1]);
                return null;
            }
        }, new Option[0]);
        return concurrentHashMap;
    }

    public int i(int n) {
        if (this.get(n) == null) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.get(n));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Integer I(int n) {
        if (this.get(n) == null) {
            return null;
        }
        try {
            return Integer.valueOf((String)this.get(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String join() {
        return this.join("");
    }

    public String join(String string) {
        if (this.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.get(i);
            if (string2 == null) continue;
            stringBuilder.append(string2);
            if (i >= n - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public CoreString split(final String string) {
        return this.map(new F1<String, List<String>>(){

            @Override
            public List<String> f(String string2) {
                return Arrays.asList(string2.split(string));
            }
        }, new Option[0]).expand(String.class).as(CoreString.class);
    }

    public CoreString pad(final int n, final char c) {
        if (this.size() == 0) {
            return this;
        }
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                if (string.length() >= n) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = n - string.length();
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString pad(int n) {
        return this.pad(n, ' ');
    }

    public CoreString print() {
        if (this.size() == 0) {
            return this;
        }
        for (String string : this) {
            if (string == null) continue;
            System.out.println(string);
        }
        return this;
    }

    public void log() {
        this.log(Level.INFO);
    }

    public void log(final Level level) {
        this.map(new F1<String, Object>(){

            @Override
            public Object f(String string) {
                CoreString.this.commonCore.log(string, level);
                return null;
            }
        }, new Option[0]);
    }

    public CoreString nullempty() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                return string.length() == 0 ? null : string;
            }
        }, new Option[0]).unsafelist());
    }

    public CoreNumber number(final Class<? extends Number> clazz) {
        return new CoreNumber(this.commonCore, this.map(new F1<String, Number>(){

            @Override
            public Number f(String string) {
                try {
                    if (Integer.class.equals((Object)clazz)) {
                        return Integer.valueOf(string);
                    }
                    if (Double.class.equals((Object)clazz)) {
                        return Double.valueOf(string);
                    }
                    if (Long.class.equals((Object)clazz)) {
                        return Long.valueOf(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }, new Option[0]).array(clazz));
    }

    public CoreString replace(String string, final String string2, Option ... optionArray) {
        int n = CoreKeeper.$(optionArray).cast(RegEx.class).get(0, RegEx.OPTIONS(0)).getOptions();
        final Pattern pattern = Pattern.compile(string, n);
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                return pattern.matcher(string).replaceAll(string2);
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString trim() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                return string.trim();
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreString trim(final int n) {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String string) {
                if (string.length() < 2 * n) {
                    return "";
                }
                return string.substring(n, string.length() - n);
            }
        }, (Option[])new Option[0]).adapter);
    }

    public CoreURI uri() {
        return new CoreURI(this.commonCore, this.map(new F1<String, URI>(){

            @Override
            public URI f(String string) {
                try {
                    return new URI(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }, new Option[0]).array(URI.class));
    }
}

