/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.text.DecimalFormat;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.CoreString;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.interfaces.functions.F2ReduceObjects;
import net.jcores.jre.options.Option;

public class CoreNumber
extends CoreObject<Number> {
    private static final long serialVersionUID = -8437925527295825364L;

    public CoreNumber(CommonCore commonCore, Number ... numberArray) {
        super(commonCore, numberArray);
    }

    public CoreNumber(CommonCore commonCore, AbstractAdapter<Number> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    public double average() {
        return this.average(0.0);
    }

    public double average(double d) {
        int n = 0;
        double d2 = 0.0;
        for (Number number : this) {
            if (number == null || Double.isNaN(number.doubleValue())) continue;
            d2 += number.doubleValue();
            ++n;
        }
        if (n == 0) {
            return d;
        }
        return d2 / (double)n;
    }

    public double d(int n) {
        if (this.get(n) == null) {
            return Double.NaN;
        }
        return ((Number)this.adapter.get(n)).doubleValue();
    }

    public double[] ds() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i) == null ? Double.NaN : ((Number)this.get(i)).doubleValue();
        }
        return dArray;
    }

    public int i(int n) {
        if (this.get(n) == null) {
            return 0;
        }
        return ((Number)this.adapter.get(n)).intValue();
    }

    public int[] is() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get(i) == null ? 0 : ((Number)this.get(i)).intValue();
        }
        return nArray;
    }

    public double max() {
        return this.max(0.0);
    }

    public double max(double d) {
        double d2 = this.reduce(new F2ReduceObjects<Number>(){

            @Override
            public Number f(Number number, Number number2) {
                return Math.max(number.doubleValue(), number2.doubleValue());
            }
        }, new Option[0]).get((Number)d).doubleValue();
        return Double.isNaN(d2) ? d : d2;
    }

    public double min() {
        return this.min(0.0);
    }

    public double min(double d) {
        double d2 = this.reduce(new F2ReduceObjects<Number>(){

            @Override
            public Number f(Number number, Number number2) {
                return Math.min(number.doubleValue(), number2.doubleValue());
            }
        }, new Option[0]).get((Number)d).doubleValue();
        return Double.isNaN(d2) ? d : d2;
    }

    @Override
    public CoreObject<Number> reduce(final F2ReduceObjects<Number> f2ReduceObjects, Option ... optionArray) {
        return super.reduce(new F2ReduceObjects<Number>(){

            @Override
            public Number f(Number number, Number number2) {
                if (Double.isNaN(number.doubleValue())) {
                    return number2;
                }
                if (Double.isNaN(number2.doubleValue())) {
                    return number;
                }
                return f2ReduceObjects.f(number, number2);
            }
        }, optionArray);
    }

    public String s(int n) {
        if (this.get(n) == null) {
            return "null";
        }
        return ((Number)this.adapter.get(n)).toString();
    }

    public String s(int n, String string) {
        if (this.get(n) == null) {
            return "null";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(((Number)this.get(n)).doubleValue());
    }

    public double standarddeviation() {
        return Math.sqrt(this.variance());
    }

    public CoreString string(String string) {
        final DecimalFormat decimalFormat = new DecimalFormat(string);
        return this.map(new F1<Number, String>(){

            @Override
            public String f(Number number) {
                return decimalFormat.format(number.doubleValue());
            }
        }, new Option[0]).as(CoreString.class);
    }

    public double sum() {
        int n = this.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = this.get(i);
            if (number == null || Double.isNaN(number.doubleValue())) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public double variance() {
        double d = this.average();
        int n = this.size();
        int n2 = 0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = this.get(i);
            if (number == null || Double.isNaN(number.doubleValue())) continue;
            d2 += (d - number.doubleValue()) * (d - number.doubleValue());
            ++n2;
        }
        if (n2 == 0) {
            return 0.0;
        }
        return d2 / (double)n2;
    }
}

