/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

class TraktMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMovieMetadataProvider.class);
    private final TraktV2 api;

    TraktMovieMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        String searchString = "";
        int year = 0;
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        if (options.getYear() != 0) {
            try {
                year = options.getYear();
            }
            catch (Exception e) {
                year = 0;
            }
        }
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        List searchResults = null;
        String lang = options.getLanguage().getLanguage();
        lang = lang + ",en";
        try {
            Response response = year != 0 ? this.api.search().textQueryMovie(searchString, String.valueOf(year), null, lang, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute() : this.api.search().textQueryMovie(searchString, null, null, lang, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
            searchResults = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("Problem scraping for " + searchString + "; " + e.getMessage());
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult mediaSearchResult = new MediaSearchResult(TraktMetadataProvider.providerInfo.getId(), MediaType.MOVIE);
            mediaSearchResult.setTitle(result.movie.title);
            mediaSearchResult.setYear(result.movie.year);
            mediaSearchResult.setId(result.movie.ids.trakt.toString());
            mediaSearchResult.setIMDBId(result.movie.ids.imdb);
            mediaSearchResult.setScore(MetadataUtil.calculateScore((String)searchString, (String)mediaSearchResult.getTitle()));
            results.add(mediaSearchResult);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata scrape(MediaScrapeOptions options) throws Exception {
        MovieTranslation trans;
        LOGGER.debug("getMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        String id = options.getId(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id) && options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getId("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return md;
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = " + id);
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Movie movie = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                movie = (Movie)this.api.movies().summary(id, Extended.FULL).execute().body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.movies().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.movies().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
            }
        }
        if (movie == null) {
            return md;
        }
        MovieTranslation movieTranslation = trans = translations == null ? null : (MovieTranslation)translations.get(0);
        if (trans != null) {
            md.setTitle(trans.title.isEmpty() ? movie.title : trans.title);
            md.setTagline(trans.tagline.isEmpty() ? movie.tagline : trans.tagline);
            md.setPlot(trans.overview.isEmpty() ? movie.overview : trans.overview);
        } else {
            md.setTitle(movie.title);
            md.setTagline(movie.tagline);
            md.setPlot(movie.overview);
        }
        md.setYear(movie.year);
        md.setRuntime(movie.runtime);
        md.addCertification(Certification.findCertification((String)movie.certification));
        md.setReleaseDate(movie.released.toDate());
        md.setRating(movie.rating);
        md.setVoteCount(movie.votes);
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)movie.ids.trakt);
        if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
            md.setId("tmdb", (Object)movie.ids.tmdb);
        }
        if (StringUtils.isNotBlank((CharSequence)movie.ids.imdb)) {
            md.setId("imdb", (Object)movie.ids.imdb);
        }
        for (String genreAsString : ListUtils.nullSafe((Iterable)movie.genres)) {
            md.addGenre(MediaGenres.getGenre((String)genreAsString));
        }
        if (credits != null) {
            MediaCastMember cm;
            for (CastMember cast : ListUtils.nullSafe((Iterable)credits.cast)) {
                cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                cm.setName(cast.person.name);
                cm.setCharacter(cast.character);
                md.addCastMember(cm);
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.directing)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.production)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.PRODUCER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.writing)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.costumeAndMakeUp)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.sound)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.camera)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.art)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
            }
        }
        return md;
    }
}

