/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.panels.MediaFilesPanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowMediaInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1610264727610254912L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMediaInformationPanel.class);
    private TvShowSelectionModel selectionModel;
    private LinkLabel lblTvShowPath;
    private JLabel lblDateAddedT;
    private JLabel lblDateAdded;
    private JCheckBox cbWatched;
    private JLabel lblWatchedT;
    private JLabel lblTvShowPathT;
    private EventList<MediaFile> mediaFileEventList;
    private MediaFilesPanel panelMediaFiles;

    public TvShowMediaInformationPanel(TvShowSelectionModel model) {
        this.selectionModel = model;
        this.mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.NARROW_LINE_GAP_ROWSPEC}));
        this.lblDateAddedT = new JLabel(BUNDLE.getString("metatag.dateadded"));
        this.add((Component)this.lblDateAddedT, "2, 2");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "4, 2");
        this.lblWatchedT = new JLabel(BUNDLE.getString("metatag.watched"));
        this.add((Component)this.lblWatchedT, "6, 2");
        this.cbWatched = new JCheckBox("");
        this.cbWatched.setEnabled(false);
        this.add((Component)this.cbWatched, "8, 2");
        this.lblTvShowPathT = new JLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)this.lblTvShowPathT, "2, 4");
        this.lblTvShowPath = new LinkLabel("");
        this.lblTvShowPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!StringUtils.isEmpty((CharSequence)TvShowMediaInformationPanel.this.lblTvShowPath.getNormalText())) {
                    Path path = Paths.get(TvShowMediaInformationPanel.this.lblTvShowPath.getNormalText(), new String[0]);
                    try {
                        if (Files.exists(path, new LinkOption[0])) {
                            TmmUIHelper.openFile(path);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("open filemanager", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            }
        });
        this.lblTvShowPathT.setLabelFor(this.lblTvShowPath);
        this.lblTvShowPathT.setLabelFor(this.lblTvShowPath);
        this.add((Component)this.lblTvShowPath, "4, 4, 5, 1");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){

            @Override
            public MediaEntity getMediaEntity() {
                return TvShowMediaInformationPanel.this.selectionModel.getSelectedTvShow();
            }
        };
        this.add((Component)this.panelMediaFiles, "2, 6, 9, 1, fill, fill");
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == TvShowSelectionModel.class && "selectedTvShow".equals(property) || source.getClass() == TvShow.class && "mediaFiles".equals(property)) {
                    try {
                        TvShowMediaInformationPanel.this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                        TvShowMediaInformationPanel.this.mediaFileEventList.clear();
                        TvShowMediaInformationPanel.this.mediaFileEventList.addAll(TvShowMediaInformationPanel.this.selectionModel.getSelectedTvShow().getMediaFiles());
                    }
                    catch (Exception e) {
                    }
                    finally {
                        TvShowMediaInformationPanel.this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                    }
                    try {
                        TvShowMediaInformationPanel.this.panelMediaFiles.adjustColumns();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.dateAdded.date");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.watched");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.cbWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.dateAdded.day");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.dateAddedAsString");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedTvShow.path");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_13, (Object)this.lblTvShowPath, (Property)jLabelBeanProperty);
        autoBinding_19.bind();
    }
}

