/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowGenresPanel
extends JPanel {
    private static final long serialVersionUID = -7111036144770559630L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowGenresPanel.class);
    private TvShowSelectionModel tvShowSelectionModel;

    public TvShowGenresPanel(TvShowSelectionModel model) {
        this.tvShowSelectionModel = model;
        this.setOpaque(false);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == TvShowSelectionModel.class && "selectedTvShow".equals(property) || source.getClass() == TvShow.class && "genre".equals(property)) {
                    TvShowGenresPanel.this.buildImages();
                }
            }
        };
        this.tvShowSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void buildImages() {
        this.removeAll();
        List<MediaGenres> genres = this.tvShowSelectionModel.getSelectedTvShow().getGenres();
        for (MediaGenres genre : genres) {
            try {
                StringBuilder sb = new StringBuilder("/images/genres/");
                sb.append(genre.name().toLowerCase(Locale.ROOT));
                sb.append(".png");
                ImageIcon image = new ImageIcon(TvShowGenresPanel.class.getResource(sb.toString()));
                JLabel lblImage = new JLabel(image);
                this.add(lblImage);
            }
            catch (NullPointerException e) {
                LOGGER.warn("genre image for genre " + genre.name() + " not available");
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
        if (genres.isEmpty()) {
            try {
                ImageIcon image = new ImageIcon(TvShowGenresPanel.class.getResource("/images/genres/unknown.png"));
                JLabel lblImage = new JLabel(image);
                this.add(lblImage);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

