/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieSetEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -4446433759280691976L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetEditorDialog.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieList movieList = MovieList.getInstance();
    private MovieSet movieSetToEdit;
    private List<Movie> moviesInSet = ObservableCollections.observableList(new ArrayList());
    private List<Movie> removedMovies = new ArrayList<Movie>();
    private List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    private boolean continueQueue = true;
    private JTextField tfName;
    private JTable tableMovies;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JTextPane tpOverview;
    private JTextField tfTmdbId;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private final Action actionRemoveMovie = new RemoveMovieAction();
    private final Action actionOk = new OkAction();
    private final Action actionCancel = new CancelAction();
    private final Action actionAbort = new AbortAction();
    private final Action actionSearchTmdbId = new SwingAction();

    public MovieSetEditorDialog(MovieSet movieSet, boolean inQueue) {
        super(BUNDLE.getString("movieset.edit"), "movieSetEditor");
        this.setBounds(5, 5, 800, 500);
        this.movieSetToEdit = movieSet;
        try {
            ArrayList<String> enabledScrapers = new ArrayList<String>();
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieArtworkScrapers().contains("tmdb")) {
                enabledScrapers.add("tmdb");
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieArtworkScrapers().contains("fanarttv")) {
                enabledScrapers.add("fanarttv");
            }
            this.artworkScrapers.addAll(this.movieList.getArtworkScrapers(enabledScrapers));
        }
        catch (Exception e2) {
            LOGGER.warn("error getting IMediaArtworkProvider " + e2.getMessage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"300px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"75px:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.NARROW_LINE_GAP_ROWSPEC}));
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), panelContent);
        JLabel lblName = new JLabel(BUNDLE.getString("movieset.title"));
        panelContent.add((Component)lblName, "2, 2, right, default");
        this.tfName = new JTextField();
        panelContent.add((Component)this.tfName, "4, 2, 3, 1, fill, default");
        this.tfName.setColumns(10);
        this.lblPoster = new ImageLabel();
        this.lblPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tmdbId = 0;
                try {
                    tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                HashMap<String, Object> ids = new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds());
                ids.put("tmdb", tmdbId);
                ImageChooserDialog dialog = new ImageChooserDialog(ids, ImageChooserDialog.ImageType.POSTER, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblPoster, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        panelContent.add((Component)this.lblPoster, "8, 2, 1, 9, fill, fill");
        JLabel lblTmdbid = new JLabel(BUNDLE.getString("metatag.tmdb"));
        panelContent.add((Component)lblTmdbid, "2, 4, right, default");
        this.tfTmdbId = new JTextField();
        panelContent.add((Component)this.tfTmdbId, "4, 4, fill, default");
        this.tfTmdbId.setColumns(10);
        JButton btnSearchTmdbId = new JButton("");
        btnSearchTmdbId.setAction(this.actionSearchTmdbId);
        panelContent.add((Component)btnSearchTmdbId, "6, 4, left, default");
        JLabel lblOverview = new JLabel(BUNDLE.getString("metatag.plot"));
        panelContent.add((Component)lblOverview, "2, 6, right, top");
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelContent.add((Component)scrollPaneOverview, "4, 6, 3, 1, fill, fill");
        this.tpOverview = new JTextPane();
        scrollPaneOverview.setViewportView(this.tpOverview);
        JLabel lblMovies = new JLabel(BUNDLE.getString("tmm.movies"));
        panelContent.add((Component)lblMovies, "2, 8, right, top");
        JScrollPane scrollPaneMovies = new JScrollPane();
        panelContent.add((Component)scrollPaneMovies, "4, 8, 3, 9, fill, fill");
        this.tableMovies = new JTable();
        scrollPaneMovies.setViewportView(this.tableMovies);
        JButton btnRemoveMovie = new JButton("");
        btnRemoveMovie.setAction(this.actionRemoveMovie);
        panelContent.add((Component)btnRemoveMovie, "2, 10, right, top");
        this.lblFanart = new ImageLabel();
        this.lblFanart.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tmdbId = 0;
                try {
                    tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                HashMap<String, Object> ids = new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds());
                ids.put("tmdb", tmdbId);
                ImageChooserDialog dialog = new ImageChooserDialog(ids, ImageChooserDialog.ImageType.FANART, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblFanart, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        panelContent.add((Component)this.lblFanart, "8, 12, 1, 5, fill, fill");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50px:grow(2)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"200px:grow(2)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblLogoT = new JLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "2, 2");
        this.lblLogo = new ImageLabel();
        this.lblLogo.setAlternativeText(BUNDLE.getString("image.notfound.logo"));
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this.movieSetToEdit.getIds(), ImageChooserDialog.ImageType.LOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblLogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        JLabel lblClearlogoT = new JLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "4, 2");
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "2, 4, fill, fill");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setAlternativeText(BUNDLE.getString("image.notfound.clearlogo"));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this.movieSetToEdit.getIds(), ImageChooserDialog.ImageType.CLEARLOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearlogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "4, 4, fill, fill");
        JLabel lblClearartT = new JLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "2, 6");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setAlternativeText(BUNDLE.getString("image.notfound.clearart"));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this.movieSetToEdit.getIds(), ImageChooserDialog.ImageType.CLEARART, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearart, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        JLabel lblBannerT = new JLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "4, 6");
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "2, 8, fill, fill");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setAlternativeText(BUNDLE.getString("image.notfound.banner"));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this.movieSetToEdit.getIds(), ImageChooserDialog.ImageType.BANNER, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblBanner, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "4, 8, 3, 1, fill, fill");
        this.lblBanner.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.BANNER));
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        EqualsLayout layout = new EqualsLayout(5);
        buttonPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        JButton btnOk = new JButton(BUNDLE.getString("Button.ok"));
        btnOk.setAction(this.actionOk);
        buttonPane.add(btnOk);
        this.getRootPane().setDefaultButton(btnOk);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setAction(this.actionCancel);
        buttonPane.add(btnCancel);
        if (inQueue) {
            JButton abortButton = new JButton(BUNDLE.getString("Button.abortqueue"));
            buttonPane.add(abortButton);
            abortButton.setAction(this.actionAbort);
        }
        this.tfName.setText(this.movieSetToEdit.getTitle());
        this.tfTmdbId.setText(String.valueOf(this.movieSetToEdit.getTmdbId()));
        this.tpOverview.setText(this.movieSetToEdit.getPlot());
        this.moviesInSet.addAll(this.movieSetToEdit.getMovies());
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(MediaFileType.POSTER))) {
            this.lblPoster.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.POSTER));
        } else {
            this.lblPoster.setImageUrl(this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER));
        }
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(MediaFileType.FANART))) {
            this.lblFanart.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.FANART));
        } else {
            this.lblFanart.setImageUrl(this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART));
        }
        this.lblLogo.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.initDataBindings();
        this.tableMovies.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        int width = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(" 2000");
        int titleWidth = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(BUNDLE.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((double)width * 1.5));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.year"));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMinWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(85);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.watched"));
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.moviesInSet, (JTable)this.tableMovies);
        BeanProperty movieBeanProperty = BeanProperty.create((String)"title");
        jTableBinding.addColumnBinding((Property)movieBeanProperty).setEditable(false);
        BeanProperty movieBeanProperty_1 = BeanProperty.create((String)"year");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_1).setEditable(false);
        BeanProperty movieBeanProperty_2 = BeanProperty.create((String)"watched");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_2).setEditable(false).setColumnClass(Boolean.class);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void pack() {
    }

    private class SwingAction
    extends AbstractAction {
        private static final long serialVersionUID = -8980803676368394987L;

        public SwingAction() {
            this.putValue("Name", BUNDLE.getString("movieset.tmdb.find"));
            this.putValue("ShortDescription", BUNDLE.getString("movieset.tmdb.desc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                try {
                    List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                    if (sets == null || sets.size() <= 0) break block3;
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                        MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                        if (!Utils.isValidImdbId(movie.getImdbId()) && movie.getTmdbId() <= 0) continue;
                        options.setTmdbId(movie.getTmdbId());
                        options.setImdbId(movie.getImdbId());
                        options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                        options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                        MediaMetadata md = mp.getMetadata(options);
                        if ((Integer)md.getId("tmdbSet") <= 0) continue;
                        MovieSetEditorDialog.this.tfTmdbId.setText(String.valueOf(md.getId("tmdbSet")));
                        break;
                    }
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("movieset.tmdb.error"));
                }
            }
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = 1215596133205394653L;

        public AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.abortqueue"));
            this.putValue("SmallIcon", IconManager.PROCESS_STOP);
            this.putValue("SwingLargeIconKey", IconManager.PROCESS_STOP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.continueQueue = false;
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -6214112833170817002L;

        public CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7322270015667230646L;

        public OkAction() {
            this.putValue("Name", BUNDLE.getString("Button.save"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Movie movie2;
            int i;
            MovieSetEditorDialog.this.movieSetToEdit.setTitle(MovieSetEditorDialog.this.tfName.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setPlot(MovieSetEditorDialog.this.tpOverview.getText());
            if (StringUtils.isNotEmpty((CharSequence)MovieSetEditorDialog.this.lblPoster.getImageUrl()) && !MovieSetEditorDialog.this.lblPoster.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblPoster.getImageUrl(), MediaFileType.POSTER);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieSetEditorDialog.this.lblFanart.getImageUrl()) && !MovieSetEditorDialog.this.lblFanart.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblFanart.getImageUrl(), MediaFileType.FANART);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblLogo.getImageUrl()) && !MovieSetEditorDialog.this.lblLogo.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.LOGO))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblLogo.getImageUrl(), MediaFileType.LOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblClearlogo.getImageUrl()) && !MovieSetEditorDialog.this.lblClearlogo.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARLOGO))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblClearlogo.getImageUrl(), MediaFileType.CLEARLOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblBanner.getImageUrl()) && !MovieSetEditorDialog.this.lblBanner.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.BANNER))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblBanner.getImageUrl(), MediaFileType.BANNER);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblClearart.getImageUrl()) && !MovieSetEditorDialog.this.lblClearart.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARART))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblClearart.getImageUrl(), MediaFileType.CLEARART);
            }
            for (i = MovieSetEditorDialog.this.movieSetToEdit.getMovies().size() - 1; i >= 0; --i) {
                movie2 = MovieSetEditorDialog.this.movieSetToEdit.getMovies().get(i);
                if (MovieSetEditorDialog.this.moviesInSet.contains(movie2)) continue;
                movie2.setMovieSet(null);
                movie2.writeNFO();
                movie2.saveToDb();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie2, true);
            }
            for (i = 0; i < MovieSetEditorDialog.this.moviesInSet.size(); ++i) {
                movie2 = (Movie)MovieSetEditorDialog.this.moviesInSet.get(i);
                movie2.saveToDb();
                movie2.writeNFO();
            }
            for (Movie movie2 : MovieSetEditorDialog.this.removedMovies) {
                movie2.removeFromMovieSet();
                movie2.saveToDb();
                movie2.writeNFO();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie2, true);
            }
            MovieList.getInstance().sortMoviesInMovieSet(MovieSetEditorDialog.this.movieSetToEdit);
            for (Movie movie2 : MovieSetEditorDialog.this.moviesInSet) {
                movie2.writeNFO();
            }
            int tmdbId = 0;
            try {
                tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MovieSetEditorDialog.this.movieSetToEdit.setTmdbId(tmdbId);
            MovieSetEditorDialog.this.movieSetToEdit.saveToDb();
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveMovieAction
    extends AbstractAction {
        private static final long serialVersionUID = 8013039811395731218L;

        public RemoveMovieAction() {
            this.putValue("SwingLargeIconKey", IconManager.LIST_REMOVE);
            this.putValue("ShortDescription", BUNDLE.getString("movieset.movie.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MovieSetEditorDialog.this.moviesInSet.isEmpty()) {
                return;
            }
            int row = MovieSetEditorDialog.this.tableMovies.getSelectedRow();
            if (row > -1) {
                Movie movie = (Movie)MovieSetEditorDialog.this.moviesInSet.get(row);
                MovieSetEditorDialog.this.moviesInSet.remove(row);
                MovieSetEditorDialog.this.removedMovies.add(movie);
            }
        }
    }
}

