/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieExporterDialog
extends TmmDialog {
    private static final long serialVersionUID = 4085262825778794266L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExporterDialog.class);
    private static final String DIALOG_ID = "movieExporter";
    private List<Movie> movies;
    private List<ExportTemplate> templatesFound;
    private JTextField tfExportDir;
    private JList list;
    private JLabel lblTemplateName;
    private JLabel lblUrl;
    private JTextPane tpDescription;
    private JCheckBox chckbxTemplateWithDetail;

    public MovieExporterDialog(List<Movie> moviesToExport) {
        super(BUNDLE.getString("movie.export"), DIALOG_ID);
        this.setBounds(5, 5, 600, 300);
        this.getContentPane().setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"400dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.7);
        this.getContentPane().add((Component)splitPane, "2, 2, fill, fill");
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setLeftComponent(scrollPane);
        this.list = new JList();
        scrollPane.setViewportView(this.list);
        JPanel panelExporterDetails = new JPanel();
        splitPane.setRightComponent(panelExporterDetails);
        panelExporterDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.lblTemplateName = new JLabel("");
        panelExporterDetails.add((Component)this.lblTemplateName, "2, 2, 3, 1");
        this.lblUrl = new JLabel("");
        panelExporterDetails.add((Component)this.lblUrl, "2, 4, 3, 1");
        this.chckbxTemplateWithDetail = new JCheckBox("");
        this.chckbxTemplateWithDetail.setEnabled(false);
        panelExporterDetails.add((Component)this.chckbxTemplateWithDetail, "2, 6");
        JLabel lblDetails = new JLabel(BUNDLE.getString("export.detail"));
        panelExporterDetails.add((Component)lblDetails, "4, 6");
        JScrollPane scrollPaneDescription = new JScrollPane();
        panelExporterDetails.add((Component)scrollPaneDescription, "2, 8, 3, 1, fill, fill");
        this.tpDescription = new JTextPane();
        scrollPaneDescription.setViewportView(this.tpDescription);
        splitPane.setDividerLocation(300);
        JPanel panelDestination = new JPanel();
        this.getContentPane().add((Component)panelDestination, "2, 4, fill, fill");
        panelDestination.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"150dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC}));
        this.tfExportDir = new JTextField(TmmProperties.getInstance().getProperty("movieExporter.path"));
        panelDestination.add((Component)this.tfExportDir, "1, 1, fill, default");
        this.tfExportDir.setColumns(10);
        JButton btnSetDestination = new JButton(BUNDLE.getString("export.setdestination"));
        panelDestination.add((Component)btnSetDestination, "3, 1");
        btnSetDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("export.selectdirectory"), MovieExporterDialog.this.tfExportDir.getText());
                if (file != null) {
                    MovieExporterDialog.this.tfExportDir.setText(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("movieExporter.path", MovieExporterDialog.this.tfExportDir.getText());
                }
            }
        });
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new EqualsLayout(5));
        this.getContentPane().add((Component)panelButtons, "2, 6, fill, fill");
        JButton btnExport = new JButton("Export");
        btnExport.setIcon(IconManager.EXPORT);
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (StringUtils.isBlank((CharSequence)MovieExporterDialog.this.tfExportDir.getText())) {
                    return;
                }
                int index = MovieExporterDialog.this.list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ExportTemplate selectedTemplate = (ExportTemplate)MovieExporterDialog.this.templatesFound.get(index);
                if (selectedTemplate != null) {
                    Path exportPath = Paths.get(MovieExporterDialog.this.tfExportDir.getText(), new String[0]);
                    if (!Files.exists(exportPath, new LinkOption[0])) {
                        JOptionPane.showMessageDialog(MovieExporterDialog.this, BUNDLE.getString("export.foldernotfound"));
                        return;
                    }
                    try {
                        if (!Utils.isFolderEmpty(exportPath)) {
                            String[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                            int decision = JOptionPane.showConfirmDialog(MovieExporterDialog.this, BUNDLE.getString("export.foldernotempty"), "", 0);
                            if (decision == 1) {
                                return;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("could not open folder: " + e.getMessage());
                        return;
                    }
                    try {
                        MovieExporter exporter = new MovieExporter(Paths.get(selectedTemplate.getPath(), new String[0]));
                        exporter.export(MovieExporterDialog.this.movies, exportPath);
                        TmmProperties.getInstance().putProperty("movieExporter.template", selectedTemplate.getName());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error exporting movies: ", (Throwable)e);
                    }
                    MovieExporterDialog.this.setVisible(false);
                }
            }
        });
        panelButtons.add(btnExport);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MovieExporterDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnCancel);
        this.movies = moviesToExport;
        this.templatesFound = MovieExporter.findTemplates(MediaEntityExporter.TemplateType.MOVIE);
        this.initDataBindings();
        String lastTemplateName = TmmProperties.getInstance().getProperty("movieExporter.template");
        if (StringUtils.isNotBlank((CharSequence)lastTemplateName)) {
            this.list.setSelectedValue(lastTemplateName, true);
        }
    }

    protected void initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.templatesFound, (JList)this.list);
        BeanProperty exportTemplateBeanProperty = BeanProperty.create((String)"name");
        jListBinding.setDetailBinding((Property)exportTemplateBeanProperty);
        jListBinding.bind();
        BeanProperty jListBeanProperty = BeanProperty.create((String)"selectedElement.name");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty, (Object)this.lblTemplateName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jListBeanProperty_1 = BeanProperty.create((String)"selectedElement.url");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_1, (Object)this.lblUrl, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty jListBeanProperty_2 = BeanProperty.create((String)"selectedElement.description");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_2, (Object)this.tpDescription, (Property)jTextPaneBeanProperty);
        autoBinding_2.bind();
        BeanProperty jListBeanProperty_3 = BeanProperty.create((String)"selectedElement.detail");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_3, (Object)this.chckbxTemplateWithDetail, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
    }
}

