/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.scraper.MediaScraper;

public class MovieSearchAndScrapeOptions {
    private MovieScraperMetadataConfig scraperMetadataConfig;
    private MediaScraper metadataScraper;
    private List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    private List<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();

    public void loadDefaults() {
        this.scraperMetadataConfig = Globals.settings.getMovieScraperMetadataConfig();
        this.metadataScraper = MovieList.getInstance().getDefaultMediaScraper();
        this.artworkScrapers.addAll(MovieList.getInstance().getDefaultArtworkScrapers());
        this.trailerScrapers.addAll(MovieList.getInstance().getDefaultTrailerScrapers());
    }

    public MovieScraperMetadataConfig getScraperMetadataConfig() {
        return this.scraperMetadataConfig;
    }

    public MediaScraper getMetadataScraper() {
        return this.metadataScraper;
    }

    public List<MediaScraper> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public List<MediaScraper> getTrailerScrapers() {
        return this.trailerScrapers;
    }

    public void setScraperMetadataConfig(MovieScraperMetadataConfig scraperMetadataConfig) {
        this.scraperMetadataConfig = scraperMetadataConfig;
    }

    public void setMetadataScraper(MediaScraper metadataScraper) {
        this.metadataScraper = metadataScraper;
    }

    public void addArtworkScraper(MediaScraper artworkScraper) {
        this.artworkScrapers.add(artworkScraper);
    }

    public void addTrailerScraper(MediaScraper trailerScraper) {
        this.trailerScrapers.add(trailerScraper);
    }
}

