/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.EmptyFileException;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.thirdparty.ImageLoader;

public class ImageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCache.class);
    private static final Path CACHE_DIR = Paths.get("cache/image", new String[0]);

    public static Path getCacheDir() {
        if (!Files.exists(CACHE_DIR, new LinkOption[0])) {
            try {
                Files.createDirectories(CACHE_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Could not create cache dir " + CACHE_DIR + " - " + e.getMessage());
            }
        }
        return CACHE_DIR;
    }

    public static String getMD5(String path) {
        try {
            if (path == null) {
                return null;
            }
            byte[] key = DigestUtils.md5((String)path);
            return new String(Hex.encodeHex((byte[])key));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create cached filename for image: " + path, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static InputStream scaleImage(String imageUrl, int width) throws IOException, InterruptedException {
        Url url = new Url(imageUrl);
        BufferedImage originalImage = null;
        try {
            originalImage = ImageCache.createImage(url.getBytes());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        Point size = new Point();
        size.x = width;
        size.y = size.x * originalImage.getHeight() / originalImage.getWidth();
        BufferedImage scaledImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        originalImage = null;
        ImageWriter imgWrtr = null;
        ImageWriteParam imgWrtrPrm = null;
        if (ImageCache.hasTransparentPixels(scaledImage)) {
            imgWrtr = ImageIO.getImageWritersByFormatName("png").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
        } else {
            BufferedImage rgb = new BufferedImage(scaledImage.getWidth(), scaledImage.getHeight(), 1);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(scaledImage, rgb);
            imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
            imgWrtrPrm.setCompressionMode(2);
            imgWrtrPrm.setCompressionQuality(0.8f);
            scaledImage = rgb;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream output = ImageIO.createImageOutputStream(baos);
        imgWrtr.setOutput(output);
        IIOImage outputImage = new IIOImage(scaledImage, null, null);
        imgWrtr.write(null, outputImage, imgWrtrPrm);
        imgWrtr.dispose();
        scaledImage = null;
        byte[] bytes = baos.toByteArray();
        output.flush();
        output.close();
        baos.close();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream scaleImage(Path file, int width) throws IOException, InterruptedException {
        BufferedImage originalImage = null;
        try {
            originalImage = ImageCache.createImage(file);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        Point size = new Point();
        size.x = width;
        size.y = size.x * originalImage.getHeight() / originalImage.getWidth();
        BufferedImage scaledImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        originalImage = null;
        ImageWriter imgWrtr = null;
        ImageWriteParam imgWrtrPrm = null;
        if (ImageCache.hasTransparentPixels(scaledImage)) {
            imgWrtr = ImageIO.getImageWritersByFormatName("png").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
        } else {
            BufferedImage rgb = new BufferedImage(scaledImage.getWidth(), scaledImage.getHeight(), 1);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(scaledImage, rgb);
            imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
            imgWrtrPrm = imgWrtr.getDefaultWriteParam();
            imgWrtrPrm.setCompressionMode(2);
            imgWrtrPrm.setCompressionQuality(0.8f);
            scaledImage = rgb;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream output = ImageIO.createImageOutputStream(baos);
        imgWrtr.setOutput(output);
        IIOImage outputImage = new IIOImage(scaledImage, null, null);
        imgWrtr.write(null, outputImage, imgWrtrPrm);
        imgWrtr.dispose();
        scaledImage = null;
        byte[] bytes = baos.toByteArray();
        output.flush();
        output.close();
        baos.close();
        return new ByteArrayInputStream(bytes);
    }

    public static Path cacheImage(Path originalFile) throws Exception {
        MediaFile mf = new MediaFile(originalFile);
        Path cachedFile = ImageCache.getCacheDir().resolve(ImageCache.getMD5(originalFile.toString()) + "." + Utils.getExtension(originalFile));
        if (!Files.exists(cachedFile, new LinkOption[0])) {
            if (!Files.exists(originalFile, new LinkOption[0])) {
                throw new FileNotFoundException("unable to cache file: " + originalFile + "; file does not exist");
            }
            if (Files.size(originalFile) == 0L) {
                throw new EmptyFileException(originalFile);
            }
            BufferedImage originalImage = null;
            try {
                originalImage = ImageCache.createImage(originalFile);
            }
            catch (Exception e) {
                throw new Exception("cannot create image - file seems not to be valid? " + originalFile);
            }
            int desiredWidth = originalImage.getWidth();
            switch (mf.getType()) {
                case FANART: {
                    if (originalImage.getWidth() <= 1000) break;
                    desiredWidth = 1000;
                    break;
                }
                case POSTER: {
                    if (originalImage.getHeight() <= 500) break;
                    desiredWidth = 350;
                    break;
                }
                case EXTRAFANART: 
                case THUMB: 
                case BANNER: 
                case GRAPHIC: {
                    desiredWidth = 300;
                    break;
                }
            }
            if ((mf.getFilename().startsWith("movieset-fanart") || mf.getFilename().startsWith("movieset-poster")) && originalImage.getWidth() > 1000) {
                desiredWidth = 1000;
            }
            Point size = ImageCache.calculateSize(desiredWidth, (int)((double)originalImage.getHeight() / 1.5), originalImage.getWidth(), originalImage.getHeight(), true);
            BufferedImage scaledImage = null;
            scaledImage = Globals.settings.getImageCacheType() == CacheType.FAST ? Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[0]) : Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[0]);
            originalImage = null;
            ImageWriter imgWrtr = null;
            ImageWriteParam imgWrtrPrm = null;
            if (ImageCache.hasTransparentPixels(scaledImage)) {
                imgWrtr = ImageIO.getImageWritersByFormatName("png").next();
                imgWrtrPrm = imgWrtr.getDefaultWriteParam();
            } else {
                BufferedImage rgb = new BufferedImage(scaledImage.getWidth(), scaledImage.getHeight(), 1);
                ColorConvertOp xformOp = new ColorConvertOp(null);
                xformOp.filter(scaledImage, rgb);
                imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
                imgWrtrPrm = imgWrtr.getDefaultWriteParam();
                imgWrtrPrm.setCompressionMode(2);
                imgWrtrPrm.setCompressionQuality(0.8f);
                scaledImage = rgb;
            }
            FileImageOutputStream output = new FileImageOutputStream(cachedFile.toFile());
            imgWrtr.setOutput(output);
            IIOImage image = new IIOImage(scaledImage, null, null);
            imgWrtr.write(null, image, imgWrtrPrm);
            imgWrtr.dispose();
            output.flush();
            output.close();
            scaledImage = null;
        }
        if (!Files.exists(cachedFile, new LinkOption[0])) {
            throw new Exception("unable to cache file: " + originalFile);
        }
        return cachedFile;
    }

    private static boolean hasTransparentPixels(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void invalidateCachedImage(Path path) {
        Path cachedFile = ImageCache.getCacheDir().resolve(ImageCache.getMD5(path.toAbsolutePath().toString()) + "." + Utils.getExtension(path));
        if (Files.exists(cachedFile, new LinkOption[0])) {
            Utils.deleteFileSafely(cachedFile);
        }
    }

    public static Path getCachedFile(String url) {
        Path cachedFile;
        if (url == null || url.isEmpty()) {
            return null;
        }
        String ext = UrlUtil.getExtension((String)url);
        if (ext.isEmpty()) {
            ext = "jpg";
        }
        if (Files.exists(cachedFile = ImageCache.getCacheDir().resolve(ImageCache.getMD5(url) + "." + ext), new LinkOption[0])) {
            LOGGER.trace("found cached url :) " + url);
            return cachedFile;
        }
        if (!Globals.settings.isImageCache()) {
            return null;
        }
        try {
            Url u = new Url(url);
            boolean ok = u.download(cachedFile);
            if (ok) {
                LOGGER.trace("cached url successfully :) " + url);
                return cachedFile;
            }
        }
        catch (MalformedURLException e) {
            LOGGER.trace("Problem getting cached file for url " + e.getMessage());
        }
        LOGGER.trace("Problem getting cached file for url " + url);
        return null;
    }

    public static Path getCachedFile(Path path) {
        if (path == null) {
            return null;
        }
        path = path.toAbsolutePath();
        Path cachedFile = ImageCache.getCacheDir().resolve(ImageCache.getMD5(path.toString()) + "." + Utils.getExtension(path));
        if (Files.exists(cachedFile, new LinkOption[0])) {
            LOGGER.trace("found cached file :) " + path);
            return cachedFile;
        }
        if (path.startsWith(CACHE_DIR.toAbsolutePath())) {
            return path;
        }
        if (!Globals.settings.isImageCache()) {
            LOGGER.trace("ImageCache not activated - return original file 1:1");
            return path;
        }
        try {
            Path p = ImageCache.cacheImage(path);
            LOGGER.trace("cached file successfully :) " + p);
            return p;
        }
        catch (EmptyFileException e) {
            LOGGER.warn("failed to cache file (file is empty): " + path);
        }
        catch (FileNotFoundException e) {
            LOGGER.trace(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.warn("problem caching file: " + e.getMessage());
        }
        return path;
    }

    public static boolean isImageCached(Path path) {
        if (!Globals.settings.isImageCache()) {
            return false;
        }
        Path cachedFile = CACHE_DIR.resolve(ImageCache.getMD5(path.toString()) + "." + Utils.getExtension(path));
        return Files.exists(cachedFile, new LinkOption[0]);
    }

    public static void clearImageCacheForMediaEntity(MediaEntity entity) {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(entity.getMediaFiles());
        for (MediaFile mediaFile : mediaFiles) {
            Path file;
            if (!mediaFile.isGraphic() || !Files.exists(file = ImageCache.getCachedFile(mediaFile.getFileAsPath()), new LinkOption[0])) continue;
            Utils.deleteFileSafely(file);
        }
    }

    public static Point calculateSize(int maxWidth, int maxHeight, int originalWidth, int originalHeight, boolean respectFactor) {
        Point size = new Point();
        if (respectFactor) {
            size.y = maxHeight;
            size.x = (int)((double)size.y * (double)originalWidth / (double)originalHeight);
            if (size.x > maxWidth) {
                size.x = maxWidth;
                size.y = (int)((double)size.x * (double)originalHeight / (double)originalWidth);
            }
        } else {
            size.x = maxWidth;
            size.y = maxHeight;
        }
        return size;
    }

    public static BufferedImage createImage(byte[] imageData) throws Exception {
        return ImageCache.createImage(Toolkit.getDefaultToolkit().createImage(imageData));
    }

    public static BufferedImage createImage(Path file) throws Exception {
        return ImageCache.createImage(Toolkit.getDefaultToolkit().createImage(file.toFile().getAbsolutePath()));
    }

    public static BufferedImage createImage(Image img) {
        return ImageLoader.createImage(img);
    }

    public static enum CacheType {
        FAST,
        SMOOTH;

    }
}

