/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.thetvdbapi.tools;

import com.omertron.thetvdbapi.TvDbException;
import com.omertron.thetvdbapi.model.Actor;
import com.omertron.thetvdbapi.model.Banner;
import com.omertron.thetvdbapi.model.BannerListType;
import com.omertron.thetvdbapi.model.BannerType;
import com.omertron.thetvdbapi.model.BannerUpdate;
import com.omertron.thetvdbapi.model.Banners;
import com.omertron.thetvdbapi.model.BaseUpdate;
import com.omertron.thetvdbapi.model.Episode;
import com.omertron.thetvdbapi.model.EpisodeUpdate;
import com.omertron.thetvdbapi.model.Language;
import com.omertron.thetvdbapi.model.Series;
import com.omertron.thetvdbapi.model.SeriesUpdate;
import com.omertron.thetvdbapi.model.TVDBUpdates;
import com.omertron.thetvdbapi.tools.DOMHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TvdbParser {
    private static final Logger LOG = LoggerFactory.getLogger(TvdbParser.class);
    private static final String URL_BANNER = "http://thetvdb.com/banners/";
    private static final String TYPE_BANNER = "banner";
    private static final String TYPE_FANART = "fanart";
    private static final String TYPE_POSTER = "poster";
    private static final String BANNER_PATH = "BannerPath";
    private static final String VIGNETTE_PATH = "VignettePath";
    private static final String THUMBNAIL_PATH = "ThumbnailPath";
    private static final int MAX_EPISODE = 24;
    private static final String ERROR_GET_XML = "Failed to get XML document from URL";
    private static final String ERROR_RETRIEVE_EPISODE_INFO = "Unable to retrieve episode information from TheTVDb, try again later.";
    private static final String ERROR_NOT_ALLOWED_IN_PROLOG = "content is not allowed in prolog";
    private static final int ERROR_MSG_EPISODE = 3;
    private static final int ERROR_MSG_SEASON = 2;
    private static final int ERROR_MSG_SERIES = 1;
    private static final int ERROR_MSG_GROUP_COUNT = 3;
    private static final String SERIES = "Series";
    private static final String TIME = "time";
    private static final String EPISODE = "Episode";
    private static final String BANNER = "Banner";
    private static final String LAST_UPDATED = "lastupdated";
    private static final String OVERVIEW = "Overview";
    private static final String IMDB_ID = "IMDB_ID";
    private static final String FIRST_AIRED = "FirstAired";
    private static final String SERIES_NAME = "SeriesName";
    private static final String RATING = "Rating";
    private static final String LANGUAGE = "Language";

    protected TvdbParser() {
        throw new UnsupportedOperationException();
    }

    public static List<Actor> getActors(String urlString) throws TvDbException {
        Document doc;
        ArrayList<Actor> results = new ArrayList<Actor>();
        try {
            doc = DOMHelper.getEventDocFromUrl(urlString);
            if (doc == null) {
                return results;
            }
        }
        catch (WebServiceException ex) {
            LOG.trace(ERROR_GET_XML, (Throwable)ex);
            return results;
        }
        NodeList nlActor = doc.getElementsByTagName("Actor");
        for (int loop = 0; loop < nlActor.getLength(); ++loop) {
            Node nActor = nlActor.item(loop);
            if (nActor.getNodeType() != 1) continue;
            Element eActor = (Element)nActor;
            Actor actor = new Actor();
            actor.setId(DOMHelper.getValueFromElement(eActor, "id"));
            String image = DOMHelper.getValueFromElement(eActor, "Image");
            if (!image.isEmpty()) {
                actor.setImage(URL_BANNER + image);
            }
            actor.setName(DOMHelper.getValueFromElement(eActor, "Name"));
            actor.setRole(DOMHelper.getValueFromElement(eActor, "Role"));
            actor.setSortOrder(DOMHelper.getValueFromElement(eActor, "SortOrder"));
            results.add(actor);
        }
        Collections.sort(results);
        return results;
    }

    public static List<Episode> getAllEpisodes(String urlString, int season) throws TvDbException {
        ArrayList<Episode> episodeList = new ArrayList<Episode>();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        NodeList nlEpisode = doc.getElementsByTagName(EPISODE);
        for (int loop = 0; loop < nlEpisode.getLength(); ++loop) {
            Element eEpisode;
            Episode episode;
            Node nEpisode = nlEpisode.item(loop);
            if (nEpisode.getNodeType() != 1 || (episode = TvdbParser.parseNextEpisode(eEpisode = (Element)nEpisode)) == null || season != -1 && episode.getSeasonNumber() != season) continue;
            episodeList.add(episode);
        }
        return episodeList;
    }

    public static Banners getBanners(String urlString) throws TvDbException {
        Banners banners = new Banners();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        if (doc != null) {
            NodeList nlBanners = doc.getElementsByTagName(BANNER);
            for (int loop = 0; loop < nlBanners.getLength(); ++loop) {
                Node nBanner = nlBanners.item(loop);
                if (nBanner.getNodeType() != 1) continue;
                Element eBanner = (Element)nBanner;
                Banner banner = TvdbParser.parseNextBanner(eBanner);
                banners.addBanner(banner);
            }
        }
        return banners;
    }

    public static Episode getEpisode(String urlString) throws TvDbException {
        Element eEpisode;
        Node nEpisode;
        Episode episode = new Episode();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        if (doc == null) {
            return new Episode();
        }
        NodeList nlEpisode = doc.getElementsByTagName(EPISODE);
        for (int loop = 0; loop < nlEpisode.getLength() && ((nEpisode = nlEpisode.item(loop)).getNodeType() != 1 || (episode = TvdbParser.parseNextEpisode(eEpisode = (Element)nEpisode)) == null); ++loop) {
        }
        return episode;
    }

    public static List<Series> getSeriesList(String urlString) throws TvDbException {
        ArrayList<Series> seriesList = new ArrayList<Series>();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        if (doc == null) {
            return Collections.emptyList();
        }
        NodeList nlSeries = doc.getElementsByTagName(SERIES);
        for (int loop = 0; loop < nlSeries.getLength(); ++loop) {
            Element eSeries;
            Series series;
            Node nSeries = nlSeries.item(loop);
            if (nSeries.getNodeType() != 1 || (series = TvdbParser.parseNextSeries(eSeries = (Element)nSeries)) == null) continue;
            seriesList.add(series);
        }
        return seriesList;
    }

    public static TVDBUpdates getUpdates(String urlString, int seriesId) throws TvDbException {
        TVDBUpdates updates = new TVDBUpdates();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        if (doc != null) {
            Node root = doc.getChildNodes().item(0);
            ArrayList<SeriesUpdate> seriesUpdates = new ArrayList<SeriesUpdate>();
            ArrayList<EpisodeUpdate> episodeUpdates = new ArrayList<EpisodeUpdate>();
            ArrayList<BannerUpdate> bannerUpdates = new ArrayList<BannerUpdate>();
            NodeList updateNodes = root.getChildNodes();
            block10: for (int i = 0; i < updateNodes.getLength(); ++i) {
                Node updateNode = updateNodes.item(i);
                switch (updateNode.getNodeName()) {
                    case "Series": {
                        SeriesUpdate su = TvdbParser.parseNextSeriesUpdate((Element)updateNode);
                        if (!TvdbParser.isValidUpdate(seriesId, su)) continue block10;
                        seriesUpdates.add(su);
                        continue block10;
                    }
                    case "Episode": {
                        EpisodeUpdate eu = TvdbParser.parseNextEpisodeUpdate((Element)updateNode);
                        if (!TvdbParser.isValidUpdate(seriesId, eu)) continue block10;
                        episodeUpdates.add(eu);
                        continue block10;
                    }
                    case "Banner": {
                        BannerUpdate bu = TvdbParser.parseNextBannerUpdate((Element)updateNode);
                        if (!TvdbParser.isValidUpdate(seriesId, bu)) continue block10;
                        bannerUpdates.add(bu);
                        continue block10;
                    }
                    default: {
                        LOG.warn("Unknown update type '{}'", (Object)updateNode.getNodeName());
                    }
                }
            }
            updates.setTime(DOMHelper.getValueFromElement((Element)root, TIME));
            updates.setSeriesUpdates(seriesUpdates);
            updates.setEpisodeUpdates(episodeUpdates);
            updates.setBannerUpdates(bannerUpdates);
        }
        return updates;
    }

    private static boolean isValidUpdate(int seriesId, BaseUpdate update) {
        return seriesId == 0 || update.getSeriesId() == seriesId;
    }

    public static List<Language> getLanguages(String urlString) throws TvDbException {
        ArrayList<Language> languages = new ArrayList<Language>();
        Document doc = DOMHelper.getEventDocFromUrl(urlString);
        if (doc != null) {
            NodeList nlLanguages = doc.getElementsByTagName(LANGUAGE);
            for (int loop = 0; loop < nlLanguages.getLength(); ++loop) {
                Node nLanguage = nlLanguages.item(loop);
                if (nLanguage.getNodeType() != 1) continue;
                Element eLanguage = (Element)nLanguage;
                languages.add(TvdbParser.parseNextLanguage(eLanguage));
            }
        }
        return languages;
    }

    public static String parseErrorMessage(String errorMessage) {
        StringBuilder response = new StringBuilder();
        Pattern pattern = Pattern.compile(".*?/series/(\\d*?)/default/(\\d*?)/(\\d*?)/.*?");
        Matcher matcher = pattern.matcher(errorMessage);
        if (matcher.find() && matcher.groupCount() == 3) {
            int seriesId = Integer.parseInt(matcher.group(1));
            int seasonId = Integer.parseInt(matcher.group(2));
            int episodeId = Integer.parseInt(matcher.group(3));
            response.append("Series Id: ").append(seriesId);
            response.append(", Season: ").append(seasonId);
            response.append(", Episode: ").append(episodeId);
            response.append(": ");
            if (episodeId == 0) {
                response.append("Episode seems to be a misnamed pilot episode.");
            } else if (episodeId > 24) {
                response.append("Episode number seems to be too large.");
            } else if (seasonId == 0 && episodeId > 1) {
                response.append("This special episode does not exist.");
            } else if (errorMessage.toLowerCase(Locale.ROOT).contains(ERROR_NOT_ALLOWED_IN_PROLOG)) {
                response.append(ERROR_RETRIEVE_EPISODE_INFO);
            } else {
                response.append("Unknown episode error: ").append(errorMessage);
            }
        } else if (errorMessage.toLowerCase(Locale.ROOT).contains(ERROR_NOT_ALLOWED_IN_PROLOG)) {
            response.append(ERROR_RETRIEVE_EPISODE_INFO);
        } else {
            response.append("Episode error: ").append(errorMessage);
        }
        return response.toString();
    }

    private static List<String> parseList(String input, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input, delim);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result;
    }

    private static Banner parseNextBanner(Element eBanner) {
        Banner banner = new Banner();
        String artwork = DOMHelper.getValueFromElement(eBanner, BANNER_PATH);
        if (!artwork.isEmpty()) {
            banner.setUrl(URL_BANNER + artwork);
        }
        if (!(artwork = DOMHelper.getValueFromElement(eBanner, VIGNETTE_PATH)).isEmpty()) {
            banner.setVignette(URL_BANNER + artwork);
        }
        if (!(artwork = DOMHelper.getValueFromElement(eBanner, THUMBNAIL_PATH)).isEmpty()) {
            banner.setThumb(URL_BANNER + artwork);
        }
        banner.setId(DOMHelper.getValueFromElement(eBanner, "id"));
        banner.setBannerType(BannerListType.fromString(DOMHelper.getValueFromElement(eBanner, "BannerType")));
        banner.setBannerType2(BannerType.fromString(DOMHelper.getValueFromElement(eBanner, "BannerType2")));
        banner.setLanguage(DOMHelper.getValueFromElement(eBanner, LANGUAGE));
        banner.setSeason(DOMHelper.getValueFromElement(eBanner, "Season"));
        banner.setColours(DOMHelper.getValueFromElement(eBanner, "Colors"));
        banner.setRating(DOMHelper.getValueFromElement(eBanner, RATING));
        banner.setRatingCount(DOMHelper.getValueFromElement(eBanner, "RatingCount"));
        try {
            banner.setSeriesName(Boolean.parseBoolean(DOMHelper.getValueFromElement(eBanner, SERIES_NAME)));
        }
        catch (WebServiceException ex) {
            LOG.trace("Failed to transform SeriesName to boolean", (Throwable)ex);
            banner.setSeriesName(false);
        }
        return banner;
    }

    private static Episode parseNextEpisode(Element eEpisode) {
        Episode episode = new Episode();
        episode.setId(DOMHelper.getValueFromElement(eEpisode, "id"));
        episode.setCombinedEpisodeNumber(DOMHelper.getValueFromElement(eEpisode, "Combined_episodenumber"));
        episode.setCombinedSeason(DOMHelper.getValueFromElement(eEpisode, "Combined_season"));
        episode.setDvdChapter(DOMHelper.getValueFromElement(eEpisode, "DVD_chapter"));
        episode.setDvdDiscId(DOMHelper.getValueFromElement(eEpisode, "DVD_discid"));
        episode.setDvdEpisodeNumber(DOMHelper.getValueFromElement(eEpisode, "DVD_episodenumber"));
        episode.setDvdSeason(DOMHelper.getValueFromElement(eEpisode, "DVD_season"));
        episode.setDirectors(TvdbParser.parseList(DOMHelper.getValueFromElement(eEpisode, "Director"), "|,"));
        episode.setEpImgFlag(DOMHelper.getValueFromElement(eEpisode, "EpImgFlag"));
        episode.setEpisodeName(DOMHelper.getValueFromElement(eEpisode, "EpisodeName"));
        episode.setEpisodeNumber(TvdbParser.getEpisodeValue(eEpisode, "EpisodeNumber"));
        episode.setFirstAired(DOMHelper.getValueFromElement(eEpisode, FIRST_AIRED));
        episode.setGuestStars(TvdbParser.parseList(DOMHelper.getValueFromElement(eEpisode, "GuestStars"), "|,"));
        episode.setImdbId(DOMHelper.getValueFromElement(eEpisode, IMDB_ID));
        episode.setLanguage(DOMHelper.getValueFromElement(eEpisode, LANGUAGE));
        episode.setOverview(DOMHelper.getValueFromElement(eEpisode, OVERVIEW));
        episode.setProductionCode(DOMHelper.getValueFromElement(eEpisode, "ProductionCode"));
        episode.setRating(DOMHelper.getValueFromElement(eEpisode, RATING));
        episode.setRatingCount(DOMHelper.getValueFromElement(eEpisode, "RatingCount"));
        episode.setSeasonNumber(TvdbParser.getEpisodeValue(eEpisode, "SeasonNumber"));
        episode.setWriters(TvdbParser.parseList(DOMHelper.getValueFromElement(eEpisode, "Writer"), "|,"));
        episode.setAbsoluteNumber(DOMHelper.getValueFromElement(eEpisode, "absolute_number"));
        String filename = DOMHelper.getValueFromElement(eEpisode, "filename");
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            episode.setFilename(URL_BANNER + filename);
        }
        episode.setLastUpdated(DOMHelper.getValueFromElement(eEpisode, LAST_UPDATED));
        episode.setSeasonId(DOMHelper.getValueFromElement(eEpisode, "seasonid"));
        episode.setSeriesId(DOMHelper.getValueFromElement(eEpisode, "seriesid"));
        episode.setAirsAfterSeason(TvdbParser.getEpisodeValue(eEpisode, "airsafter_season"));
        episode.setAirsBeforeEpisode(TvdbParser.getEpisodeValue(eEpisode, "airsbefore_episode"));
        episode.setAirsBeforeSeason(TvdbParser.getEpisodeValue(eEpisode, "airsbefore_season"));
        return episode;
    }

    private static int getEpisodeValue(Element eEpisode, String key) {
        int episodeValue;
        try {
            String value = DOMHelper.getValueFromElement(eEpisode, key);
            episodeValue = NumberUtils.toInt((String)value, (int)0);
        }
        catch (WebServiceException ex) {
            LOG.trace("Failed to read episode value", (Throwable)ex);
            episodeValue = 0;
        }
        return episodeValue;
    }

    private static Series parseNextSeries(Element eSeries) {
        Series series = new Series();
        series.setId(DOMHelper.getValueFromElement(eSeries, "id"));
        series.setActors(TvdbParser.parseList(DOMHelper.getValueFromElement(eSeries, "Actors"), "|,"));
        series.setAirsDayOfWeek(DOMHelper.getValueFromElement(eSeries, "Airs_DayOfWeek"));
        series.setAirsTime(DOMHelper.getValueFromElement(eSeries, "Airs_Time"));
        series.setContentRating(DOMHelper.getValueFromElement(eSeries, "ContentRating"));
        series.setFirstAired(DOMHelper.getValueFromElement(eSeries, FIRST_AIRED));
        series.setGenres(TvdbParser.parseList(DOMHelper.getValueFromElement(eSeries, "Genre"), "|,"));
        series.setImdbId(DOMHelper.getValueFromElement(eSeries, IMDB_ID));
        series.setLanguage(DOMHelper.getValueFromElement(eSeries, "language"));
        series.setNetwork(DOMHelper.getValueFromElement(eSeries, "Network"));
        series.setOverview(DOMHelper.getValueFromElement(eSeries, OVERVIEW));
        series.setRating(DOMHelper.getValueFromElement(eSeries, RATING));
        series.setRatingCount(DOMHelper.getValueFromElement(eSeries, "RatingCount"));
        series.setRuntime(DOMHelper.getValueFromElement(eSeries, "Runtime"));
        series.setSeriesId(DOMHelper.getValueFromElement(eSeries, "SeriesID"));
        series.setSeriesName(DOMHelper.getValueFromElement(eSeries, SERIES_NAME));
        series.setStatus(DOMHelper.getValueFromElement(eSeries, "Status"));
        String artwork = DOMHelper.getValueFromElement(eSeries, TYPE_BANNER);
        if (!artwork.isEmpty()) {
            series.setBanner(URL_BANNER + artwork);
        }
        if (!(artwork = DOMHelper.getValueFromElement(eSeries, TYPE_FANART)).isEmpty()) {
            series.setFanart(URL_BANNER + artwork);
        }
        if (!(artwork = DOMHelper.getValueFromElement(eSeries, TYPE_POSTER)).isEmpty()) {
            series.setPoster(URL_BANNER + artwork);
        }
        series.setLastUpdated(DOMHelper.getValueFromElement(eSeries, LAST_UPDATED));
        series.setZap2ItId(DOMHelper.getValueFromElement(eSeries, "zap2it_id"));
        return series;
    }

    private static SeriesUpdate parseNextSeriesUpdate(Element element) {
        SeriesUpdate seriesUpdate = new SeriesUpdate();
        seriesUpdate.setSeriesId(DOMHelper.getValueFromElement(element, "id"));
        seriesUpdate.setTime(DOMHelper.getValueFromElement(element, TIME));
        return seriesUpdate;
    }

    private static EpisodeUpdate parseNextEpisodeUpdate(Element element) {
        EpisodeUpdate episodeUpdate = new EpisodeUpdate();
        episodeUpdate.setSeriesId(DOMHelper.getValueFromElement(element, "id"));
        episodeUpdate.setEpisodeId(DOMHelper.getValueFromElement(element, SERIES));
        episodeUpdate.setTime(DOMHelper.getValueFromElement(element, TIME));
        return episodeUpdate;
    }

    private static BannerUpdate parseNextBannerUpdate(Element element) {
        BannerUpdate bannerUpdate = new BannerUpdate();
        bannerUpdate.setSeasonNum(DOMHelper.getValueFromElement(element, "SeasonNum"));
        bannerUpdate.setSeriesId(DOMHelper.getValueFromElement(element, SERIES));
        bannerUpdate.setFormat(DOMHelper.getValueFromElement(element, "format"));
        bannerUpdate.setLanguage(DOMHelper.getValueFromElement(element, "language"));
        bannerUpdate.setPath(DOMHelper.getValueFromElement(element, "path"));
        bannerUpdate.setTime(DOMHelper.getValueFromElement(element, TIME));
        bannerUpdate.setType(DOMHelper.getValueFromElement(element, "type"));
        return bannerUpdate;
    }

    private static Language parseNextLanguage(Element element) {
        Language language = new Language();
        language.setName(DOMHelper.getValueFromElement(element, "name"));
        language.setAbbreviation(DOMHelper.getValueFromElement(element, "abbreviation"));
        language.setId(DOMHelper.getValueFromElement(element, "id"));
        return language;
    }
}

