/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds.uberjar.boot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class InitialClassLoader
extends SecureClassLoader {
    private Map index = new HashMap();
    private URL classworldsJarUrl;

    public InitialClassLoader() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL classUrl = this.getClass().getResource("InitialClassLoader.class");
        String urlText = classUrl.toExternalForm();
        int bangLoc = urlText.indexOf("!");
        System.setProperty("classworlds.lib", String.valueOf(urlText.substring(0, bangLoc)) + "!/WORLDS-INF/lib");
        this.classworldsJarUrl = new URL(String.valueOf(urlText.substring(0, bangLoc)) + "!/WORLDS-INF/classworlds.jar");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized Class findClass(String className) throws ClassNotFoundException {
        String classPath = String.valueOf(className.replace('.', '/')) + ".class";
        if (this.index.containsKey(classPath)) {
            return (Class)this.index.get(classPath);
        }
        try {
            JarInputStream in = new JarInputStream(this.classworldsJarUrl.openStream());
            try {
                JarEntry entry = null;
                while ((entry = in.getNextJarEntry()) != null) {
                    if (!entry.getName().equals(classPath)) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        byte[] buffer = new byte[2048];
                        int read = 0;
                        while (in.available() > 0) {
                            read = in.read(buffer, 0, buffer.length);
                            if (read < 0) break;
                            out.write(buffer, 0, read);
                        }
                        buffer = out.toByteArray();
                        Class<?> cls = this.defineClass(className, buffer, 0, buffer.length);
                        this.index.put(className, cls);
                        Class<?> clazz = cls;
                        return clazz;
                    }
                    finally {
                        out.close();
                    }
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassNotFoundException("io error reading stream for: " + className);
        }
        throw new ClassNotFoundException(className);
    }
}

