/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.thetvdbapi.tools;

import com.omertron.thetvdbapi.ApiExceptionType;
import com.omertron.thetvdbapi.TvDbException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.CachedUrl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DOMHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DOMHelper.class);
    private static final String YES = "yes";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_TIME = 250;
    private static final String ERROR_WRITING = "Error writing the document to {}";
    private static final String ERROR_UNABLE_TO_PARSE = "Unable to parse TheTVDb response, please try again later.";
    private static final int HTTP_STATUS_300 = 300;
    private static final int HTTP_STATUS_500 = 500;

    protected DOMHelper() {
        throw new UnsupportedOperationException();
    }

    public static String getValueFromElement(Element element, String tagName) {
        NodeList elementNodeList = element.getElementsByTagName(tagName);
        if (elementNodeList == null) {
            return "";
        }
        Element tagElement = (Element)elementNodeList.item(0);
        if (tagElement == null) {
            return "";
        }
        NodeList tagNodeList = tagElement.getChildNodes();
        if (tagNodeList == null || tagNodeList.getLength() == 0) {
            return "";
        }
        return tagNodeList.item(0).getNodeValue();
    }

    public static synchronized Document getEventDocFromUrl(String url) throws TvDbException {
        Document doc = null;
        String webPage = DOMHelper.getValidWebpage(url);
        if (StringUtils.isBlank((CharSequence)webPage)) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(webPage.getBytes(CHARSET));){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(in);
            doc.getDocumentElement().normalize();
        }
        catch (UnsupportedEncodingException ex) {
            throw new TvDbException(ApiExceptionType.INVALID_URL, "Unable to encode URL", url, (Throwable)ex);
        }
        catch (IOException | ParserConfigurationException | SAXException error) {
            throw new TvDbException(ApiExceptionType.MAPPING_FAILED, ERROR_UNABLE_TO_PARSE, url, (Throwable)error);
        }
        return doc;
    }

    private static String getValidWebpage(String url) throws TvDbException {
        int retryCount = 0;
        boolean valid = false;
        String content = "";
        CachedUrl cachedUrl = null;
        while (!valid && retryCount < 5) {
            ++retryCount;
            try {
                try {
                    cachedUrl = new CachedUrl(url);
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)cachedUrl.getInputStream(), (Writer)writer);
                    content = writer.toString();
                }
                catch (EOFException e) {
                    cachedUrl = new CachedUrl(url);
                    cachedUrl.addHeader("Accept-Encoding", "identity");
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)cachedUrl.getInputStream(), (Writer)writer);
                    content = writer.toString();
                }
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    if (!content.contains("<id>") || content.contains("<id></id>")) {
                        DOMHelper.waiting(retryCount * 250);
                        continue;
                    }
                    valid = true;
                }
            }
            catch (Exception e) {
                throw new TvDbException(ApiExceptionType.UNKNOWN_CAUSE, content, cachedUrl != null ? cachedUrl.getStatusCode() : -1, url, (Throwable)e);
            }
            if (!valid) {
                throw new TvDbException(ApiExceptionType.UNKNOWN_CAUSE, content, cachedUrl != null ? cachedUrl.getStatusCode() : -1, url);
            }
            return content;
        }
        return null;
    }

    public static String convertDocToString(Document doc) throws TransformerException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", YES);
        trans.setOutputProperty("indent", YES);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        return sw.toString();
    }

    public static boolean writeDocumentToFile(Document doc, String localFile) {
        try {
            TransformerFactory transfact = TransformerFactory.newInstance();
            Transformer trans = transfact.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", YES);
            trans.setOutputProperty("indent", YES);
            trans.transform(new DOMSource(doc), new StreamResult(new File(localFile)));
            return true;
        }
        catch (TransformerConfigurationException ex) {
            LOG.warn(ERROR_WRITING, (Object)localFile, (Object)ex);
            return false;
        }
        catch (TransformerException ex) {
            LOG.warn(ERROR_WRITING, (Object)localFile, (Object)ex);
            return false;
        }
    }

    public static void appendChild(Document doc, Element parentElement, String elementName, String elementValue) {
        Element child = doc.createElement(elementName);
        Text text = doc.createTextNode(elementValue);
        child.appendChild(text);
        parentElement.appendChild(child);
    }

    private static void waiting(int milliseconds) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)milliseconds) {
        }
    }
}

