/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.japura.util.i18n.HandlerString;

public class I18nAdapter {
    private static I18nAdapter adapter = new I18nAdapter();
    private Collection<HandlerString> handlers = new ArrayList<HandlerString>();

    public static I18nAdapter getAdapter() {
        return adapter;
    }

    public static void setAdapter(I18nAdapter adapter) {
        if (adapter == null) {
            adapter = new I18nAdapter();
        }
        I18nAdapter.adapter = adapter;
    }

    public void clearHandlers() {
        this.handlers.clear();
    }

    public Collection<HandlerString> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers);
    }

    public void registerHandler(HandlerString handlerString) {
        if (handlerString != null) {
            this.handlers.add(handlerString);
        }
    }

    public String getString(String key) {
        if (key == null) {
            return key;
        }
        for (HandlerString handler : this.handlers) {
            String str = handler.getString(key);
            if (str == null) continue;
            return str;
        }
        return key;
    }
}

