/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieReloadMediaInformationTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieMediaInformationAction
extends AbstractAction {
    private static final long serialVersionUID = 4927466975489852998L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieMediaInformationAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.updatemediainfo"));
        }
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/mediainfo.png")));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/mediainfo.png")));
        this.putValue("ShortDescription", BUNDLE.getString("movie.updatemediainfo"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.size() > 0) {
            MovieReloadMediaInformationTask task = new MovieReloadMediaInformationTask(selectedMovies);
            if (TmmTaskManager.getInstance().addMainTask(task)) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
            }
        }
    }
}

