/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class BugReportDialog
extends TmmDialog {
    private static final long serialVersionUID = 1992385114573899815L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(BugReportDialog.class);
    private static final String DIALOG_ID = "bugReportdialog";

    public BugReportDialog() {
        super(BUNDLE.getString("BugReport"), DIALOG_ID);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.UNRELATED_GAP_ROWSPEC}));
        JTextArea taDescription = new JTextArea();
        taDescription.setOpaque(false);
        taDescription.setWrapStyleWord(true);
        taDescription.setLineWrap(true);
        taDescription.setEditable(false);
        taDescription.setText(BUNDLE.getString("BugReport.description"));
        panelContent.add((Component)taDescription, "2, 2, 6, 1, fill, fill");
        JButton btnSaveLogs = new JButton(BUNDLE.getString("BugReport.createlogs"));
        btnSaveLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String path = TmmProperties.getInstance().getProperty("bugReportdialog.path");
                    Path file = TmmUIHelper.saveFile(BUNDLE.getString("BugReport.savelogs"), path, "tmm_logs.zip", new FileNameExtensionFilter("Zip files", ".zip"));
                    if (Files.exists(file, new LinkOption[0])) {
                        BugReportDialog.this.writeLogsFile(file.toFile());
                        TmmProperties.getInstance().putProperty("bugReportdialog.path", file.toAbsolutePath().toString());
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not write logs.zip: " + ex.getMessage());
                }
            }
        });
        JLabel lblStep1 = new JLabel(BUNDLE.getString("BugReport.step1"));
        panelContent.add((Component)lblStep1, "2, 4, default, top");
        JTextArea taStep1 = new JTextArea();
        taStep1.setText(BUNDLE.getString("BugReport.step1.description"));
        taStep1.setOpaque(false);
        taStep1.setEditable(false);
        panelContent.add((Component)taStep1, "5, 4, fill, fill");
        panelContent.add((Component)btnSaveLogs, "7, 4");
        JButton btnCreateIssue = new JButton(BUNDLE.getString("BugReport.craeteissue"));
        btnCreateIssue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String baseUrl = "https://github.com/tinyMediaManager/tinyMediaManager/issues/new?body=";
                String params = "Version: " + ReleaseInfo.getRealVersion();
                params = params + "\nBuild: " + ReleaseInfo.getRealBuildDate();
                params = params + "\nOS: " + System.getProperty("os.name") + " " + System.getProperty("os.version");
                params = params + "\nJDK: " + System.getProperty("java.version") + " " + System.getProperty("os.arch") + " " + System.getProperty("java.vendor");
                params = params + "\n\n__What is the actual behaviour?__\n\n";
                params = params + "\n\n__What is the expected behaviour?__\n\n";
                params = params + "\n\n__Steps to reproduce:__\n\n";
                params = params + "\n\n__Additional__\nHave you attached the logfile from the day it happened?";
                String url = "";
                try {
                    url = baseUrl + URLEncoder.encode(params, "UTF-8");
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e1) {
                    LOGGER.error("FAQ", (Throwable)e1);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
                }
            }
        });
        JLabel lblStep2 = new JLabel(BUNDLE.getString("BugReport.step2"));
        panelContent.add((Component)lblStep2, "2, 6, default, top");
        JTextArea taStep2 = new JTextArea();
        taStep2.setOpaque(false);
        taStep2.setEditable(false);
        taStep2.setText(BUNDLE.getString("BugReport.step2.description"));
        panelContent.add((Component)taStep2, "5, 6, fill, fill");
        panelContent.add((Component)btnCreateIssue, "7, 6");
        JLabel lblHintIcon = new JLabel(IconManager.HINT);
        panelContent.add((Component)lblHintIcon, "3, 8");
        JLabel lblHint = new JLabel(BUNDLE.getString("BugReport.languagehint"));
        panelContent.add((Component)lblHint, "5, 8");
        JPanel panelButtons = new JPanel();
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.CANCEL);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReportDialog.this.setVisible(false);
            }
        });
        panelButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_ROWSPEC}));
        panelButtons.add((Component)btnClose, "2, 2");
    }

    private void writeLogsFile(File file) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        ZipOutputStream zos = new ZipOutputStream(os);
        File[] logs = new File("logs").listFiles(new FilenameFilter(){
            Pattern logPattern = Pattern.compile("tmm\\.log\\.*");

            @Override
            public boolean accept(File directory, String filename) {
                Matcher matcher = this.logPattern.matcher(filename);
                return matcher.find();
            }
        });
        if (logs != null) {
            for (File logFile : logs) {
                try {
                    FileInputStream in = new FileInputStream(logFile);
                    ZipEntry ze = new ZipEntry(logFile.getName());
                    zos.putNextEntry(ze);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    in.close();
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.warn("unable to attach " + logFile.getName() + ": " + e.getMessage());
                }
            }
        }
        try {
            FileInputStream in = new FileInputStream("launcher.log");
            ZipEntry ze = new ZipEntry("launcher.log");
            zos.putNextEntry(ze);
            IOUtils.copy((InputStream)in, (OutputStream)zos);
            in.close();
            zos.closeEntry();
        }
        catch (Exception e) {
            LOGGER.warn("unable to attach launcher.log: " + e.getMessage());
        }
        try {
            ZipEntry ze = new ZipEntry("config.xml");
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(new File(Settings.getInstance().getSettingsFolder(), "config.xml"));
            IOUtils.copy((InputStream)in, (OutputStream)zos);
            in.close();
            zos.closeEntry();
        }
        catch (Exception e) {
            LOGGER.warn("unable to attach config.xml: " + e.getMessage());
        }
        zos.close();
        os.close();
    }
}

