/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.tinymediamanager.ui.components.ImageLabel;

public class ColumnLayout
implements LayoutManager2 {
    @Override
    public void layoutContainer(Container parent) {
        Component[] components = parent.getComponents();
        if (components.length == 0) {
            return;
        }
        int y = 0;
        int width = parent.getWidth();
        for (Component component : components) {
            Dimension preferredSize = component.getPreferredSize();
            int height = preferredSize.height;
            if (component instanceof ImageLabel) {
                height = (int)(preferredSize.getHeight() * (double)width / preferredSize.getWidth());
            }
            component.setBounds(0, y, width, height);
            y += height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] components = parent.getComponents();
        int width = parent.getWidth();
        int height = 0;
        for (Component component : components) {
            Dimension preferredSize = component.getPreferredSize();
            if (component instanceof ImageLabel) {
                int proportionalHeight = (int)(preferredSize.getHeight() * (double)width / preferredSize.getWidth());
                height += proportionalHeight;
                continue;
            }
            height += preferredSize.height;
        }
        return new Dimension(width, height);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }
}

