/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WrapLabel
extends JLabel {
    public static final Align LEFT = Align.LEFT;
    public static final Align RIGHT = Align.RIGHT;
    public static final Align CENTER = Align.CENTER;
    private Align align = Align.LEFT;
    private int wrapWidth = 0;
    private String text;

    public WrapLabel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WrapLabel.this.wrapText();
            }
        });
    }

    public WrapLabel(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.wrapText();
    }

    private void wrapText() {
        if (this.getFont() == null || this.text == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        StringBuilder tempText = new StringBuilder();
        StringBuilder finalText = new StringBuilder("<html>");
        finalText.append("<STYLE type='text/css'>BODY { text-align: ");
        finalText.append(this.align.name().toLowerCase());
        finalText.append("}</STYLE><BODY>");
        ArrayList<String> words = new ArrayList<String>();
        this.text = this.text.replaceAll("\n", "<BR>");
        String[] split = this.text.split("<BR>");
        for (int i = 0; i < split.length; ++i) {
            if (split[i].length() > 0) {
                String[] split2 = split[i].split("[ \\t\\x0B\\f\\r]+");
                for (int j = 0; j < split2.length; ++j) {
                    if (split2[j].length() <= 0) continue;
                    words.add(split2[j]);
                }
            }
            if (i >= split.length - 1) continue;
            words.add("<BR>");
        }
        for (String word : words) {
            if (word.equals("<BR>")) {
                finalText.append("<BR>");
                tempText.setLength(0);
                continue;
            }
            tempText.append(" ");
            tempText.append(word);
            int tempWidth = SwingUtilities.computeStringWidth(fm, tempText.toString().trim());
            if (this.wrapWidth > 0 && tempWidth > this.wrapWidth) {
                int wordSize = SwingUtilities.computeStringWidth(fm, word);
                if (wordSize >= this.wrapWidth) {
                    finalText.append("...");
                    break;
                }
                finalText.append("<BR>");
                tempText.setLength(0);
                tempText.append(word);
            }
            if (tempText.length() > 0) {
                finalText.append(" ");
            }
            finalText.append(word);
        }
        finalText.append("</BODY></html>");
        super.setText(finalText.toString());
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int width) {
        this.wrapWidth = width;
        this.wrapText();
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
        this.wrapText();
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

