/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.UpnpPlayButton;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -5598009673335010850L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeDetailsPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowEpisodeSelectionModel selectionModel;
    private LinkLabel lblPath;
    private JLabel lblSeason;
    private JLabel lblEpisode;
    private JLabel lblAired;
    private JButton btnPlay;
    private JLabel lblTags;
    private JLabel lblDateAdded;

    public TvShowEpisodeDetailsPanel(TvShowEpisodeSelectionModel model) {
        this.selectionModel = model;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"25px"), ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"55px"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSeasonT = new JLabel(BUNDLE.getString("metatag.season"));
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        this.add((Component)lblSeasonT, "2, 1");
        this.lblSeason = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblSeason, 1.166);
        this.add((Component)this.lblSeason, "4, 1");
        this.btnPlay = new UpnpPlayButton(){

            @Override
            public MediaFile getMediaFile() {
                return TvShowEpisodeDetailsPanel.this.selectionModel.getSelectedTvShowEpisode().getFirstVideoFile();
            }

            @Override
            public MediaEntity getMediaEntity() {
                return TvShowEpisodeDetailsPanel.this.selectionModel.getSelectedTvShowEpisode();
            }
        };
        this.add((Component)this.btnPlay, "6, 1, 1, 4");
        JLabel lblEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        TmmFontHelper.changeFont(lblEpisodeT, 1.166, 1);
        this.add((Component)lblEpisodeT, "2, 2");
        this.lblEpisode = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblEpisode, 1.166);
        this.add((Component)this.lblEpisode, "4, 2");
        JLabel lblAiredT = new JLabel(BUNDLE.getString("metatag.aired"));
        lblAiredT.setFont(lblAiredT.getFont().deriveFont(1));
        this.add((Component)lblAiredT, "2, 4");
        this.lblAired = new JLabel("");
        this.add((Component)this.lblAired, "4, 4");
        JLabel lblTagsT = new JLabel(BUNDLE.getString("metatag.tags"));
        lblTagsT.setFont(lblTagsT.getFont().deriveFont(1));
        this.add((Component)lblTagsT, "2, 6");
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "4, 6");
        JLabel lblDateAddedT = new JLabel(BUNDLE.getString("metatag.dateadded"));
        lblDateAddedT.setFont(lblDateAddedT.getFont().deriveFont(1));
        this.add((Component)lblDateAddedT, "2, 8");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "4, 8");
        JLabel lblPathT = new JLabel(BUNDLE.getString("metatag.path"));
        lblPathT.setFont(lblPathT.getFont().deriveFont(1));
        this.add((Component)lblPathT, "2, 10");
        this.lblPath = new LinkLabel("");
        lblPathT.setLabelFor(this.lblPath);
        this.lblPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!StringUtils.isEmpty((CharSequence)TvShowEpisodeDetailsPanel.this.lblPath.getNormalText())) {
                    Path path = Paths.get(TvShowEpisodeDetailsPanel.this.lblPath.getNormalText(), new String[0]);
                    try {
                        if (Files.exists(path, new LinkOption[0])) {
                            TmmUIHelper.openFile(path);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("open filemanager", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            }
        });
        this.add((Component)this.lblPath, "4, 10, 3, 1");
        this.initDataBindings();
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.path");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblPath, (Property)linkLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.season");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.episode");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblEpisode, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.firstAiredAsString");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.lblAired, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.tagAsString");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShowEpisode.dateAddedAsString");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_5, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
    }
}

