/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.CachedUrl;
import org.tinymediamanager.scraper.mediaprovider.IMediaArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.RingBuffer;
import org.tinymediamanager.scraper.util.Similarity;
import org.tinymediamanager.scraper.util.StrgUtils;

@PluginImplementation
public class AniDBMetadataProvider
implements ITvShowMetadataProvider,
IMediaArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDBMetadataProvider.class);
    private static final String IMAGE_SERVER = "http://img7.anidb.net/pics/anime/";
    private static final RingBuffer<Long> connectionCounter = new RingBuffer(2);
    private static MediaProviderInfo providerInfo = AniDBMetadataProvider.createMediaProviderInfo();
    private HashMap<String, List<AniDBShow>> showsForLookup = new HashMap();

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("anidb", "aniDB", "<html><h3>aniDB</h3><br />AniDB stands for Anime DataBase. AniDB is a non-profit anime database that is open freely to the public.</html>", AniDBMetadataProvider.class.getResource("/anidb_net.png"));
        providerInfo.setVersion(AniDBMetadataProvider.class);
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions mediaScrapeOptions) throws Exception {
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(mediaScrapeOptions);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }

    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        String id = "";
        String langu = options.getLanguage().getLanguage();
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return md;
        }
        Document doc = null;
        try {
            CachedUrl cachedUrl = new CachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id);
            if (!cachedUrl.isCached()) {
                AniDBMetadataProvider.trackConnections();
            }
            doc = Jsoup.parse((InputStream)cachedUrl.getInputStream(), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        }
        catch (Exception e) {
            LOGGER.error("failed to get TV show metadata: " + e.getMessage());
        }
        if (doc == null || doc.children().size() == 0) {
            return md;
        }
        md.setId(providerInfo.getId(), (Object)id);
        Element anime = doc.child(0);
        for (Element e : anime.children()) {
            if ("startdate".equalsIgnoreCase(e.tagName())) {
                try {
                    Date date = StrgUtils.parseDate((String)e.text());
                    md.setReleaseDate(date);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    md.setYear(calendar.get(1));
                }
                catch (ParseException ignored) {
                    // empty catch block
                }
            }
            if ("titles".equalsIgnoreCase(e.tagName())) {
                this.parseTitle(md, langu, e);
            }
            if ("description".equalsIgnoreCase(e.tagName())) {
                md.setPlot(e.text());
            }
            if ("ratings".equalsIgnoreCase(e.tagName())) {
                this.getRating(md, e);
            }
            if ("picture".equalsIgnoreCase(e.tagName())) {
                MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setPreviewUrl(IMAGE_SERVER + e.text());
                ma.setDefaultUrl(IMAGE_SERVER + e.text());
                ma.setLanguage(options.getLanguage().getLanguage());
                md.addMediaArt(ma);
            }
            if (!"characters".equalsIgnoreCase(e.tagName())) continue;
            this.getActors(md, e);
        }
        md.addGenre(MediaGenres.ANIME);
        return md;
    }

    private void getActors(MediaMetadata md, Element e) {
        for (Element character : e.children()) {
            MediaCastMember member = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            for (Element characterInfo : character.children()) {
                if ("name".equalsIgnoreCase(characterInfo.tagName())) {
                    member.setCharacter(characterInfo.text());
                }
                if (!"seiyuu".equalsIgnoreCase(characterInfo.tagName())) continue;
                member.setName(characterInfo.text());
                String image = characterInfo.attr("picture");
                if (!StringUtils.isNotBlank((CharSequence)image)) continue;
                member.setImageUrl(IMAGE_SERVER + image);
            }
            md.addCastMember(member);
        }
    }

    private void getRating(MediaMetadata md, Element e) {
        for (Element rating : e.children()) {
            if (!"temporary".equalsIgnoreCase(rating.tagName())) continue;
            try {
                md.setRating(Float.parseFloat(rating.text()));
                md.setVoteCount(Integer.parseInt(rating.attr("count")));
                break;
            }
            catch (NumberFormatException ignored) {
            }
        }
    }

    private void parseTitle(MediaMetadata md, String langu, Element e) {
        String titleEN = "";
        String titleScraperLangu = "";
        String titleFirst = "";
        for (Element title : e.children()) {
            if (StringUtils.isBlank((CharSequence)titleFirst)) {
                titleFirst = title.text();
            }
            if ("en".equalsIgnoreCase(title.attr("xml:lang"))) {
                titleEN = title.text();
            }
            if (!langu.equalsIgnoreCase(title.attr("xml:lang"))) continue;
            titleScraperLangu = title.text();
        }
        if (StringUtils.isNotBlank((CharSequence)titleScraperLangu)) {
            md.setTitle(titleScraperLangu);
        } else if (StringUtils.isNotBlank((CharSequence)titleEN)) {
            md.setTitle(titleEN);
        } else {
            md.setTitle(titleFirst);
        }
    }

    public MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        String id = "";
        String langu = options.getLanguage().getLanguage();
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return md;
        }
        int seasonNr = -1;
        int episodeNr = -1;
        try {
            seasonNr = Integer.parseInt(options.getId("seasonNr"));
            episodeNr = Integer.parseInt(options.getId("episodeNr"));
        }
        catch (Exception e) {
            LOGGER.warn("error parsing season/episode number");
        }
        if (seasonNr == -1 || episodeNr == -1) {
            return md;
        }
        Document doc = null;
        try {
            CachedUrl url = new CachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id);
            if (!url.isCached()) {
                AniDBMetadataProvider.trackConnections();
            }
            doc = Jsoup.parse((InputStream)url.getInputStream(), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        }
        catch (Exception e) {
            LOGGER.error("failed to get episode metadata: " + e.getMessage());
        }
        if (doc == null || doc.children().size() == 0) {
            return md;
        }
        md.setId(providerInfo.getId(), (Object)id);
        List<Episode> episodes = this.parseEpisodes(doc);
        Episode episode = null;
        for (Episode ep : episodes) {
            if (ep.season != seasonNr || ep.episode != episodeNr) continue;
            episode = ep;
            break;
        }
        if (episode == null) {
            return md;
        }
        String title = episode.titles.get(langu);
        if (StringUtils.isBlank((CharSequence)title)) {
            title = episode.titles.get("en");
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            title = episode.titles.get("x-jat");
        }
        md.setTitle(title);
        md.setPlot(episode.summary);
        md.setRating(episode.rating);
        try {
            md.setReleaseDate(StrgUtils.parseDate((String)episode.airdate));
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        md.setRuntime(episode.runtime);
        md.setId(providerInfo.getId(), (Object)episode.id);
        return md;
    }

    private List<Episode> parseEpisodes(Document doc) {
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        Element anime = doc.child(0);
        Element eps = null;
        for (Element e : anime.children()) {
            if (!"episodes".equalsIgnoreCase(e.tagName())) continue;
            eps = e;
            break;
        }
        if (eps == null) {
            return episodes;
        }
        for (Element e : eps.children()) {
            if (!"episode".equals(e.tagName())) continue;
            Episode episode = new Episode();
            try {
                episode.id = Integer.parseInt(e.attr("id"));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            for (Element episodeInfo : e.children()) {
                if ("epno".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.episode = Integer.parseInt(episodeInfo.text());
                        if ("1".equals(episodeInfo.attr("type"))) {
                            episode.season = 1;
                            continue;
                        }
                        episode.season = 0;
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if ("length".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.runtime = Integer.parseInt(episodeInfo.text());
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if ("airdate".equalsIgnoreCase(episodeInfo.tagName())) {
                    episode.airdate = episodeInfo.text();
                    continue;
                }
                if ("rating".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.rating = Float.parseFloat(episodeInfo.text());
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if ("title".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.titles.put(episodeInfo.attr("xml:lang").toLowerCase(Locale.ROOT), episodeInfo.text());
                    }
                    catch (Exception ignored) {}
                    continue;
                }
                if (!"summary".equalsIgnoreCase(episodeInfo.tagName())) continue;
                episode.summary = episodeInfo.text();
            }
            episodes.add(episode);
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.TV_SHOW) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        Class<AniDBMetadataProvider> clazz = AniDBMetadataProvider.class;
        synchronized (AniDBMetadataProvider.class) {
            if (this.showsForLookup.size() == 0) {
                this.buildTitleHashMap();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
                searchString = options.getQuery();
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                return results;
            }
            ArrayList<Integer> foundIds = new ArrayList<Integer>();
            for (Map.Entry<String, List<AniDBShow>> entry : this.showsForLookup.entrySet()) {
                String title = entry.getKey();
                float score = Similarity.compareStrings((String)title, (String)searchString);
                if (!((double)score > 0.4)) continue;
                for (AniDBShow show : entry.getValue()) {
                    if (foundIds.contains(show.aniDbId)) continue;
                    MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.TV_SHOW);
                    result.setId(String.valueOf(show.aniDbId));
                    result.setTitle(show.title);
                    results.add(result);
                    result.setScore(score);
                    foundIds.add(show.aniDbId);
                }
            }
            Collections.sort(results);
            Collections.reverse(results);
            return results;
        }
    }

    public List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        ArrayList<MediaEpisode> episodes = new ArrayList<MediaEpisode>();
        String id = "";
        String langu = options.getLanguage().getLanguage();
        if (options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return episodes;
        }
        Document doc = null;
        try {
            CachedUrl url = new CachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id);
            if (!url.isCached()) {
                AniDBMetadataProvider.trackConnections();
            }
            doc = Jsoup.parse((InputStream)url.getInputStream(), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        }
        catch (Exception e) {
            LOGGER.error("error getting episode list: " + e.getMessage());
        }
        if (doc == null || doc.children().size() == 0) {
            return episodes;
        }
        for (Episode ep : this.parseEpisodes(doc)) {
            MediaEpisode episode = new MediaEpisode(this.getProviderInfo().getId());
            episode.title = ep.titles.get(langu);
            episode.season = ep.season;
            episode.episode = ep.episode;
            if (StringUtils.isBlank((CharSequence)episode.title)) {
                episode.title = ep.titles.get("en");
            }
            if (StringUtils.isBlank((CharSequence)episode.title)) {
                episode.title = ep.titles.get("x-jat");
            }
            episode.plot = ep.summary;
            episode.rating = ep.rating;
            episode.firstAired = ep.airdate;
            episode.ids.put(providerInfo.getId(), ep.id);
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTitleHashMap() {
        Pattern pattern = Pattern.compile("^(?!#)(\\d+)[|](\\d)[|]([\\w-]+)[|](.+)$");
        Scanner scanner = null;
        try {
            CachedUrl animeList = new CachedUrl("http://anidb.net/api/anime-titles.dat.gz");
            if (!animeList.isCached()) {
                AniDBMetadataProvider.trackConnections();
            }
            scanner = new Scanner(animeList.getInputStream(), "UTF-8");
            while (scanner.hasNextLine()) {
                Matcher matcher = pattern.matcher(scanner.nextLine());
                if (!matcher.matches()) continue;
                AniDBShow show = new AniDBShow();
                show.aniDbId = Integer.parseInt(matcher.group(1));
                show.language = matcher.group(3);
                show.title = matcher.group(4);
                List<AniDBShow> shows = this.showsForLookup.get(show.title);
                if (shows == null) {
                    shows = new ArrayList<AniDBShow>();
                    this.showsForLookup.put(show.title, shows);
                }
                shows.add(show);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("interrupted image download");
        }
        catch (IOException e) {
            LOGGER.error("error getting AniDB index");
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    private static synchronized void trackConnections() {
        Long oldestConnection;
        Long currentTime = System.currentTimeMillis();
        if (connectionCounter.count() == connectionCounter.maxSize() && (oldestConnection = (Long)connectionCounter.getTailItem()) > currentTime - 4000L) {
            LOGGER.debug("connection limit reached, throttling " + connectionCounter);
            try {
                Thread.sleep(5000L - (currentTime - oldestConnection));
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        currentTime = System.currentTimeMillis();
        connectionCounter.add((Object)currentTime);
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws Exception {
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String id = "";
        if (options.getMetadata() != null) {
            id = (String)options.getMetadata().getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return artwork;
        }
        switch (options.getArtworkType()) {
            case ALL: 
            case POSTER: {
                MediaMetadata md;
                try {
                    md = this.getTvShowMetadata(options);
                }
                catch (Exception e) {
                    return artwork;
                }
                artwork.addAll(md.getMediaArt(options.getArtworkType()));
                break;
            }
            default: {
                return artwork;
            }
        }
        return artwork;
    }

    private static class Episode {
        int id = -1;
        int episode = -1;
        int season = -1;
        int runtime = 0;
        String airdate = "";
        float rating = 0.0f;
        String summary = "";
        HashMap<String, String> titles = new HashMap();

        private Episode() {
        }
    }

    private static class AniDBShow {
        int aniDbId;
        String language;
        String title;

        private AniDBShow() {
        }
    }
}

