/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class FileTypesSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 9136097757447080369L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();
    private JPanel panelVideoFiletypes;
    private JTextField tfVideoFiletype;
    private JList listVideoFiletypes;
    private JPanel panelSubtitleFiletypes;
    private JTextField tfSubtitleFiletype;
    private JList listSubtitleFiletypes;
    private JList listSortPrefixes;
    private JTextField tfSortPrefix;
    private JPanel panelAudioFiletypes;
    private JList listAudioFiletypes;
    private JTextField tfAudioFiletype;

    public FileTypesSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:max(200px;min)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(200px;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(200px;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(200px;default)")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"top:default"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"top:default"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.panelVideoFiletypes = new JPanel();
        this.panelVideoFiletypes.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("Settings.videofiletypes"), 4, 2, null, null));
        this.panelVideoFiletypes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JScrollPane scrollPaneVideoFiletypes = new JScrollPane();
        this.panelVideoFiletypes.add((Component)scrollPaneVideoFiletypes, "2, 2, 5, 1, fill, fill");
        this.listVideoFiletypes = new JList();
        scrollPaneVideoFiletypes.setViewportView(this.listVideoFiletypes);
        this.tfVideoFiletype = new JTextField();
        this.panelVideoFiletypes.add((Component)this.tfVideoFiletype, "2, 4, fill, default");
        this.tfVideoFiletype.setColumns(10);
        JButton btnAddVideoFiletype = new JButton(IconManager.LIST_ADD);
        btnAddVideoFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddVideoFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)FileTypesSettingsPanel.this.tfVideoFiletype.getText())) {
                    Globals.settings.addVideoFileTypes(FileTypesSettingsPanel.this.tfVideoFiletype.getText());
                    FileTypesSettingsPanel.this.tfVideoFiletype.setText("");
                }
            }
        });
        this.panelVideoFiletypes.add((Component)btnAddVideoFiletype, "4, 4");
        this.add((Component)this.panelVideoFiletypes, "2, 2, fill, fill");
        JButton btnRemoveVideoFiletype = new JButton(IconManager.LIST_REMOVE);
        btnRemoveVideoFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveVideoFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = FileTypesSettingsPanel.this.listVideoFiletypes.getSelectedIndex();
                if (row != -1) {
                    String prefix = Globals.settings.getVideoFileType().get(row);
                    Globals.settings.removeVideoFileType(prefix);
                }
            }
        });
        this.panelVideoFiletypes.add((Component)btnRemoveVideoFiletype, "6, 4, default, bottom");
        this.panelSubtitleFiletypes = new JPanel();
        this.add((Component)this.panelSubtitleFiletypes, "4, 2, fill, fill");
        this.panelSubtitleFiletypes.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("Settings.extrafiletypes"), 4, 2, null, null));
        this.panelSubtitleFiletypes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JScrollPane scrollPaneSubtitleFiletypes = new JScrollPane();
        this.panelSubtitleFiletypes.add((Component)scrollPaneSubtitleFiletypes, "2, 2, 5, 1, fill, fill");
        this.listSubtitleFiletypes = new JList();
        scrollPaneSubtitleFiletypes.setViewportView(this.listSubtitleFiletypes);
        this.tfSubtitleFiletype = new JTextField();
        this.panelSubtitleFiletypes.add((Component)this.tfSubtitleFiletype, "2, 4, fill, default");
        this.tfSubtitleFiletype.setColumns(10);
        JButton btnAddSubtitleFiletype = new JButton(IconManager.LIST_ADD);
        btnAddSubtitleFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddSubtitleFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)FileTypesSettingsPanel.this.tfSubtitleFiletype.getText())) {
                    Globals.settings.addSubtitleFileTypes(FileTypesSettingsPanel.this.tfSubtitleFiletype.getText());
                    FileTypesSettingsPanel.this.tfSubtitleFiletype.setText("");
                }
            }
        });
        this.panelSubtitleFiletypes.add((Component)btnAddSubtitleFiletype, "4, 4");
        JButton btnRemoveSubtitleFiletype = new JButton(IconManager.LIST_REMOVE);
        btnRemoveSubtitleFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveSubtitleFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = FileTypesSettingsPanel.this.listSubtitleFiletypes.getSelectedIndex();
                if (row != -1) {
                    String prefix = Globals.settings.getSubtitleFileType().get(row);
                    Globals.settings.removeSubtitleFileType(prefix);
                }
            }
        });
        this.panelSubtitleFiletypes.add((Component)btnRemoveSubtitleFiletype, "6, 4, default, bottom");
        this.panelAudioFiletypes = new JPanel();
        this.add((Component)this.panelAudioFiletypes, "6, 2, fill, fill");
        this.panelAudioFiletypes.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("Settings.audiofiletypes"), 4, 2, null, null));
        this.panelAudioFiletypes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JScrollPane scrollPaneAudioFiletypes = new JScrollPane();
        this.panelAudioFiletypes.add((Component)scrollPaneAudioFiletypes, "2, 2, 5, 1, fill, fill");
        this.listAudioFiletypes = new JList();
        scrollPaneAudioFiletypes.setViewportView(this.listAudioFiletypes);
        this.tfAudioFiletype = new JTextField();
        this.panelAudioFiletypes.add((Component)this.tfAudioFiletype, "2, 4, fill, default");
        this.tfAudioFiletype.setColumns(10);
        JButton btnAddAudioFiletype = new JButton(IconManager.LIST_ADD);
        btnAddAudioFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddAudioFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)FileTypesSettingsPanel.this.tfAudioFiletype.getText())) {
                    Globals.settings.addAudioFileTypes(FileTypesSettingsPanel.this.tfAudioFiletype.getText());
                    FileTypesSettingsPanel.this.tfAudioFiletype.setText("");
                }
            }
        });
        this.panelAudioFiletypes.add((Component)btnAddAudioFiletype, "4, 4");
        JButton btnRemoveAudioFiletype = new JButton(IconManager.LIST_REMOVE);
        btnRemoveAudioFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveAudioFiletype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = FileTypesSettingsPanel.this.listAudioFiletypes.getSelectedIndex();
                if (row != -1) {
                    String prefix = Globals.settings.getAudioFileType().get(row);
                    Globals.settings.removeAudioFileType(prefix);
                }
            }
        });
        this.panelAudioFiletypes.add((Component)btnRemoveAudioFiletype, "6, 4, default, bottom");
        JPanel panelSortOptions = new JPanel();
        panelSortOptions.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("Settings.sorting"), 4, 2, null, null));
        this.add((Component)panelSortOptions, "2, 4, 3, 1, fill, fill");
        panelSortOptions.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JScrollPane scrollPaneSortPrefixes = new JScrollPane();
        panelSortOptions.add((Component)scrollPaneSortPrefixes, "2, 2, 5, 1, fill, fill");
        this.listSortPrefixes = new JList();
        scrollPaneSortPrefixes.setViewportView(this.listSortPrefixes);
        this.tfSortPrefix = new JTextField();
        panelSortOptions.add((Component)this.tfSortPrefix, "2, 4, fill, default");
        this.tfSortPrefix.setColumns(10);
        JButton btnAddSortPrefix = new JButton(IconManager.LIST_ADD);
        btnAddSortPrefix.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddSortPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)FileTypesSettingsPanel.this.tfSortPrefix.getText())) {
                    Globals.settings.addTitlePrefix(FileTypesSettingsPanel.this.tfSortPrefix.getText());
                    FileTypesSettingsPanel.this.tfSortPrefix.setText("");
                    MovieList.getInstance().invalidateTitleSortable();
                    TvShowList.getInstance().invalidateTitleSortable();
                }
            }
        });
        panelSortOptions.add((Component)btnAddSortPrefix, "4, 4");
        JButton btnRemoveSortPrefix = new JButton(IconManager.LIST_REMOVE);
        btnRemoveSortPrefix.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveSortPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = FileTypesSettingsPanel.this.listSortPrefixes.getSelectedIndex();
                if (row != -1) {
                    String prefix = Globals.settings.getTitlePrefix().get(row);
                    Globals.settings.removeTitlePrefix(prefix);
                    MovieList.getInstance().invalidateTitleSortable();
                    TvShowList.getInstance().invalidateTitleSortable();
                }
            }
        });
        panelSortOptions.add((Component)btnRemoveSortPrefix, "6, 4, default, bottom");
        JTextPane tpSortingHints = new JTextPane();
        TmmFontHelper.changeFont((JComponent)tpSortingHints, 0.833);
        tpSortingHints.setText(BUNDLE.getString("Settings.sorting.info"));
        tpSortingHints.setBackground(UIManager.getColor("Panel.background"));
        panelSortOptions.add((Component)tpSortingHints, "2, 6, 3, 1, fill, fill");
        this.initDataBindings();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"videoFileType");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (JList)this.listVideoFiletypes);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"subtitleFileType");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (JList)this.listSubtitleFiletypes);
        jListBinding_2.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"titlePrefix");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (JList)this.listSortPrefixes);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"audioFileType");
        JListBinding jListBinding_3 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (JList)this.listAudioFiletypes);
        jListBinding_3.bind();
    }
}

