/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieFanartNaming;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MoviePosterNaming;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenamer.class);
    private static final Pattern ALPHANUM = Pattern.compile(".*?([a-zA-Z0-9]{1}).*$");

    private static void renameSubtitles(Movie m) {
        Set langArray = LanguageUtils.KEY_TO_LOCALE_MAP.keySet();
        for (MediaFile sub : m.getMediaFiles(MediaFileType.SUBTITLE)) {
            String forced;
            String lang;
            String originalLang;
            block19: {
                Object mfs;
                block18: {
                    originalLang = "";
                    lang = "";
                    forced = "";
                    List<MediaFileSubtitle> mfsl = sub.getSubtitles();
                    if (mfsl == null || mfsl.size() <= 0) break block18;
                    mfs = mfsl.get(0);
                    originalLang = ((MediaFileSubtitle)mfs).getLanguage();
                    if (!((MediaFileSubtitle)mfs).isForced()) break block19;
                    forced = ".forced";
                    break block19;
                }
                mfs = m.getMediaFiles(MediaFileType.VIDEO);
                String shortname = sub.getBasename().toLowerCase(Locale.ROOT);
                if (mfs != null && mfs.size() > 0) {
                    shortname = sub.getBasename().toLowerCase(Locale.ROOT).replace(m.getVideoBasenameWithoutStacking(), "");
                }
                if (sub.getFilename().toLowerCase(Locale.ROOT).contains("forced")) {
                    forced = ".forced";
                    shortname = shortname.replaceAll("\\p{Punct}*forced", "");
                }
                for (String s : langArray) {
                    if (!shortname.equalsIgnoreCase(s) && !shortname.matches("(?i).*[ _.-]+" + s + "$")) continue;
                    originalLang = s;
                    break;
                }
            }
            lang = LanguageStyle.getLanguageCodeForStyle(originalLang, MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerLanguageStyle());
            if (StringUtils.isBlank((CharSequence)lang)) {
                lang = originalLang;
            }
            String newSubName = "";
            if (sub.getStacking() == 0) {
                MediaFile mf = m.getMediaFiles(MediaFileType.VIDEO).get(0);
                newSubName = mf.getBasename();
                if (!lang.isEmpty()) {
                    newSubName = newSubName + "." + lang;
                }
                newSubName = newSubName + forced;
            } else {
                for (MediaFile mf : m.getMediaFiles(MediaFileType.VIDEO)) {
                    if (mf.getStacking() != sub.getStacking()) continue;
                    newSubName = mf.getBasename();
                    if (!lang.isEmpty()) {
                        newSubName = newSubName + "." + lang;
                    }
                    newSubName = newSubName + forced;
                }
            }
            newSubName = newSubName + "." + sub.getExtension();
            Path newFile = m.getPathNIO().resolve(newSubName);
            try {
                boolean ok = Utils.moveFileSafe(sub.getFileAsPath(), newFile);
                if (ok) {
                    if (sub.getFilename().endsWith(".sub")) {
                        try {
                            Path oldidx = sub.getFileAsPath().resolveSibling(sub.getFilename().toString().replaceFirst("sub$", "idx"));
                            Path newidx = newFile.resolveSibling(newFile.getFileName().toString().replaceFirst("sub$", "idx"));
                            Utils.moveFileSafe(oldidx, newidx);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    m.removeFromMediaFiles(sub);
                    MediaFile mf = new MediaFile(newFile);
                    MediaFileSubtitle mfs = new MediaFileSubtitle();
                    if (!lang.isEmpty()) {
                        mfs.setLanguage(lang);
                    }
                    if (!forced.isEmpty()) {
                        mfs.setForced(true);
                    }
                    mfs.setCodec(sub.getExtension());
                    mf.setContainerFormat(sub.getExtension());
                    mf.addSubtitle(mfs);
                    m.addToMediaFiles(mf);
                    continue;
                }
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, sub.getFilename(), "message.renamer.failedrename"));
            }
            catch (Exception e) {
                LOGGER.error("error moving subtitles", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)sub.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        m.saveToDb();
    }

    public static void renameMovie(Movie movie) {
        MediaFile del;
        boolean posterRenamed = false;
        boolean fanartRenamed = false;
        boolean downloadMissingArtworks = false;
        if (StringUtils.isEmpty((CharSequence)movie.getDataSource())) {
            LOGGER.error("no Datasource set");
            return;
        }
        if (movie.getTitle().isEmpty()) {
            LOGGER.error("won't rename movie '" + movie.getPathNIO() + "' / '" + movie.getTitle() + "' not even title is set?");
            return;
        }
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        LOGGER.info("Renaming movie: " + movie.getTitle());
        LOGGER.debug("movie year: " + movie.getYear());
        LOGGER.debug("movie path: " + movie.getPathNIO());
        LOGGER.debug("movie isDisc?: " + movie.isDisc());
        LOGGER.debug("movie isMulti?: " + movie.isMultiMovieDir());
        if (movie.getMovieSet() != null) {
            LOGGER.debug("movieset: " + movie.getMovieSet().getTitle());
        }
        LOGGER.debug("path expression: " + MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerPathname());
        LOGGER.debug("file expression: " + MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerFilename());
        String newPathname = MovieRenamer.createDestinationForFoldername(MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerPathname(), movie);
        String oldPathname = movie.getPathNIO().toString();
        if (!newPathname.isEmpty()) {
            newPathname = movie.getDataSource() + File.separator + newPathname;
            Path srcDir = movie.getPathNIO();
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().equals(destDir.toAbsolutePath())) {
                boolean newDestIsMultiMovieDir = false;
                if (!MovieRenamer.isFolderPatternUnique(MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerPathname())) {
                    newDestIsMultiMovieDir = true;
                }
                LOGGER.debug("movie willBeMulti?: " + newDestIsMultiMovieDir);
                if (!movie.isMultiMovieDir() && !newDestIsMultiMovieDir) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = Utils.moveDirectorySafe(srcDir, destDir);
                        if (bl) {
                            movie.setMultiMovieDir(false);
                            movie.updateMediaFilePath(srcDir, destDir);
                            movie.setPath(newPathname);
                            movie.saveToDb();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error moving folder: ", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (!bl) {
                        LOGGER.error("Could not move to destination '" + destDir + "' - NOT renaming folder");
                        return;
                    }
                } else if (movie.isMultiMovieDir() && !newDestIsMultiMovieDir) {
                    LOGGER.trace("Upgrading movie into it's own dir :) " + newPathname);
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(destDir, new FileAttribute[0]);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Could not create destination '" + destDir + "' - NOT renaming folder ('upgrade' movie)");
                            return;
                        }
                    } else {
                        LOGGER.error("Directory already exists! '" + destDir + "' - NOT renaming folder ('upgrade' movie)");
                        return;
                    }
                    movie.setMultiMovieDir(false);
                    downloadMissingArtworks = true;
                } else {
                    LOGGER.trace("New movie path is a MMD :( " + newPathname);
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(destDir, new FileAttribute[0]);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Could not create destination '" + destDir + "' - NOT renaming folder ('MMD' movie)");
                            return;
                        }
                    }
                    movie.setMultiMovieDir(true);
                }
            }
        } else {
            LOGGER.info("Folder rename settings were empty - NOT renaming folder");
            newPathname = movie.getPathNIO().toString();
        }
        for (MovieNfoNaming movieNfoNaming : MovieNfoNaming.values()) {
            String nfoFilename = movie.getNfoFilename(movieNfoNaming);
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            MediaFile del2 = new MediaFile(movie.getPathNIO().resolve(nfoFilename), MediaFileType.NFO);
            cleanup.add(del2);
        }
        for (Enum enum_ : MoviePosterNaming.values()) {
            del = new MediaFile(movie.getPathNIO().resolve(MovieRenamer.replaceInvalidCharacters(MovieArtworkHelper.getPosterFilename((MoviePosterNaming)enum_, movie))), MediaFileType.POSTER);
            cleanup.add(del);
        }
        for (Enum enum_ : MovieFanartNaming.values()) {
            del = new MediaFile(movie.getPathNIO().resolve(MovieRenamer.replaceInvalidCharacters(MovieArtworkHelper.getFanartFilename((MovieFanartNaming)enum_, movie))), MediaFileType.FANART);
            cleanup.add(del);
        }
        for (MediaFile del3 : movie.getMediaFiles()) {
            cleanup.add(new MediaFile(del3));
        }
        cleanup.removeAll(Collections.singleton(null));
        String newVideoBasename = "";
        if (!MovieRenamer.isFilePatternValid()) {
            newVideoBasename = movie.getVideoBasenameWithoutStacking();
            LOGGER.warn("Filepattern is not valid - NOT renaming files!");
        } else {
            MediaFile ftr = MovieRenamer.generateFilename(movie, movie.getMediaFiles(MediaFileType.VIDEO).get(0), newVideoBasename).get(0);
            newVideoBasename = FilenameUtils.getBaseName((String)ftr.getFilenameWithoutStacking());
        }
        LOGGER.debug("Our new basename for renaming: " + newVideoBasename);
        for (MediaFile vid : movie.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 " + (Object)((Object)vid.getType()) + " " + vid.getFileAsPath());
            MediaFile mediaFile = MovieRenamer.generateFilename(movie, vid, newVideoBasename).get(0);
            boolean ok = MovieRenamer.moveFile(vid.getFileAsPath(), mediaFile.getFileAsPath());
            if (ok) {
                vid.setFile(mediaFile.getFileAsPath());
            }
            needed.add(vid);
        }
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.FANART));
        mfs.add(movie.getNewestMediaFilesOfType(MediaFileType.POSTER));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile : mfs) {
            LOGGER.trace("Rename 1:N " + (Object)((Object)mediaFile.getType()) + " " + mediaFile.getFileAsPath());
            ArrayList<MediaFile> newMFs = MovieRenamer.generateFilename(movie, mediaFile, newVideoBasename);
            for (MediaFile newMF : newMFs) {
                posterRenamed = true;
                fanartRenamed = true;
                boolean ok = MovieRenamer.copyFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                needed.add(newMF);
            }
        }
        MediaFile nfo = new MediaFile();
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
            if (mf.getFiledate() < nfo.getFiledate() || !MovieConnectors.isValidNFO(mf.getFileAsPath())) continue;
            nfo = new MediaFile(mf);
        }
        if (nfo.getFiledate() > 0L) {
            ArrayList<MediaFile> arrayList = MovieRenamer.generateFilename(movie, nfo, newVideoBasename);
            if (arrayList.size() > 0) {
                for (MediaFile newNFO : arrayList) {
                    boolean ok = MovieRenamer.copyFile(nfo.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    needed.add(newNFO);
                }
            } else {
                cleanup.add(nfo);
            }
        } else {
            LOGGER.trace("No valid NFO found for this movie");
        }
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
            if (MovieConnectors.isValidNFO(mf.getFileAsPath())) {
                cleanup.add(mf);
                continue;
            }
            if (MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerNfoCleanup()) {
                cleanup.add(mf);
                continue;
            }
            needed.add(mf);
        }
        mfs = new ArrayList();
        mfs.addAll(movie.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.SUBTITLE));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile other : mfs) {
            LOGGER.trace("Rename 1:1 " + (Object)((Object)other.getType()) + " " + other.getFileAsPath());
            ArrayList<MediaFile> newMFs = MovieRenamer.generateFilename(movie, other, newVideoBasename);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = MovieRenamer.copyFile(other.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(other);
            }
        }
        needed.addAll(movie.getMediaFiles(MediaFileType.SUBTITLE));
        for (MediaFile gfx : movie.getMediaFiles()) {
            if (!gfx.isGraphic()) continue;
            ImageCache.invalidateCachedImage(gfx.getFileAsPath());
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(linkedHashSet);
        movie.removeAllMediaFiles();
        movie.addToMediaFiles(needed);
        movie.setPath(newPathname);
        for (MovieActor actor : movie.getActors()) {
            actor.setEntityRoot(newPathname);
        }
        movie.saveToDb();
        MovieRenamer.renameSubtitles(movie);
        movie.gatherMediaFileInformation(false);
        if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.MP && (posterRenamed || fanartRenamed)) {
            movie.writeNFO();
        }
        movie.saveToDb();
        LOGGER.info("Cleanup...");
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            if (needed.contains(cleanup.get(i))) continue;
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (cl.getFileAsPath().equals(Paths.get(movie.getDataSource(), new String[0])) || cl.getFileAsPath().equals(movie.getPathNIO()) || cl.getFileAsPath().equals(Paths.get(oldPathname, new String[0]))) {
                LOGGER.warn("Wohoo! We tried to remove complete datasource / movie folder. Nooo way...! " + (Object)((Object)cl.getType()) + ": " + cl.getFileAsPath());
                continue;
            }
            if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                LOGGER.debug("Deleting " + cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), movie.getDataSource());
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory " + cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (downloadMissingArtworks) {
            LOGGER.debug("Yay - movie upgrade :) download missing artworks");
            MovieArtworkHelper.downloadMissingArtwork(movie);
        }
    }

    public static ArrayList<MediaFile> generateFilename(Movie movie, MediaFile mf, String videoFileName) {
        ArrayList<MediaFile> newFiles = new ArrayList<MediaFile>();
        boolean newDestIsMultiMovieDir = movie.isMultiMovieDir();
        String newPathname = "";
        String pattern = MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerPathname();
        if (!pattern.isEmpty()) {
            newDestIsMultiMovieDir = !MovieRenamer.isFolderPatternUnique(pattern);
            newPathname = MovieRenamer.createDestinationForFoldername(pattern, movie);
        } else {
            newPathname = Utils.relPath(Paths.get(movie.getDataSource(), new String[0]), movie.getPathNIO());
        }
        Path newMovieDir = Paths.get(movie.getDataSource(), newPathname);
        String newFilename = videoFileName;
        if (newFilename == null || newFilename.isEmpty()) {
            newFilename = MovieRenamer.createDestinationForFilename(MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerFilename(), movie);
        }
        if (!MovieRenamer.isFilePatternValid() && !movie.isDisc()) {
            MediaFile newMF = new MediaFile(mf);
            newMF.setPath(newMovieDir.toString());
            newFiles.add(newMF);
            return newFiles;
        }
        MediaFile defaultMF = null;
        String defaultMFext = "";
        defaultMF = new MediaFile(mf);
        defaultMF.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
        defaultMFext = "." + FilenameUtils.getExtension((String)defaultMF.getFilename());
        switch (mf.getType()) {
            case VIDEO: {
                MediaFile vid = new MediaFile(mf);
                if (movie.isDisc() || mf.isDiscFile()) {
                    vid.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                } else {
                    newFilename = newFilename + MovieRenamer.getStackingString(mf);
                    newFilename = newFilename + "." + mf.getExtension();
                    vid.setFile(newMovieDir.resolve(newFilename));
                }
                newFiles.add(vid);
                break;
            }
            case TRAILER: {
                MediaFile trail = new MediaFile(mf);
                newFilename = newFilename + "-trailer." + mf.getExtension();
                trail.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(trail);
                break;
            }
            case SAMPLE: {
                MediaFile sample = new MediaFile(mf);
                newFilename = newFilename + "-sample." + mf.getExtension();
                sample.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(sample);
                break;
            }
            case MEDIAINFO: {
                MediaFile mi = new MediaFile(mf);
                if (movie.isDisc()) {
                    mi.replacePathForRenamedFolder(movie.getPathNIO(), newMovieDir);
                    newFiles.add(mi);
                    break;
                }
                newFilename = newFilename + MovieRenamer.getStackingString(mf);
                newFilename = newFilename + "-mediainfo." + mf.getExtension();
                mi.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(mi);
                break;
            }
            case VSMETA: {
                MediaFile meta = new MediaFile(mf);
                if (movie.isDisc()) {
                    meta.setFile(newMovieDir.resolve(meta.getFilename()));
                    newFiles.add(meta);
                    break;
                }
                newFilename = newFilename + MovieRenamer.getStackingString(mf);
                String videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                newFilename = newFilename + "." + videoExt + ".vsmeta";
                meta.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(meta);
                break;
            }
            case SUBTITLE: {
                List<MediaFileSubtitle> mfsl = mf.getSubtitles();
                newFilename = newFilename + MovieRenamer.getStackingString(mf);
                if (mfsl != null && mfsl.size() > 0) {
                    MediaFileSubtitle mfs = mfsl.get(0);
                    if (!mfs.getLanguage().isEmpty()) {
                        String lang = LanguageStyle.getLanguageCodeForStyle(mfs.getLanguage(), MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = mfs.getLanguage();
                        }
                        newFilename = newFilename + "." + lang;
                    }
                    if (mfs.isForced()) {
                        newFilename = newFilename + ".forced";
                    }
                }
                newFilename = newFilename + "." + mf.getExtension();
                MediaFile sub = new MediaFile(mf);
                sub.setFile(newMovieDir.resolve(newFilename));
                newFiles.add(sub);
                break;
            }
            case NFO: {
                if (MovieConnectors.isValidNFO(mf.getFileAsPath())) {
                    List<Object> nfonames = new ArrayList<MovieNfoNaming>();
                    if (newDestIsMultiMovieDir) {
                        nfonames.add((Object)MovieNfoNaming.FILENAME_NFO);
                    } else {
                        nfonames = MovieModuleManager.MOVIE_SETTINGS.getMovieNfoFilenames();
                    }
                    for (MovieNfoNaming movieNfoNaming : nfonames) {
                        String newNfoName = movie.getNfoFilename(movieNfoNaming, newFilename + ".avi");
                        if (newNfoName.isEmpty()) continue;
                        MediaFile nfo = new MediaFile(mf);
                        nfo.setFile(newMovieDir.resolve(newNfoName));
                        newFiles.add(nfo);
                    }
                    break;
                }
                if (MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerNfoCleanup()) break;
                newFiles.add(new MediaFile(mf));
                break;
            }
            case POSTER: {
                for (MoviePosterNaming name : MovieArtworkHelper.getPosterNamesForMovie(movie)) {
                    String string = MovieArtworkHelper.getPosterFilename(name, movie, newFilename);
                    if (string != null && !string.isEmpty()) {
                        String curExt = mf.getExtension().replaceAll("jpeg", "jpg");
                        if (curExt.equalsIgnoreCase("tbn")) {
                            String cont = mf.getContainerFormat();
                            if (cont.equalsIgnoreCase("PNG")) {
                                curExt = "png";
                            } else if (cont.equalsIgnoreCase("JPEG")) {
                                curExt = "jpg";
                            }
                        }
                        if (!curExt.equals(FilenameUtils.getExtension((String)string))) continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile pos = new MediaFile(mf);
                    pos.setFile(newMovieDir.resolve(string));
                    newFiles.add(pos);
                }
                break;
            }
            case FANART: {
                for (MovieFanartNaming name : MovieArtworkHelper.getFanartNamesForMovie(movie)) {
                    String string = MovieArtworkHelper.getFanartFilename(name, movie, newFilename);
                    if (string != null && !string.isEmpty()) {
                        String curExt = mf.getExtension().replaceAll("jpeg", "jpg");
                        if (curExt.equalsIgnoreCase("tbn")) {
                            String cont = mf.getContainerFormat();
                            if (cont.equalsIgnoreCase("PNG")) {
                                curExt = "png";
                            } else if (cont.equalsIgnoreCase("JPEG")) {
                                curExt = "jpg";
                            }
                        }
                        if (!curExt.equals(FilenameUtils.getExtension((String)string))) continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    MediaFile fan = new MediaFile(mf);
                    fan.setFile(newMovieDir.resolve(string));
                    newFiles.add(fan);
                }
                break;
            }
            case BANNER: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageBanner()) break;
                defaultMFext = defaultMFext.toLowerCase(Locale.ROOT).replaceAll("jpeg", "jpg");
                if (newDestIsMultiMovieDir) {
                    defaultMF.setFilename(newFilename + "-" + mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                } else {
                    defaultMF.setFilename(mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                }
                newFiles.add(defaultMF);
                break;
            }
            case CLEARART: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageClearart()) break;
                defaultMFext = defaultMFext.toLowerCase(Locale.ROOT).replaceAll("jpeg", "jpg");
                if (newDestIsMultiMovieDir) {
                    defaultMF.setFilename(newFilename + "-" + mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                } else {
                    defaultMF.setFilename(mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                }
                newFiles.add(defaultMF);
                break;
            }
            case DISCART: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageDiscart()) break;
                defaultMFext = defaultMFext.toLowerCase(Locale.ROOT).replaceAll("jpeg", "jpg");
                if (newDestIsMultiMovieDir) {
                    defaultMF.setFilename(newFilename + "-disc" + defaultMFext);
                } else {
                    defaultMF.setFilename("disc" + defaultMFext);
                }
                newFiles.add(defaultMF);
                break;
            }
            case LOGO: 
            case CLEARLOGO: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageLogo()) break;
                defaultMFext = defaultMFext.toLowerCase(Locale.ROOT).replaceAll("jpeg", "jpg");
                if (newDestIsMultiMovieDir) {
                    defaultMF.setFilename(newFilename + "-" + mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                } else {
                    defaultMF.setFilename(mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                }
                newFiles.add(defaultMF);
                break;
            }
            case THUMB: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageThumb()) break;
                defaultMFext = defaultMFext.toLowerCase(Locale.ROOT).replaceAll("jpeg", "jpg");
                if (newDestIsMultiMovieDir) {
                    defaultMF.setFilename(newFilename + "-" + mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                } else {
                    defaultMF.setFilename(mf.getType().name().toLowerCase(Locale.ROOT) + defaultMFext);
                }
                newFiles.add(defaultMF);
                break;
            }
            case EXTRAFANART: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart() || newDestIsMultiMovieDir) break;
                newFiles.add(defaultMF);
                break;
            }
            case EXTRATHUMB: {
                if (!MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() || newDestIsMultiMovieDir) break;
                newFiles.add(defaultMF);
                break;
            }
            default: {
                newFiles.add(defaultMF);
            }
        }
        return newFiles;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = " ";
        if (MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerSpaceSubstitution()) {
            delimiter = MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String createDestinationForFilename(String template, Movie movie) {
        Pattern regex = Pattern.compile("\\{(.*?)\\}");
        Matcher mat = regex.matcher(template);
        while (mat.find()) {
            template = template.replace(mat.group(0), MovieRenamer.replaceOptionalVariable(mat.group(1), movie, true));
        }
        return MovieRenamer.createDestination(template, movie, true);
    }

    public static String createDestinationForFoldername(String template, Movie movie) {
        Pattern regex = Pattern.compile("\\{(.*?)\\}");
        Matcher mat = regex.matcher(template);
        while (mat.find()) {
            template = template.replace(mat.group(0), MovieRenamer.replaceOptionalVariable(mat.group(1), movie, false));
        }
        return MovieRenamer.createDestination(template, movie, false);
    }

    private static String replaceOptionalVariable(String s, Movie movie, boolean forFilename) {
        Pattern regex = Pattern.compile("\\$.{1}");
        Matcher mat = regex.matcher(s);
        if (mat.find()) {
            String rep = MovieRenamer.createDestination(mat.group(), movie, forFilename);
            if (rep.isEmpty()) {
                return "";
            }
            return s.replace(mat.group(), rep);
        }
        return "";
    }

    public static String getTokenValue(Movie movie, String token) {
        String ret = "";
        MediaFile mf = new MediaFile();
        if (movie.getMediaFiles(MediaFileType.VIDEO).size() > 0) {
            mf = movie.getMediaFiles(MediaFileType.VIDEO).get(0);
        }
        switch (token.toUpperCase(Locale.ROOT)) {
            case "$T": {
                ret = movie.getTitle();
                break;
            }
            case "$1": {
                ret = MovieRenamer.getFirstAlphaNum(movie.getTitle());
                break;
            }
            case "$2": {
                ret = MovieRenamer.getFirstAlphaNum(movie.getTitleSortable());
                break;
            }
            case "$Y": {
                ret = movie.getYear().equals("0") ? "" : movie.getYear();
                break;
            }
            case "$O": {
                ret = movie.getOriginalTitle();
                break;
            }
            case "$M": {
                if (movie.getMovieSet() == null || movie.getMovieSet().getMovies().size() <= 1 && !MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerCreateMoviesetForSingleMovie()) break;
                ret = movie.getMovieSet().getTitleSortable();
                break;
            }
            case "$N": {
                if (movie.getMovieSet() == null || movie.getMovieSet().getMovies().size() <= 1 && !MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerCreateMoviesetForSingleMovie()) break;
                ret = movie.getMovieSet().getTitle();
                break;
            }
            case "$I": {
                ret = movie.getImdbId();
                break;
            }
            case "$E": {
                ret = movie.getTitleSortable();
                break;
            }
            case "$L": {
                ret = movie.getSpokenLanguages();
                break;
            }
            case "$C": {
                if (movie.getCertification() == Certification.NOT_RATED) break;
                ret = movie.getCertification().getName();
                break;
            }
            case "$U": {
                if (movie.getEdition() == MovieEdition.NONE) break;
                ret = movie.getEditionAsString();
                break;
            }
            case "$G": {
                if (movie.getGenres().isEmpty()) break;
                MediaGenres genre = movie.getGenres().get(0);
                ret = genre.getLocalizedName();
                break;
            }
            case "$D": {
                ret = movie.getDirector();
                break;
            }
            case "$R": {
                ret = mf.getVideoResolution();
                break;
            }
            case "$3": {
                if (StringUtils.isNotBlank((CharSequence)mf.getVideo3DFormat())) {
                    ret = mf.getVideo3DFormat();
                    break;
                }
                if (!movie.isVideoIn3D()) break;
                ret = "3D";
                break;
            }
            case "$A": {
                ret = mf.getAudioCodec() + (mf.getAudioCodec().isEmpty() ? "" : "-") + mf.getAudioChannels();
                break;
            }
            case "$V": {
                ret = mf.getVideoCodec() + (mf.getVideoCodec().isEmpty() ? "" : "-") + mf.getVideoFormat();
                break;
            }
            case "$F": {
                ret = mf.getVideoFormat();
                break;
            }
            case "$S": {
                if (movie.getMediaSource() == MediaSource.UNKNOWN) break;
                ret = movie.getMediaSource().toString();
                break;
            }
            case "$#": {
                if (!(movie.getRating() > 0.0f)) break;
                ret = String.valueOf(movie.getRating());
                break;
            }
            case "$K": {
                if (movie.getTags().isEmpty()) break;
                ret = movie.getTags().get(0);
            }
        }
        return ret;
    }

    protected static String getFirstAlphaNum(String text) {
        Matcher m;
        if (StringUtils.isNotBlank((CharSequence)text) && (m = ALPHANUM.matcher(text)).find()) {
            return m.group(1).toUpperCase(Locale.ROOT);
        }
        return "";
    }

    public static String createDestination(String template, Movie movie, boolean forFilename) {
        String newDestination = template;
        Pattern p = Pattern.compile("(\\$[\\w#])");
        Matcher m = p.matcher(template);
        while (m.find()) {
            String value = MovieRenamer.getTokenValue(movie, m.group(1));
            newDestination = MovieRenamer.replaceToken(newDestination, m.group(1), value);
        }
        newDestination = newDestination.replaceAll("\\(\\)", "");
        newDestination = newDestination.replaceAll("\\[\\]", "");
        newDestination = newDestination.replaceAll("\\{\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+\\\\", "\\\\");
                newDestination = newDestination.replaceAll("\\\\\\s+", "\\\\");
            }
            newDestination = newDestination.replaceAll("\\\\{2,}", "\\\\");
            newDestination = newDestination.replaceAll("^\\\\", "");
        } else {
            if (!forFilename) {
                newDestination = newDestination.replaceAll("\\s+/", "/");
                newDestination = newDestination.replaceAll("/\\s+", "/");
            }
            newDestination = newDestination.replaceAll("/{2,}", "/");
            newDestination = newDestination.replaceAll("^/", "");
        }
        if (forFilename) {
            newDestination = newDestination.replaceAll("\\/", " ");
            newDestination = newDestination.replaceAll("\\\\", " ");
        }
        newDestination = newDestination.replaceAll(" +", " ").trim();
        if (MovieModuleManager.MOVIE_SETTINGS.isMovieRenamerSpaceSubstitution()) {
            String replacement = MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerSpaceReplacement();
            newDestination = newDestination.replace(" ", replacement);
            newDestination = newDestination.replaceAll(Pattern.quote(replacement) + "+", replacement);
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isAsciiReplacement()) {
            newDestination = StrgUtils.convertToAscii((String)newDestination, (boolean)false);
        }
        if (forFilename) {
            newDestination = newDestination.replaceAll("[ \\.]+$", "");
        }
        return newDestination.trim();
    }

    private static String replaceToken(String destination, String token, String replacement) {
        String replacingCleaned = "";
        if (StringUtils.isNotBlank((CharSequence)replacement)) {
            replacingCleaned = MovieRenamer.replaceInvalidCharacters(replacement);
        }
        return destination.replace(token, replacingCleaned);
    }

    public static String replaceInvalidCharacters(String source) {
        source = source.replaceAll(": ", " - ");
        source = source.replaceAll(":", "-");
        return source.replaceAll("([\"\\\\:<>|/?*])", "");
    }

    private static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move MF '" + oldFilename + "' to '" + newFilename + "'");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving file", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    private static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.info("copy file " + oldFilename + " to " + newFilename);
            if (oldFilename.equals(newFilename)) {
                return MovieRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFolderPatternUnique(String pattern) {
        return (pattern.contains("$T") || pattern.contains("$E") || pattern.contains("$O")) && pattern.contains("$Y") || pattern.contains("$I");
    }

    public static boolean isFilePatternValid() {
        String pattern = MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerFilename().toUpperCase(Locale.ROOT).trim();
        return pattern.contains("$T") || pattern.contains("$E") || pattern.contains("$O");
    }
}

