/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util.uri;

import java.net.URI;
import java.net.URISyntaxException;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.util.uri.URIUtil;

public class ClassURI
extends URIUtil {
    public static final URI CLASSPATH = URI.create("classpath://*");
    private final Class<? extends Plugin> clazz;

    public static final URI CLASSPATH(String pattern) {
        return URI.create("classpath://" + pattern);
    }

    public static final URI PLUGIN(Class<? extends Plugin> clazz) {
        return new ClassURI(clazz).toURI();
    }

    public ClassURI(Class<? extends Plugin> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("The paramter must be a concrete plugin class, not a plugin interface.");
        }
        this.clazz = clazz;
    }

    @Override
    public URI toURI() {
        try {
            return new URI("classpath://" + this.clazz.getCanonicalName());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

