/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.w3c.dom.Document;

public class KodiMovieMetadataProvider
extends AbstractKodiMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiMovieMetadataProvider.class);

    public KodiMovieMetadataProvider(KodiScraper scraper) {
        super(scraper);
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("Kodi: getMetadata(): " + options);
        if (options.getResult() == null || !this.scraper.getProviderInfo().getId().equals(options.getResult().getProviderId())) {
            throw new Exception("scraping with Kodi scrapers only with a prior result possible");
        }
        return this._getMetadata(options);
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        return this._search(options);
    }

    @Override
    protected void processXmlContent(String xmlDetails, MediaMetadata md, MediaSearchResult result) throws Exception {
        if (xmlDetails == null || StringUtils.isEmpty((CharSequence)xmlDetails)) {
            LOGGER.warn("Cannot process empty Xml Contents.");
            return;
        }
        LOGGER.trace("******* BEGIN XML ***********");
        LOGGER.trace(xmlDetails);
        LOGGER.trace("******* END XML ***********");
        Document xml = this.parseXmlString(xmlDetails);
        this.addMetadata(md, xml.getDocumentElement());
    }

    public List<IMediaProvider> getPluginsForType(MediaType type) {
        return this.getPluginsForType(type);
    }
}

