/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.panels.ImagePanel;
import org.tinymediamanager.ui.tvshows.TvShowCastPanel;
import org.tinymediamanager.ui.tvshows.TvShowDetailsPanel;
import org.tinymediamanager.ui.tvshows.TvShowMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JSplitPane splitPaneVertical;
    private JTabbedPane tabbedPaneTvShowDetails;
    private JPanel panelTop;
    private JPanel panelTvShowLogos;
    private StarRater panelRatingStars;
    private JLabel lblTvShowName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblCertificationImage;
    private ImageLabel lblTvShowBackground;
    private JLabel lblFanartSize;
    private ImageLabel lblTvShowPoster;
    private JLabel lblPosterSize;
    private ImageLabel lblTvShowBanner;
    private JLabel lblBannerSize;
    private JPanel panelBottom;
    private JTextPane tpOverview;
    private JPanel panelMediaInformation;
    private JPanel panelRight;
    private JPanel panelLeft;
    private JLabel lblPlot;
    private JSeparator separator;
    private JSeparator separator_1;
    private TvShowSelectionModel tvShowSelectionModel;

    public TvShowInformationPanel(TvShowSelectionModel tvShowSelectionModel) {
        this.tvShowSelectionModel = tvShowSelectionModel;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow(4)")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.panelLeft = new JPanel();
        this.add((Component)this.panelLeft, "1, 1, fill, fill");
        this.panelLeft.setLayout(new ColumnLayout());
        this.lblTvShowPoster = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 2.0 * 3.0) + 1);
            }
        };
        this.lblTvShowPoster.setDesiredAspectRatio(0.6666667f);
        this.panelLeft.add(this.lblTvShowPoster);
        this.lblTvShowPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblTvShowPoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        this.panelLeft.add(this.lblPosterSize);
        this.panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowBackground = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 16.0 * 9.0) + 1);
            }
        };
        this.lblTvShowBackground.setDesiredAspectRatio(1.7777778f);
        this.panelLeft.add(this.lblTvShowBackground);
        this.lblTvShowBackground.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblTvShowBackground.enableLightbox();
        this.lblFanartSize = new JLabel(BUNDLE.getString("mediafiletype.fanart"));
        this.panelLeft.add(this.lblFanartSize);
        this.panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowBanner = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 25.0 * 8.0) + 1);
            }
        };
        this.lblTvShowBanner.setDesiredAspectRatio(3.125f);
        this.panelLeft.add(this.lblTvShowBanner);
        this.lblTvShowBanner.setAlternativeText(BUNDLE.getString("image.notfound.banner"));
        this.lblTvShowBanner.enableLightbox();
        this.lblBannerSize = new JLabel(BUNDLE.getString("mediafiletype.banner"));
        this.panelLeft.add(this.lblBannerSize);
        this.panelRight = new JPanel();
        this.add((Component)this.panelRight, "3, 1, fill, fill");
        this.panelRight.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.splitPaneVertical = new JSplitPane();
        this.panelRight.add((Component)this.splitPaneVertical, "1, 1, fill, fill");
        this.splitPaneVertical.setBorder(null);
        this.splitPaneVertical.setResizeWeight(0.9);
        this.splitPaneVertical.setContinuousLayout(true);
        this.splitPaneVertical.setOneTouchExpandable(true);
        this.splitPaneVertical.setOrientation(0);
        this.panelTop = new JPanel();
        this.panelTop.setBorder(null);
        this.splitPaneVertical.setTopComponent(this.panelTop);
        this.panelTop.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"fill:default"), FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:50px:grow(2)")}));
        JPanel panelTvShowHeader = new JPanel();
        this.panelTop.add((Component)panelTvShowHeader, "2, 1, 3, 1, fill, top");
        panelTvShowHeader.setBorder(null);
        panelTvShowHeader.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"min:grow"), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JPanel panelTvShowTitle = new JPanel();
        panelTvShowHeader.add((Component)panelTvShowTitle, "1, 1, fill, top");
        panelTvShowTitle.setLayout(new BorderLayout(0, 0));
        this.lblTvShowName = new JLabel("");
        panelTvShowTitle.add(this.lblTvShowName);
        TmmFontHelper.changeFont(this.lblTvShowName, 1.33, 1);
        JPanel panelRatingTagline = new JPanel();
        panelTvShowHeader.add((Component)panelRatingTagline, "1, 2, fill, top");
        panelRatingTagline.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"24px")}));
        this.lblRating = new JLabel("");
        panelRatingTagline.add((Component)this.lblRating, "2, 2, left, center");
        this.lblVoteCount = new JLabel("");
        panelRatingTagline.add((Component)this.lblVoteCount, "3, 2, left, center");
        this.panelRatingStars = new StarRater(10, 1);
        panelRatingTagline.add((Component)this.panelRatingStars, "1, 2, left, top");
        this.panelRatingStars.setEnabled(false);
        this.panelTvShowLogos = new JPanel();
        panelTvShowHeader.add((Component)this.panelTvShowLogos, "2, 1, 1, 2, fill, fill");
        this.lblCertificationImage = new JLabel();
        this.panelTvShowLogos.add(this.lblCertificationImage);
        this.separator_1 = new JSeparator();
        this.panelTop.add((Component)this.separator_1, "2, 4, 3, 1");
        TvShowDetailsPanel panelDetails = new TvShowDetailsPanel(tvShowSelectionModel);
        this.panelTop.add((Component)panelDetails, "2, 6, 3, 1");
        this.separator = new JSeparator();
        this.panelTop.add((Component)this.separator, "2, 8, 3, 1");
        this.lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        this.lblPlot.setFont(this.lblPlot.getFont().deriveFont(1));
        this.panelTop.add((Component)this.lblPlot, "2, 10, 3, 1");
        JPanel panelOverview = new JPanel();
        this.panelTop.add((Component)panelOverview, "2, 11, 3, 1, fill, fill");
        panelOverview.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        JScrollPane scrollPaneOverview = new JScrollPane();
        scrollPaneOverview.setBorder(null);
        panelOverview.add((Component)scrollPaneOverview, "1, 2, fill, fill");
        this.tpOverview = new JTextPane();
        this.tpOverview.setOpaque(false);
        this.tpOverview.setEditable(false);
        scrollPaneOverview.setViewportView(this.tpOverview);
        this.panelBottom = new JPanel();
        this.panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"min:grow")}));
        this.splitPaneVertical.setBottomComponent(this.panelBottom);
        this.tabbedPaneTvShowDetails = new JTabbedPane(1);
        this.panelBottom.add((Component)this.tabbedPaneTvShowDetails, "1, 2, fill, fill");
        TvShowCastPanel panelCast = new TvShowCastPanel(tvShowSelectionModel);
        this.tabbedPaneTvShowDetails.addTab(BUNDLE.getString("metatag.cast"), null, panelCast, null);
        this.panelMediaInformation = new TvShowMediaInformationPanel(tvShowSelectionModel);
        this.tabbedPaneTvShowDetails.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.panelMediaInformation, null);
        final ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        final ImagePanel panelArtwork = new ImagePanel(mediaFiles);
        this.tabbedPaneTvShowDetails.addTab(BUNDLE.getString("metatag.artwork"), null, panelArtwork, null);
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TvShow tvShow;
                List list;
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source instanceof TvShowSelectionModel) {
                    TvShowSelectionModel model = (TvShowSelectionModel)source;
                    TvShowInformationPanel.this.setFanart(model.getSelectedTvShow());
                    TvShowInformationPanel.this.setPoster(model.getSelectedTvShow());
                    TvShowInformationPanel.this.setBanner(model.getSelectedTvShow());
                    list = mediaFiles;
                    synchronized (list) {
                        mediaFiles.clear();
                        for (MediaFile mediafile : new ArrayList<MediaFile>(model.getSelectedTvShow().getMediaFiles())) {
                            if (!mediafile.isGraphic()) continue;
                            mediaFiles.add(mediafile);
                        }
                        panelArtwork.rebuildPanel();
                    }
                }
                if (source instanceof TvShow && "mediaFiles".equals(property)) {
                    TvShow show = (TvShow)source;
                    list = mediaFiles;
                    synchronized (list) {
                        mediaFiles.clear();
                        for (MediaFile mediafile : new ArrayList<MediaFile>(show.getMediaFiles())) {
                            if (!mediafile.isGraphic()) continue;
                            mediaFiles.add(mediafile);
                        }
                        panelArtwork.rebuildPanel();
                    }
                }
                if (source.getClass() == TvShow.class && "fanart".equals(property)) {
                    tvShow = (TvShow)source;
                    TvShowInformationPanel.this.setFanart(tvShow);
                }
                if (source.getClass() == TvShow.class && "poster".equals(property)) {
                    tvShow = (TvShow)source;
                    TvShowInformationPanel.this.setPoster(tvShow);
                }
                if (source.getClass() == TvShow.class && "banner".equals(property)) {
                    tvShow = (TvShow)source;
                    TvShowInformationPanel.this.setBanner(tvShow);
                }
            }
        };
        tvShowSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void setPoster(TvShow tvShow) {
        this.lblTvShowPoster.clearImage();
        this.lblTvShowPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        Dimension posterSize = tvShow.getArtworkDimension(MediaFileType.POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setFanart(TvShow tvShow) {
        this.lblTvShowBackground.clearImage();
        this.lblTvShowBackground.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        Dimension fanartSize = tvShow.getArtworkDimension(MediaFileType.FANART);
        if (fanartSize.width > 0 && fanartSize.height > 0) {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart") + " - " + fanartSize.width + "x" + fanartSize.height);
        } else {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart"));
        }
    }

    private void setBanner(TvShow tvShow) {
        this.lblTvShowBanner.clearImage();
        this.lblTvShowBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        Dimension bannerSize = tvShow.getArtworkDimension(MediaFileType.BANNER);
        if (bannerSize.width > 0 && bannerSize.height > 0) {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner") + " - " + bannerSize.width + "x" + bannerSize.height);
        } else {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.plot");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.tpOverview, (Property)jTextPaneBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.rating");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_2.bind();
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShow.certification");
        BeanProperty jLabelBeanProperty_2 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_8, (Object)this.lblCertificationImage, (Property)jLabelBeanProperty_2);
        autoBinding_9.setConverter((Converter)new CertificationImageConverter());
        autoBinding_9.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.votes");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_4.setConverter((Converter)new VoteCountConverter());
        autoBinding_4.bind();
    }
}

