/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.RoundedPanel;

public class MessagePanel
extends JPanel {
    private static final long serialVersionUID = -7224510527137312686L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JLabel lblTitle;
    private JTextPane tpMessage;
    private JLabel lblIcon;
    private JLabel lblDate;

    public MessagePanel(Message message) {
        this.setOpaque(false);
        this.initComponents();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.lblDate.setText(dateFormat.format(message.getMessageDate()));
        String text = "";
        if (message.getMessageSender() instanceof MediaEntity) {
            MediaEntity me = (MediaEntity)message.getMessageSender();
            text = me.getTitle();
        } else if (message.getMessageSender() instanceof MediaFile) {
            MediaFile mf = (MediaFile)message.getMessageSender();
            text = mf.getFilename();
        } else {
            try {
                text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageSender().toString()), message.getSenderParams());
            }
            catch (Exception e) {
                text = String.valueOf(message.getMessageSender());
            }
        }
        this.lblTitle.setText(text);
        text = "";
        try {
            text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageId()), message.getIdParams());
        }
        catch (Exception e) {
            text = message.getMessageId();
        }
        this.tpMessage.setText(text);
        switch (message.getMessageLevel()) {
            case ERROR: 
            case WARN: {
                this.lblIcon.setIcon(IconManager.ERROR);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:default"), FormSpecs.LINE_GAP_ROWSPEC}));
        this.lblDate = new JLabel("");
        this.add((Component)this.lblDate, "2, 1");
        RoundedPanel innerPanel = new RoundedPanel(){
            private static final long serialVersionUID = -6407635030887890673L;
            {
                this.arcs = new Dimension(10, 10);
                this.shady = false;
            }
        };
        this.add((Component)innerPanel, "2, 2, fill, default");
        innerPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        this.lblIcon = new JLabel("");
        this.lblIcon.setHorizontalAlignment(0);
        innerPanel.add((Component)this.lblIcon, "2, 2, 1, 3, center, center");
        this.lblTitle = new JLabel();
        TmmFontHelper.changeFont((JComponent)this.lblTitle, 1);
        innerPanel.add((Component)this.lblTitle, "4, 2, fill, default");
        this.tpMessage = new JTextPane();
        this.tpMessage.setOpaque(false);
        this.tpMessage.setEditable(false);
        innerPanel.add((Component)this.tpMessage, "4, 4, fill, fill");
    }
}

