/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.annotations.SupportsOption;
import net.jcores.jre.cores.CoreFile;
import net.jcores.jre.cores.CoreInputStream;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.OnFailure;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Options;
import net.jcores.jre.utils.internal.Streams;

public class CoreURI
extends CoreObject<URI> {
    private static final long serialVersionUID = 7366734773387957013L;

    public CoreURI(CommonCore commonCore, URI ... uRIArray) {
        super(commonCore, uRIArray);
    }

    public CoreURI(CommonCore commonCore, AbstractAdapter<URI> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    @SupportsOption(options={OnFailure.class})
    public CoreInputStream input(Option ... optionArray) {
        final Options options = Options.$(this.commonCore, optionArray);
        return new CoreInputStream(this.commonCore, this.map(new F1<URI, InputStream>(){

            @Override
            public InputStream f(URI uRI) {
                try {
                    URL uRL = uRI.toURL();
                    InputStream inputStream = uRL.openStream();
                    return inputStream;
                }
                catch (MalformedURLException malformedURLException) {
                    options.failure(uRI, malformedURLException, "input:urimalformed", "Malformed URI.");
                }
                catch (IOException iOException) {
                    options.failure(uRI, iOException, "input:ioerror", "Error opening the URI.");
                }
                return null;
            }
        }, new Option[0]).array(InputStream.class));
    }

    public CoreFile download() {
        final CommonCore commonCore = this.commonCore;
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI uRI) {
                try {
                    URL uRL = uRI.toURL();
                    InputStream inputStream = uRL.openStream();
                    File file = File.createTempFile("jcores.download.", ".tmp");
                    Streams.saveTo(inputStream, file);
                    inputStream.close();
                    return file;
                }
                catch (MalformedURLException malformedURLException) {
                    commonCore.report(MessageType.EXCEPTION, "URI " + uRI + " could not be transformed into an URL.");
                }
                catch (IOException iOException) {
                    commonCore.report(MessageType.EXCEPTION, "URI " + uRI + " could not be opened for reading.");
                }
                return null;
            }
        }, new Option[0]).array(File.class));
    }

    public CoreFile download(final String string) {
        new File(string).mkdirs();
        final CommonCore commonCore = this.commonCore;
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI uRI) {
                try {
                    String string2 = (String)CoreKeeper.$(uRI.getPath()).split("/").get(-1);
                    URL uRL = uRI.toURL();
                    InputStream inputStream = uRL.openStream();
                    File file = new File(string + "/" + string2);
                    Streams.saveTo(inputStream, file);
                    inputStream.close();
                    return file;
                }
                catch (MalformedURLException malformedURLException) {
                    commonCore.report(MessageType.EXCEPTION, "URI " + uRI + " could not be transformed into an URL.");
                }
                catch (IOException iOException) {
                    commonCore.report(MessageType.EXCEPTION, "URI " + uRI + " could not be opened for reading.");
                }
                return null;
            }
        }, new Option[0]).array(File.class));
    }

    public CoreFile file() {
        return new CoreFile(this.commonCore, this.map(new F1<URI, File>(){

            @Override
            public File f(URI uRI) {
                try {
                    return new File(uRI);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }, new Option[0]).array(File.class));
    }
}

